/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.model.Command;
import org.traccar.protocol.GranitProtocolDecoder;

public class GranitProtocolEncoder
extends BaseProtocolEncoder {
    public GranitProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeCommand(String commandString) {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeBytes(commandString.getBytes(StandardCharsets.US_ASCII));
        GranitProtocolDecoder.appendChecksum(buffer, commandString.length());
        return buffer;
    }

    @Override
    protected Object encodeCommand(Command command) {
        return switch (command.getType()) {
            case "deviceIdentification" -> this.encodeCommand("BB+IDNT");
            case "rebootDevice" -> this.encodeCommand("BB+RESET");
            case "positionSingle" -> this.encodeCommand("BB+RRCD");
            default -> null;
        };
    }
}

