/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.nodes;

import java.beans.Introspector;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class NodesRegistrationSupport {
    static final String PE_LOOKUP_PATH = "Services/PropertyEditorManager";
    static final String BEANINFO_LOOKUP_PATH = "Services/Introspector";
    static final String PACKAGE = "packagePath";
    static final String EDITOR_CLASS = "propertyEditorClass";
    private static AbstractRegistrator clsReg = null;
    private static AbstractRegistrator beanInfoReg = null;
    private static AbstractRegistrator pkgReg = null;
    private static List<String> originalPath = null;
    private static List<String> originalBeanInfoSearchPath = null;

    public static synchronized void registerPropertyEditors() {
        if (clsReg == null) {
            clsReg = new AbstractRegistrator(PEClassRegistration.class){

                @Override
                void register() {
                    ClassLoader classLoader = NodesRegistrationSupport.findClsLoader();
                    for (PEClassRegistration pEClassRegistration : this.lookupResult.allInstances()) {
                        for (String string : pEClassRegistration.targetTypes) {
                            try {
                                Class<?> clazz = NodesRegistrationSupport.getClassFromCanonicalName(string);
                                Class<?> clazz2 = Class.forName(pEClassRegistration.editorClass, true, classLoader);
                                PropertyEditorManager.registerEditor(clazz, clazz2);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                Exceptions.printStackTrace((Throwable)classNotFoundException);
                            }
                        }
                    }
                }

                @Override
                void init() {
                }
            };
        } else {
            clsReg.register();
        }
        if (pkgReg == null) {
            pkgReg = new AbstractRegistrator(PEPackageRegistration.class){

                @Override
                void register() {
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                    for (PEPackageRegistration pEPackageRegistration : this.lookupResult.allInstances()) {
                        linkedHashSet.add(pEPackageRegistration.pkg);
                    }
                    linkedHashSet.addAll(originalPath);
                    PropertyEditorManager.setEditorSearchPath(linkedHashSet.toArray(new String[0]));
                }

                @Override
                void init() {
                    if (originalPath == null) {
                        originalPath = Arrays.asList(PropertyEditorManager.getEditorSearchPath());
                    }
                }
            };
        } else {
            pkgReg.register();
        }
        if (beanInfoReg == null) {
            beanInfoReg = new AbstractRegistrator(BeanInfoRegistration.class){

                @Override
                void register() {
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                    for (BeanInfoRegistration beanInfoRegistration : this.lookupResult.allInstances()) {
                        linkedHashSet.add(beanInfoRegistration.searchPath);
                    }
                    linkedHashSet.addAll(originalBeanInfoSearchPath);
                    Introspector.setBeanInfoSearchPath(linkedHashSet.toArray(new String[0]));
                }

                @Override
                void init() {
                    if (originalBeanInfoSearchPath == null) {
                        originalBeanInfoSearchPath = Arrays.asList(Introspector.getBeanInfoSearchPath());
                    }
                }
            };
        } else {
            beanInfoReg.register();
        }
    }

    public static PEPackageRegistration createPackageRegistration(Map map) {
        String string = (String)map.get(PACKAGE);
        return new PEPackageRegistration(string);
    }

    public static PEClassRegistration createClassRegistration(Map map) {
        String string;
        String string2 = (String)map.get(EDITOR_CLASS);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n = 1;
        while ((string = (String)map.get("targetType." + n)) != null) {
            linkedHashSet.add(string);
            ++n;
        }
        return new PEClassRegistration(string2, linkedHashSet);
    }

    public static BeanInfoRegistration createBeanInfoRegistration(Map map) {
        String string = (String)map.get(PACKAGE);
        return new BeanInfoRegistration(string);
    }

    protected static Class<?> getClassFromCanonicalName(String string) throws ClassNotFoundException {
        Object object;
        Class<Comparable<Byte>> clazz;
        String string2 = string;
        int n = 0;
        while (string2.endsWith("[]")) {
            ++n;
            string2 = string2.substring(0, string2.length() - 2);
        }
        if ("byte".equals(string2)) {
            clazz = Byte.TYPE;
        } else if ("short".equals(string2)) {
            clazz = Short.TYPE;
        } else if ("char".equals(string2)) {
            clazz = Character.TYPE;
        } else if ("int".equals(string2)) {
            clazz = Integer.TYPE;
        } else if ("long".equals(string2)) {
            clazz = Long.TYPE;
        } else if ("float".equals(string2)) {
            clazz = Float.TYPE;
        } else if ("double".equals(string2)) {
            clazz = Double.TYPE;
        } else if ("boolean".equals(string2)) {
            clazz = Boolean.TYPE;
        } else {
            object = NodesRegistrationSupport.findClsLoader();
            clazz = Class.forName(string2, true, (ClassLoader)object);
        }
        if (n > 0) {
            object = new int[n];
            for (int i = 0; i < ((int[])object).length; ++i) {
                object[i] = 0;
            }
            clazz = Array.newInstance(clazz, object).getClass();
        }
        return clazz;
    }

    static ClassLoader findClsLoader() {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = NodesRegistrationSupport.class.getClassLoader();
        }
        return classLoader;
    }

    private static abstract class AbstractRegistrator
    implements LookupListener {
        Lookup.Result lookupResult;
        private final Class cls;

        AbstractRegistrator(Class clazz) {
            this.cls = clazz;
            this.init();
            this.lookupResult = Lookup.getDefault().lookupResult(clazz);
            this.register();
            this.lookupResult.addLookupListener((LookupListener)this);
        }

        abstract void register();

        abstract void init();

        public void resultChanged(LookupEvent lookupEvent) {
            this.lookupResult = Lookup.getDefault().lookupResult(this.cls);
            this.register();
        }
    }

    public static class BeanInfoRegistration {
        final String searchPath;

        BeanInfoRegistration(String string) {
            this.searchPath = string;
        }
    }

    public static class PEClassRegistration {
        final Set<String> targetTypes;
        final String editorClass;

        PEClassRegistration(String string, Set<String> set) {
            this.editorClass = string;
            this.targetTypes = set;
        }
    }

    public static class PEPackageRegistration {
        final String pkg;

        PEPackageRegistration(String string) {
            this.pkg = string;
        }
    }
}

