/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.prompts;

import net.rubygrapefruit.platform.prompts.Prompter;
import net.rubygrapefruit.platform.terminal.TerminalOutput;

class TextView {
    final TerminalOutput output;
    private final String prompt;
    private final String defaultValue;
    private StringBuilder value = new StringBuilder();
    private int insertPos = 0;
    private int cursor = 0;

    TextView(TerminalOutput output, String prompt, String defaultValue) {
        this.output = output;
        this.prompt = prompt;
        this.defaultValue = defaultValue;
    }

    boolean hasValue() {
        return this.value.length() > 0;
    }

    String getValue() {
        return this.value.toString();
    }

    void render() {
        this.output.newline();
        this.output.hideCursor();
        this.output.bold().write(this.prompt).write(": ").normal();
        this.output.dim();
        this.output.write(this.defaultValue);
        this.output.cursorLeft(this.defaultValue.length());
        this.output.reset();
    }

    void update() {
        this.output.hideCursor();
        this.output.cursorLeft(this.cursor);
        if (this.value.length() == 0) {
            this.output.dim();
            this.output.write(this.defaultValue);
            this.output.clearToEndOfLine();
            this.output.cursorLeft(this.defaultValue.length() - this.insertPos);
        } else {
            this.output.foreground(Prompter.SELECTION_COLOR);
            int len = this.renderValue(this.value);
            this.output.clearToEndOfLine();
            this.output.cursorLeft(len - this.insertPos);
        }
        this.output.reset();
        this.cursor = this.insertPos;
    }

    protected int renderValue(CharSequence value) {
        this.output.write(value);
        return value.length();
    }

    protected int renderFinalValue(CharSequence value) {
        return this.renderValue(value);
    }

    void insert(char ch) {
        this.value.insert(this.insertPos, ch);
        ++this.insertPos;
        this.update();
    }

    void eraseBack() {
        if (this.insertPos == 0) {
            return;
        }
        this.value.deleteCharAt(this.insertPos - 1);
        --this.insertPos;
        this.update();
    }

    void eraseForward() {
        if (this.insertPos == this.value.length()) {
            return;
        }
        this.value.deleteCharAt(this.insertPos);
        this.update();
    }

    void cursorStart() {
        this.insertPos = 0;
        this.output.cursorLeft(this.cursor);
        this.cursor = 0;
    }

    void cursorEnd() {
        this.insertPos = this.value.length();
        this.output.cursorRight(this.insertPos - this.cursor);
        this.cursor = this.insertPos;
    }

    void cursorLeft() {
        if (this.insertPos == 0) {
            return;
        }
        --this.insertPos;
        --this.cursor;
        this.output.cursorLeft(1);
    }

    void cursorRight() {
        if (this.insertPos == this.value.length()) {
            return;
        }
        ++this.insertPos;
        ++this.cursor;
        this.output.cursorRight(1);
    }

    void close(String entered) {
        this.output.cursorStartOfLine();
        this.output.write(this.prompt).write(": ");
        if (entered != null) {
            this.output.foreground(Prompter.SELECTION_COLOR);
            this.renderFinalValue(entered);
            this.output.reset();
        } else {
            this.output.write("<none>");
        }
        this.output.clearToEndOfLine();
        this.output.newline();
    }
}

