/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.net.URI;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.data.Aggregates;
import org.rrd4j.data.Aggregator;
import org.rrd4j.data.Source;

class Def
extends Source {
    private final URI rrdUri;
    private final String dsName;
    private final RrdBackendFactory backend;
    private final ConsolFun consolFun;
    private FetchData fetchData;

    Def(String name, FetchData fetchData) {
        this(name, name, fetchData);
    }

    Def(String name, String dsName, FetchData fetchData) {
        this(name, fetchData.getRequest().getParentDb().getCanonicalUri(), dsName, fetchData.getRequest().getConsolFun(), fetchData.getRequest().getParentDb().getRrdBackend().getFactory());
        this.fetchData = fetchData;
    }

    Def(String name, URI rrdUri, String dsName, ConsolFun consolFunc, RrdBackendFactory backend) {
        super(name);
        this.rrdUri = backend.getCanonicalUri(rrdUri);
        this.dsName = dsName;
        this.consolFun = consolFunc;
        this.backend = backend;
    }

    URI getCanonicalUri() {
        return this.rrdUri;
    }

    String getDsName() {
        return this.dsName;
    }

    ConsolFun getConsolFun() {
        return this.consolFun;
    }

    RrdBackendFactory getBackend() {
        return this.backend;
    }

    boolean isCompatibleWith(Def def) {
        return this.getCanonicalUri().equals(def.getCanonicalUri()) && this.getConsolFun() == def.consolFun && (this.backend == null && def.backend == null || this.backend != null && def.backend != null && this.backend.equals(def.backend));
    }

    RrdDb getRrdDb() {
        return this.fetchData.getRequest().getParentDb();
    }

    void setFetchData(FetchData fetchData) {
        this.fetchData = fetchData;
    }

    long[] getRrdTimestamps() {
        return this.fetchData.getTimestamps();
    }

    double[] getRrdValues() {
        return this.fetchData.getValues(this.dsName);
    }

    long getArchiveEndTime() {
        return this.fetchData.getArcEndTime();
    }

    long getFetchStep() {
        return this.fetchData.getStep();
    }

    @Override
    @Deprecated
    Aggregates getAggregates(long tStart, long tEnd) {
        long[] t = this.getRrdTimestamps();
        double[] v = this.getRrdValues();
        return new Aggregator(t, v).getAggregates(tStart, tEnd);
    }

    @Override
    @Deprecated
    double getPercentile(long tStart, long tEnd, double percentile) {
        long[] t = this.getRrdTimestamps();
        double[] v = this.getRrdValues();
        return new Aggregator(t, v).getPercentile(tStart, tEnd, percentile);
    }

    boolean isLoaded() {
        return this.fetchData != null;
    }
}

