/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.LRUCache;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/DuplicateTermination;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "<init>", "()V", "replayContexts", "", "", "", "", "numDuplicatePacketsDropped", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "trace", "", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class DuplicateTermination
extends TransformerNode {
    @NotNull
    private final Map<Long, Set<Integer>> replayContexts = new TreeMap();
    private int numDuplicatePacketsDropped;

    public DuplicateTermination() {
        super("Duplicate termination");
    }

    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
        Set set = this.replayContexts.computeIfAbsent(rtpPacket.getSsrc(), arg_0 -> DuplicateTermination.transform$lambda$1(DuplicateTermination::transform$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(set, "computeIfAbsent(...)");
        Set replayContext = set;
        if (!replayContext.add(rtpPacket.getSequenceNumber())) {
            int n = this.numDuplicatePacketsDropped;
            this.numDuplicatePacketsDropped = n + 1;
            return null;
        }
        return packetInfo;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u242 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u242.addNumber("num_duplicate_packets_dropped", this.numDuplicatePacketsDropped);
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    private static final Set transform$lambda$0(Long it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return LRUCache.lruSet(1500, true);
    }

    private static final Set transform$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Set)$tmp0.invoke(p0);
    }
}

