/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.mqtt.internal;

import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.transport.mqtt.MqttMessageSubscriber;
import org.openhab.core.util.HexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class Subscription {
    private final Logger logger = LoggerFactory.getLogger(Subscription.class);
    private final Map<String, byte[]> retainedMessages = new ConcurrentHashMap<String, byte[]>();
    private final Collection<MqttMessageSubscriber> subscribers = ConcurrentHashMap.newKeySet();

    public void add(MqttMessageSubscriber subscriber) {
        if (this.subscribers.add(subscriber)) {
            this.retainedMessages.entrySet().stream().forEach(entry -> {
                if (((byte[])entry.getValue()).length > 0) {
                    this.processMessage(subscriber, (String)entry.getKey(), (byte[])entry.getValue());
                }
            });
        }
    }

    public void remove(MqttMessageSubscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    public boolean isEmpty() {
        return this.subscribers.isEmpty();
    }

    public void messageArrived(Mqtt3Publish message) {
        this.messageArrived(message.getTopic().toString(), message.getPayloadAsBytes(), message.isRetain());
    }

    public void messageArrived(Mqtt5Publish message) {
        this.messageArrived(message.getTopic().toString(), message.getPayloadAsBytes(), message.isRetain());
    }

    public void messageArrived(String topic, byte[] payload, boolean retain) {
        if (retain || this.retainedMessages.containsKey(topic)) {
            this.retainedMessages.put(topic, payload);
        }
        this.subscribers.forEach(subscriber -> this.processMessage((MqttMessageSubscriber)subscriber, topic, payload));
    }

    private void processMessage(MqttMessageSubscriber subscriber, String topic, byte[] payload) {
        try {
            subscriber.processMessage(topic, payload);
        }
        catch (RuntimeException e) {
            this.logger.warn("A subscriber of type '{}' failed to process message '{}' to topic '{}'.", new Object[]{subscriber.getClass(), HexUtils.bytesToHex((byte[])payload), topic});
        }
    }
}

