/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.item.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataPredicates;
import org.openhab.core.items.MetadataProvider;
import org.osgi.service.component.annotations.Component;

@Component(service={MetadataProvider.class, GenericMetadataProvider.class})
@NonNullByDefault
public class GenericMetadataProvider
extends AbstractProvider<Metadata>
implements MetadataProvider {
    private final Set<Metadata> metadata = new HashSet<Metadata>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public void addMetadata(String bindingType, String itemName, String value, @Nullable Map<String, Object> configuration) {
        MetadataKey key = new MetadataKey(bindingType, itemName);
        Metadata md = new Metadata(key, value, configuration);
        try {
            this.lock.writeLock().lock();
            this.metadata.add(md);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.notifyListenersAboutAddedElement(md);
    }

    public void removeMetadataByNamespace(String namespace) {
        Set<Metadata> toBeRemoved;
        try {
            this.lock.writeLock().lock();
            toBeRemoved = this.metadata.stream().filter(MetadataPredicates.hasNamespace((String)namespace)).collect(Collectors.toSet());
            this.metadata.removeAll(toBeRemoved);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        toBeRemoved.forEach(arg_0 -> ((GenericMetadataProvider)this).notifyListenersAboutRemovedElement(arg_0));
    }

    public void removeMetadataByItemName(String itemName) {
        Set toBeRemoved;
        try {
            this.lock.writeLock().lock();
            toBeRemoved = this.metadata.stream().filter(MetadataPredicates.ofItem((String)itemName)).collect(Collectors.toSet());
            this.metadata.removeAll(toBeRemoved);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (Metadata m : toBeRemoved) {
            this.notifyListenersAboutRemovedElement(m);
        }
    }

    public Collection<Metadata> getAll() {
        try {
            this.lock.readLock().lock();
            Set<Metadata> set = Set.copyOf(this.metadata);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

