/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.net.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Properties;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.net.http.HttpUtil;

@NonNullByDefault
public class HttpRequestBuilder {
    private final String method;
    private final String url;
    private Duration timeout = Duration.ofSeconds(5L);
    private @Nullable Properties headers;
    private @Nullable InputStream inputStream;
    private @Nullable String contentType;

    private HttpRequestBuilder(String method, String url) {
        this.method = method;
        this.url = url;
    }

    public static HttpRequestBuilder getFrom(String url) {
        return new HttpRequestBuilder("GET", url);
    }

    public static HttpRequestBuilder postTo(String url) {
        return new HttpRequestBuilder("POST", url);
    }

    public HttpRequestBuilder withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public HttpRequestBuilder withHeader(String header, String value) {
        Properties localHeaders = this.headers;
        if (localHeaders == null) {
            localHeaders = this.headers = new Properties();
        }
        localHeaders.put(header, value);
        return this;
    }

    public HttpRequestBuilder withContent(String content) {
        this.inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        return this;
    }

    public HttpRequestBuilder withContent(String content, String contentType) {
        this.withContent(content);
        this.contentType = contentType;
        return this;
    }

    public String getContentAsString() throws IOException {
        int timeoutMillis = (int)this.timeout.toMillis();
        return HttpUtil.executeUrl(this.method, this.url, this.headers, this.inputStream, this.contentType, timeoutMillis);
    }
}

