/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.inspectionKts.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.AnimatedIcon;
import icons.QodanaIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.inspectionKts.ui.InspectionKtsBannerViewModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/qodana/inspectionKts/ui/CompilationStatusAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "viewModel", "Lorg/jetbrains/qodana/inspectionKts/ui/InspectionKtsBannerViewModel;", "<init>", "(Lorg/jetbrains/qodana/inspectionKts/ui/InspectionKtsBannerViewModel;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionIcon", "Ljavax/swing/Icon;", "compilationStatus", "Lorg/jetbrains/qodana/inspectionKts/ui/InspectionKtsBannerViewModel$CompilationStatus;", "intellij.qodana"})
public final class CompilationStatusAction
extends AnAction
implements DumbAware {
    @NotNull
    private final InspectionKtsBannerViewModel viewModel;

    public CompilationStatusAction(@NotNull InspectionKtsBannerViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.viewModel = viewModel;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InspectionKtsBannerViewModel.CompilationStatus compilationStatus2 = (InspectionKtsBannerViewModel.CompilationStatus)this.viewModel.getCompilationStatus().getValue();
        if (compilationStatus2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Icon icon = this.getActionIcon(compilationStatus2);
        e.getPresentation().setText("");
        e.getPresentation().setIcon(this.getActionIcon(compilationStatus2));
        e.getPresentation().setDisabledIcon(icon);
        e.getPresentation().setEnabled(false);
        if (compilationStatus2 instanceof InspectionKtsBannerViewModel.CompilationStatus.Failed) {
            e.getPresentation().setEnabled(true);
            e.getPresentation().setText(QodanaBundle.message("inspectionKts.open.log", new Object[0]));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = this.viewModel.getCompilationStatus().getValue();
        InspectionKtsBannerViewModel.CompilationStatus.Failed failed = object instanceof InspectionKtsBannerViewModel.CompilationStatus.Failed ? (InspectionKtsBannerViewModel.CompilationStatus.Failed)object : null;
        if (failed == null) {
            return;
        }
        InspectionKtsBannerViewModel.CompilationStatus.Failed failed2 = failed;
        failed2.getOpenExceptionInLogAction().invoke();
    }

    private final Icon getActionIcon(InspectionKtsBannerViewModel.CompilationStatus compilationStatus2) {
        Icon icon;
        InspectionKtsBannerViewModel.CompilationStatus compilationStatus3 = compilationStatus2;
        if (compilationStatus3 instanceof InspectionKtsBannerViewModel.CompilationStatus.Cancelled) {
            Icon icon2 = AllIcons.Actions.Cancel;
            Intrinsics.checkNotNull((Object)icon2);
            icon = icon2;
        } else if (compilationStatus3 instanceof InspectionKtsBannerViewModel.CompilationStatus.Compiling) {
            AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
            Intrinsics.checkNotNull((Object)animatedIcon);
            icon = (Icon)animatedIcon;
        } else if (compilationStatus3 instanceof InspectionKtsBannerViewModel.CompilationStatus.Failed) {
            if (((InspectionKtsBannerViewModel.CompilationStatus.Failed)compilationStatus2).isOutdated()) {
                Icon icon3 = QodanaIcons.Icons.InspectionKts.ErrorOutdated;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ErrorOutdated");
            } else {
                Icon icon4 = QodanaIcons.Icons.InspectionKts.Error;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Error");
            }
        } else if (compilationStatus3 instanceof InspectionKtsBannerViewModel.CompilationStatus.Compiled) {
            if (((InspectionKtsBannerViewModel.CompilationStatus.Compiled)compilationStatus2).isOutdated()) {
                Icon icon5 = QodanaIcons.Icons.InspectionKts.OkOutdated;
                icon = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"OkOutdated");
            } else {
                Icon icon6 = QodanaIcons.Icons.InspectionKts.OK;
                icon = icon6;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"OK");
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return icon;
    }
}

