/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;

@Singleton
public class NetworkForwarder {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkForwarder.class);
    private final InetAddress destination;
    private final DatagramSocket connectionUdp;
    private final Map<InetSocketAddress, Socket> connectionsTcp = new HashMap<InetSocketAddress, Socket>();

    @Inject
    public NetworkForwarder(Config config) throws IOException {
        this.destination = InetAddress.getByName(config.getString(Keys.SERVER_FORWARD));
        this.connectionUdp = new DatagramSocket();
    }

    public void forward(InetSocketAddress source, int port, boolean datagram, byte[] data) {
        try {
            if (datagram) {
                this.connectionUdp.send(new DatagramPacket(data, data.length, this.destination, port));
            } else {
                Socket connectionTcp = this.connectionsTcp.get(source);
                if (connectionTcp == null || connectionTcp.isClosed()) {
                    connectionTcp = new Socket(this.destination, port);
                    this.connectionsTcp.put(source, connectionTcp);
                }
                connectionTcp.getOutputStream().write(data);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Network forwarding error", (Throwable)e);
        }
    }

    public void disconnect(InetSocketAddress source) {
        Socket connectionTcp = this.connectionsTcp.remove(source);
        if (connectionTcp != null) {
            try {
                connectionTcp.close();
            }
            catch (IOException e) {
                LOGGER.warn("Connection close error", (Throwable)e);
            }
        }
    }
}

