/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.trans.XPathException;

public class StandardOutputResolver
implements OutputURIResolver {
    private static StandardOutputResolver theInstance = new StandardOutputResolver();

    public static StandardOutputResolver getInstance() {
        return theInstance;
    }

    public Result resolve(String href, String base) throws XPathException {
        try {
            URI absoluteURI;
            if (href.length() == 0) {
                if (base == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown");
                }
                absoluteURI = new URI(base);
            } else {
                absoluteURI = new URI(href);
            }
            if (!absoluteURI.isAbsolute()) {
                if (base == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown");
                }
                URI baseURI = new URI(base);
                absoluteURI = baseURI.resolve(href);
            }
            if ("file".equals(absoluteURI.getScheme())) {
                return StandardOutputResolver.makeOutputFile(absoluteURI);
            }
            URLConnection connection = absoluteURI.toURL().openConnection();
            connection.setDoInput(false);
            connection.setDoOutput(true);
            connection.connect();
            OutputStream stream = connection.getOutputStream();
            StreamResult result = new StreamResult(stream);
            result.setSystemId(absoluteURI.toASCIIString());
            return result;
        }
        catch (URISyntaxException err) {
            throw new XPathException("Invalid syntax for base URI", err);
        }
        catch (IllegalArgumentException err2) {
            throw new XPathException("Invalid URI syntax", err2);
        }
        catch (MalformedURLException err3) {
            throw new XPathException("Resolved URL is malformed", err3);
        }
        catch (UnknownServiceException err5) {
            throw new XPathException("Specified protocol does not allow output", err5);
        }
        catch (IOException err4) {
            throw new XPathException("Cannot open connection to specified URL", err4);
        }
    }

    public static synchronized Result makeOutputFile(URI absoluteURI) throws XPathException {
        File newFile = new File(absoluteURI);
        try {
            if (!newFile.exists()) {
                File directory = newFile.getParentFile();
                if (directory != null && !directory.exists()) {
                    directory.mkdirs();
                }
                newFile.createNewFile();
            }
            return new StreamResult(newFile);
        }
        catch (IOException err) {
            throw new XPathException("Failed to create output file " + absoluteURI, err);
        }
    }

    public void close(Result result) throws XPathException {
        OutputStream stream;
        if (result instanceof StreamResult && (stream = ((StreamResult)result).getOutputStream()) != null) {
            try {
                stream.close();
            }
            catch (IOException err) {
                throw new XPathException("Failed while closing output file", err);
            }
        }
    }
}

