/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.ScanController;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.SortedComboBoxModel;
import org.zaproxy.zap.view.ScanStatus;
import org.zaproxy.zap.view.ZapToggleButton;

public abstract class ScanPanel2<GS extends GenericScanner2, SC extends ScanController<GS>>
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private final String prefix;
    private final SC controller;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JLabel scannedCountNameLabel = null;
    private JLabel foundCountNameLabel = null;
    private JComboBox<ScanEntry<GS>> progressSelect = null;
    private SortedComboBoxModel<ScanEntry<GS>> progressModel = new SortedComboBoxModel();
    private final ScanEntry<GS> selectScanEntry;
    private JButton stopScanButton = null;
    private ZapToggleButton pauseScanButton = null;
    private JButton newScanButton = null;
    private JButton clearScansButton = null;
    private JButton optionsButton = null;
    private JProgressBar progressBar = null;
    private ScanStatus scanStatus = null;
    private Control.Mode mode = Control.getSingleton().getMode();
    private static Logger log = LogManager.getLogger(ScanPanel2.class);

    @Deprecated
    public ScanPanel2(String prefix, ImageIcon icon, SC controller, AbstractParam scanParam) {
        this(prefix, icon, controller);
    }

    public ScanPanel2(String prefix, ImageIcon icon, SC controller) {
        this.prefix = prefix;
        this.controller = controller;
        this.selectScanEntry = new ScanEntry(Constant.messages.getString(prefix + ".toolbar.progress.select"));
        this.initialize(icon);
        log.debug("Constructor " + prefix);
    }

    private void initialize(ImageIcon icon) {
        this.setLayout(new CardLayout());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(474, 251);
        }
        this.setName(Constant.messages.getString(this.prefix + ".panel.title"));
        this.setIcon(icon);
        this.add((Component)this.getPanelCommand(), this.prefix + ".panel");
        this.scanStatus = new ScanStatus(icon, Constant.messages.getString(this.prefix + ".panel.title"));
        if (View.isInitialised()) {
            View.getSingleton().getMainFrame().getMainFooterPanel().addFooterToolbarRightLabel(this.scanStatus.getCountLabel());
        }
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName(this.prefix + ".panel");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getPanelToolbar(), gridBagConstraints1);
            this.panelCommand.add(this.getWorkPanel(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    protected GridBagConstraints getGBC(int gridx, int gridy) {
        return this.getGBC(gridx, gridy, 0.0, new Insets(0, 2, 0, 0));
    }

    protected GridBagConstraints getGBC(int gridx, int gridy, double weightx, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.weightx = weightx;
        if (weightx > 0.0) {
            gbc.fill = 2;
        }
        gbc.insets = insets;
        gbc.anchor = 17;
        return gbc;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName(this.prefix + ".toolbar");
            int x = 0;
            x = this.addToolBarElements(this.panelToolbar, Location.start, x);
            this.newScanButton = this.getNewScanButton();
            if (this.newScanButton != null) {
                this.panelToolbar.add((Component)this.newScanButton, this.getGBC(x++, 0));
                this.newScanButton.setEnabled(!Control.Mode.safe.equals((Object)this.mode));
                this.panelToolbar.addSeparator();
            }
            int n = ++x;
            this.panelToolbar.add((Component)new JLabel(Constant.messages.getString(this.prefix + ".toolbar.progress.label")), this.getGBC(n, 0));
            int n2 = ++x;
            ++x;
            this.panelToolbar.add(this.getProgressSelect(), this.getGBC(n2, 0));
            x = this.addToolBarElements(this.panelToolbar, Location.beforeButtons, x);
            this.panelToolbar.add((Component)this.getPauseScanButton(), this.getGBC(x++, 0));
            this.panelToolbar.add((Component)this.getStopScanButton(), this.getGBC(x++, 0));
            x = this.addToolBarElements(this.panelToolbar, Location.beforeProgressBar, x);
            this.panelToolbar.add((Component)this.getProgressBar(), this.getGBC(x++, 0, 1.0, new Insets(0, 5, 0, 5)));
            this.panelToolbar.add((Component)this.getClearScansButton(), this.getGBC(x++, 0));
            this.panelToolbar.add((Component)this.getActiveScansNameLabel(), this.getGBC(x++, 0));
            this.panelToolbar.add((Component)this.getActiveScansValueLabel(), this.getGBC(x++, 0));
            x = this.addToolBarElements(this.panelToolbar, Location.afterProgressBar, x);
            this.panelToolbar.add((Component)new JLabel(), this.getGBC(x++, 0, 1.0, new Insets(0, 0, 0, 0)));
            if (this.hasOptionsButton()) {
                this.panelToolbar.add((Component)this.getOptionsButton(), this.getGBC(x++, 0));
            }
        }
        return this.panelToolbar;
    }

    protected boolean hasOptionsButton() {
        return true;
    }

    protected int addToolBarElements(JToolBar toolBar, Location location, int gridX) {
        return gridX;
    }

    private JLabel getActiveScansNameLabel() {
        if (this.scannedCountNameLabel == null) {
            this.scannedCountNameLabel = new JLabel();
            this.scannedCountNameLabel.setText(Constant.messages.getString(this.prefix + ".toolbar.ascans.label"));
        }
        return this.scannedCountNameLabel;
    }

    private JLabel getActiveScansValueLabel() {
        if (this.foundCountNameLabel == null) {
            this.foundCountNameLabel = new JLabel();
            this.foundCountNameLabel.setText(String.valueOf(this.controller.getActiveScans().size()));
        }
        return this.foundCountNameLabel;
    }

    private void setActiveScanLabelsEventHandler() {
        List ascans = this.controller.getActiveScans();
        this.getActiveScansValueLabel().setText(String.valueOf(ascans.size()));
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (GenericScanner2 ascan : ascans) {
            sb.append(ascan.getDisplayName());
            sb.append("<br>");
        }
        sb.append("</html>");
        String toolTip = sb.toString();
        this.getActiveScansNameLabel().setToolTipText(toolTip);
        this.getActiveScansValueLabel().setToolTipText(toolTip);
        this.scanStatus.setScanCount(ascans.size());
        this.getClearScansButton().setEnabled(this.controller.getAllScans().size() - ascans.size() > 0);
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setSize(new Dimension(80, 20));
            this.progressBar.setStringPainted(true);
            this.progressBar.setEnabled(false);
        }
        return this.progressBar;
    }

    protected JButton getStopScanButton() {
        if (this.stopScanButton == null) {
            this.stopScanButton = new JButton();
            this.stopScanButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.stop"));
            this.stopScanButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/142.png"))));
            this.stopScanButton.setEnabled(false);
            this.stopScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object scanner = ScanPanel2.this.getSelectedScanner();
                    if (scanner != null) {
                        ScanPanel2.this.controller.stopScan(scanner.getScanId());
                    }
                }
            });
        }
        return this.stopScanButton;
    }

    protected JToggleButton getPauseScanButton() {
        if (this.pauseScanButton == null) {
            this.pauseScanButton = new ZapToggleButton();
            this.pauseScanButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.pause"));
            this.pauseScanButton.setSelectedToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.unpause"));
            this.pauseScanButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/141.png"))));
            this.pauseScanButton.setRolloverIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/141.png"))));
            this.pauseScanButton.setSelectedIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/131.png"))));
            this.pauseScanButton.setRolloverSelectedIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/131.png"))));
            this.pauseScanButton.setEnabled(false);
            this.pauseScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object scanner = ScanPanel2.this.getSelectedScanner();
                    if (scanner != null) {
                        if (ScanPanel2.this.pauseScanButton.isSelected()) {
                            ScanPanel2.this.controller.pauseScan(scanner.getScanId());
                        } else {
                            ScanPanel2.this.controller.resumeScan(scanner.getScanId());
                        }
                    }
                }
            });
        }
        return this.pauseScanButton;
    }

    private JButton getOptionsButton() {
        if (this.optionsButton == null) {
            this.optionsButton = new JButton();
            this.optionsButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.options"));
            this.optionsButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/041.png"))));
            this.optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Control.getSingleton().getMenuToolsControl().options(Constant.messages.getString(ScanPanel2.this.prefix + ".options.title"));
                }
            });
        }
        return this.optionsButton;
    }

    private JButton getClearScansButton() {
        if (this.clearScansButton == null) {
            this.clearScansButton = new JButton();
            this.clearScansButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.clear"));
            this.clearScansButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/fugue/broom.png"))));
            this.clearScansButton.setEnabled(false);
            this.clearScansButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScanPanel2.this.clearFinishedScans();
                }
            });
        }
        return this.clearScansButton;
    }

    public void clearFinishedScans() {
        int count = this.controller.removeFinishedScans();
        if (count > 0) {
            this.progressModel.removeAllElements();
            this.progressModel.addElement(this.selectScanEntry);
            for (GenericScanner2 scan : this.controller.getAllScans()) {
                this.progressModel.addElement(new ScanEntry<GenericScanner2>(scan));
            }
            this.updateScannerUI();
        }
        this.clearScansButton.setEnabled(false);
    }

    public GS getSelectedScanner() {
        Object selectedItem = this.progressModel.getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        Object scan = ((ScanEntry)selectedItem).getScan();
        return scan;
    }

    protected JComboBox<ScanEntry<GS>> getProgressSelect() {
        if (this.progressSelect == null) {
            this.progressSelect = new JComboBox<ScanEntry<GS>>(this.progressModel);
            this.progressSelect.addItem(this.selectScanEntry);
            this.progressSelect.setSelectedIndex(0);
            this.progressSelect.setEnabled(false);
            this.progressSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScanPanel2.this.scannerSelected(ScanPanel2.this.getSelectedScanner());
                }
            });
        }
        return this.progressSelect;
    }

    public void updateScannerUI() {
        this.scannerSelected(this.getSelectedScanner());
    }

    private void scannerSelected(GS scanner) {
        this.updateProgressAndButtonsState(scanner);
        this.switchView(scanner);
    }

    private void updateProgressAndButtonsState(GS scanner) {
        if (scanner == null || Control.Mode.safe.equals((Object)Control.getSingleton().getMode())) {
            this.getStopScanButton().setEnabled(false);
            this.getPauseScanButton().setEnabled(false);
            this.getPauseScanButton().setSelected(false);
            this.getProgressBar().setEnabled(false);
        } else if (scanner.isStopped()) {
            this.getStopScanButton().setEnabled(false);
            this.getPauseScanButton().setEnabled(false);
            this.getPauseScanButton().setSelected(false);
            this.getProgressBar().setEnabled(false);
        } else {
            this.getStopScanButton().setEnabled(true);
            this.getPauseScanButton().setEnabled(true);
            this.getPauseScanButton().setSelected(scanner.isPaused());
            this.getProgressBar().setEnabled(true);
        }
        if (scanner != null) {
            this.getProgressBar().setValue(scanner.getProgress());
            this.getProgressBar().setMaximum(scanner.getMaximum());
        } else {
            this.getProgressBar().setValue(0);
        }
    }

    public void scanFinshed(final int id, final String host) {
        if (EventQueue.isDispatchThread()) {
            this.scanFinshedEventHandler(id, host);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanPanel2.this.scanFinshedEventHandler(id, host);
                    }
                });
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void scanFinshedEventHandler(int id, String host) {
        log.debug("scanFinished " + this.prefix + " on " + host);
        if (this.getSelectedScanner() != null && this.getSelectedScanner().getScanId() == id) {
            this.updateProgressAndButtonsState(this.getSelectedScanner());
        }
        this.setActiveScanLabelsEventHandler();
    }

    public void scanProgress(final int id, final String host, final int progress, final int maximum) {
        if (EventQueue.isDispatchThread()) {
            this.scanProgressEventHandler(id, host, progress, maximum);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScanPanel2.this.scanProgressEventHandler(id, host, progress, maximum);
                }
            });
        }
    }

    private void scanProgressEventHandler(int id, String host, int progress, int maximum) {
        if (this.getSelectedScanner() != null && id == this.getSelectedScanner().getScanId()) {
            this.updateProgressAndButtonsState(this.getSelectedScanner());
        }
        this.setActiveScanLabelsEventHandler();
    }

    public void scannerStarted(GS scanner) {
        ScanEntry<GS> scanEntry = new ScanEntry<GS>(scanner);
        this.progressModel.addElement(scanEntry);
        this.getProgressSelect().setEnabled(true);
        this.getProgressSelect().setSelectedItem(scanEntry);
        this.trimProgressList();
        this.scannerSelected(scanner);
    }

    public void trimProgressList() {
        if (this.progressModel.getSize() > this.getNumberOfScansToShow() + 1) {
            for (int i = 1; i < this.progressModel.getSize(); ++i) {
                Object scan = ((ScanEntry)this.progressModel.getElementAt(i)).getScan();
                if (scan == null || !scan.isStopped()) continue;
                this.controller.removeScan(scan.getScanId());
                this.progressModel.removeElementAt(i);
                if (this.progressModel.getSize() <= this.getNumberOfScansToShow() + 1) break;
                --i;
            }
        }
    }

    public void reset() {
        log.debug("reset " + this.prefix);
        this.progressModel.removeAllElements();
        this.progressSelect.addItem(this.selectScanEntry);
        this.progressSelect.setSelectedIndex(0);
        this.clearScansButton.setEnabled(false);
    }

    public void sessionScopeChanged(Session session) {
    }

    public void sessionModeChanged(Control.Mode mode) {
        if (this.newScanButton != null) {
            this.newScanButton.setEnabled(!Control.Mode.safe.equals((Object)mode));
        }
        this.updateScannerUI();
    }

    protected void unload() {
        if (View.isInitialised()) {
            View.getSingleton().getMainFrame().getMainFooterPanel().removeFooterToolbarRightLabel(this.scanStatus.getCountLabel());
        }
    }

    protected SC getController() {
        return this.controller;
    }

    protected abstract Component getWorkPanel();

    protected abstract void switchView(GS var1);

    protected abstract JButton getNewScanButton();

    protected abstract int getNumberOfScansToShow();

    private static class ScanEntry<GS extends GenericScanner2>
    implements Comparable<ScanEntry<GS>> {
        private final GS scan;
        private final String label;

        public ScanEntry(String label) {
            this.scan = null;
            this.label = label;
        }

        public ScanEntry(GS scan) {
            this.scan = scan;
            this.label = scan.getScanId() + ": " + scan.getDisplayName();
        }

        public GS getScan() {
            return this.scan;
        }

        public int hashCode() {
            return 31 + (this.scan == null ? 0 : this.scan.getScanId());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScanEntry other = (ScanEntry)obj;
            if (this.scan == null) {
                return other.scan == null;
            }
            if (other.scan == null) {
                return false;
            }
            return this.scan.getScanId() == other.scan.getScanId();
        }

        @Override
        public int compareTo(ScanEntry<GS> other) {
            if (other == null || other.scan == null) {
                return 1;
            }
            if (this.scan == null) {
                return -1;
            }
            return this.scan.getScanId() - other.scan.getScanId();
        }

        public String toString() {
            return this.label;
        }
    }

    protected static enum Location {
        start,
        beforeSites,
        beforeButtons,
        beforeProgressBar,
        afterProgressBar;

    }
}

