/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.service.S3Connection;
import com.amazon.aes.service.impl.S3ServiceImpl;
import com.amazon.aes.util.LangUtils;
import com.amazon.aes.util.S3Utils;
import com.amazon.aes.util.XmlUtils;
import com.amazon.aes.webservices.client.BundleInstanceTask;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.MissingAtLeastOneArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Formatter;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.amazon.ssl.StrictSSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import sun.misc.BASE64Encoder;

public class BundleInstance
extends BaseCmd {
    private static final String[] POLICY_DESC = new String[]{"Plaintext or base-64 encoded upload policy for S3, allowing EC2 to place items", "into S3 on the user's behalf. If this is not given, --owner-sak is required", "and an upload policy is generated and signed automatically. For more information ", "on upload policies see the Amazon S3 Developer Guide."};
    private static final String[] NO_BUCKET_SETUP_DESC = new String[]{"If the S3 bucket doesn't exist, don't create it. If the permissions aren't correct, don't attempt to fix them."};
    private static final String[] POLICY_SIGNATURE_DESC = new String[]{"Base-64 encoded signature for the S3 upload policy. If --policy is given", "but this is omitted, --owner-sak is required and the policy is signed", "using that value."};
    private static final String PREFIX_DESC = "Prefix for the image component names being store in S3.";
    private static final String BUCKET_DESC = "S3 bucket in which to place the image components. Bucket name should be in lower case.";
    private static final String LOCATION_DESC = "The location of the destination Amazon S3 bucket";
    private static final String LOCATION = "location";
    private static final String EXPIRES_ARG = "HOURS";
    private static final String POLICY_SIGNATURE_ARG = "POLICY-SIG";
    private static final String POLICY_ARG = "POLICY";
    private static final String OWNER_SAK_ARG = "OWNER-SECRET-KEY";
    private static final String OWNER_AKID_ARG = "OWNER-ACCESS-KEY";
    private static final String PREFIX_ARG = "PREFIX";
    private static final String BUCKET_ARG = "BUCKET";
    protected static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    protected static final Pattern BASE64_RE = Pattern.compile("[a-zA-Z0-9/+=\\s]*");
    protected static final String DEFAULT_VALIDITY = "24";
    private static final String[] EXPIRES_DESC = new String[]{"Validity period for a generate upload policy, in hours. Defaults to 24."};
    protected static final String BUNDLE_USER_SHORT = "ec2-bundled-images";
    protected static final String BUNDLE_USER_LONG = "ec2-bundled-images@amazon.com";
    protected static final String EC2_CANNED_ACL = "ec2-bundle-read";
    private static final Pattern EC2_URL_PATTERN = Pattern.compile("https?://(([^.]*)\\.?)ec2\\.amazonaws.com");
    protected static final S3ServiceImpl s3Service = new S3ServiceImpl();
    protected static final String GRANT = "<AccessControlList><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"AmazonCustomerByEmail\"><EmailAddress>ec2-bundled-images@amazon.com</EmailAddress></Grantee><Permission>READ</Permission></Grant></AccessControlList>";
    private String location;

    public BundleInstance(String[] args) {
        super("ec2bundle", "ec2-bundle-instance");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
        this.location = this.getOptionValue(LOCATION);
        if (this.location != null && !this.location.equals("EU") && !this.location.equals("US")) {
            throw new InvalidArgument(LOCATION, this.location);
        }
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"bucket");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)BUCKET_DESC);
        OptionBuilder.withArgName((String)BUCKET_ARG);
        result.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.withLongOpt((String)"prefix");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)PREFIX_DESC);
        OptionBuilder.withArgName((String)PREFIX_ARG);
        result.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"owner-akid");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"AWS Access Key Id of the owner of BUCKET.");
        OptionBuilder.withArgName((String)OWNER_AKID_ARG);
        result.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"owner-sak");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)OWNER_SAK_DESC);
        OptionBuilder.withArgName((String)OWNER_SAK_ARG);
        result.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withLongOpt((String)"policy");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)BundleInstance.joinDescription(POLICY_DESC));
        OptionBuilder.withArgName((String)POLICY_ARG);
        result.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"policy-signature");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)BundleInstance.joinDescription(POLICY_SIGNATURE_DESC));
        OptionBuilder.withArgName((String)POLICY_SIGNATURE_ARG);
        result.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"expires");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)BundleInstance.joinDescription(EXPIRES_DESC));
        OptionBuilder.withArgName((String)EXPIRES_ARG);
        result.addOption(OptionBuilder.create((String)"x"));
        OptionBuilder.withLongOpt((String)"no-bucket-setup");
        OptionBuilder.withDescription((String)BundleInstance.joinDescription(NO_BUCKET_SETUP_DESC));
        result.addOption(OptionBuilder.create((String)"B"));
        result.addOption(null, LOCATION, true, LOCATION_DESC);
        return result;
    }

    @Override
    protected String getOptionString() {
        return "-b BUCKET -p PREFIX -o OWNER-AKID (-c POLICY | -w OWNER-ACCESS-KEY) [OPTIONS] INSTANCE";
    }

    @Override
    public void printOptions() {
        super.printOptions();
        this.printOption("bucket");
        this.printOption("prefix");
        this.printOption("owner-akid");
        this.printOption("owner-sak");
        this.printOption("policy");
        this.printOption("policy-signature");
        this.printOption("expires");
        this.printOption("no-bucket-setup");
        this.printOption(LOCATION);
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Bundle a running instance into an AMI upon next reboot and");
        System.out.println("     store the image components in S3. Items are stored in S3 on");
        System.out.println("     the user's behalf using a signed S3 upload policy.");
        System.out.println();
        System.out.println("     An upload policy and corresponding signature can be specified");
        System.out.println("     as parameters or generated automatically if the Secret Access");
        System.out.println("     Key for the owner of the S3 bucket is available. The generated");
        System.out.println("     policy is valid for 24 hours by default. Alternatively, if a");
        System.out.println("     policy and Secret Access Key are given, the provided policy is");
        System.out.println("     signed and used.");
        System.out.println();
        System.out.println("     If a policy is generated, use --verbose to display the policy.");
        System.out.println();
        System.out.println("     The S3 bucket is created if it does not exist and the user");
        System.out.println("     ec2-bundled-images@amazon.com is granted read permissions on the");
        System.out.println("     entire bucket. To skip these checks, use --no-bucket-setup.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String encodedPolicySignature;
        String encodedPolicy;
        AWSCredentials s3Creds;
        this.assertNonOptionSet("INSTANCE");
        String instanceId = this.getNonOptions()[0];
        this.assertOptionSet("bucket");
        this.assertOptionSet("prefix");
        this.warnIfTooManyNonOptions();
        String bucket = this.getOptionValue("bucket");
        if (!bucket.toLowerCase().equals(bucket)) {
            throw new InvalidArgumentCombination("Bucket name should be lower case");
        }
        String prefix = this.getOptionValue("prefix");
        if (this.isOptionSet("owner-akid")) {
            s3Creds = new BasicSessionCredentials(this.getOptionValue("owner-akid"), this.getOptionValue("owner-sak"), null);
        } else if (this.isOptionSet("aws-access-key")) {
            s3Creds = new BasicSessionCredentials(this.getOptionValue("aws-access-key"), this.getOptionValue("aws-secret-key"), this.getOptionValue("security-token"));
        } else {
            try {
                s3Creds = new InstanceProfileCredentialsProvider().getCredentials();
            }
            catch (Exception e) {
                s3Creds = null;
                this.assertOptionSet("owner-akid");
            }
        }
        if (this.isOptionSet("policy")) {
            encodedPolicy = this.ensureBase64(this.getOptionValue("policy"));
            if (this.isOptionSet("policy-signature")) {
                encodedPolicySignature = this.getOptionValue("policy-signature");
            } else {
                if (!this.isOptionSet("owner-sak")) throw new InvalidArgumentCombination("Given --policy but missing --policy-signature or --owner-sak");
                encodedPolicySignature = this.signUploadPolicy(encodedPolicy, this.getOptionValue("owner-sak"));
            }
        } else {
            if (this.isOptionSet("policy-signature")) {
                throw new InvalidArgumentCombination("Given --policy-signature but missing --policy");
            }
            if (!this.isOptionSet("owner-sak")) {
                throw new MissingAtLeastOneArgument(new String[]{"policy", "owner-sak"});
            }
            int hours = this.getPolicyValidity();
            encodedPolicy = this.base64Encode(this.generateUploadPolicy(bucket, prefix, hours));
            encodedPolicySignature = this.signUploadPolicy(encodedPolicy, this.getOptionValue("owner-sak"));
        }
        if (!this.isOptionSet("no-bucket-setup")) {
            this.setupS3Client();
            this.validateBucket(bucket, s3Creds);
        }
        RequestResultPair task = jec2.bundleInstance(instanceId, s3Creds.getAWSAccessKeyId(), bucket, prefix, encodedPolicy, encodedPolicySignature);
        out.output(System.out, (BundleInstanceTask)task.getResponse());
        out.printRequestId(System.out, (RequestResult)task);
        return true;
    }

    protected void setupS3Client() {
        final String proxyHost = System.getProperty("https.proxyHost", null);
        final int proxyPort = Integer.getInteger("https.proxyPort", 8080);
        if (proxyHost != null) {
            if (this.isOptionSet("verbose")) {
                System.err.println("Using S3 proxy [" + proxyHost + ":" + proxyPort + "]");
            }
            final String proxyUser = System.getProperty("http.proxyUser", null);
            final String proxyPass = System.getProperty("http.proxyPass", null);
            if (proxyUser != null && this.isOptionSet("verbose")) {
                System.err.println("Using S3 proxy credentials [" + proxyUser + "@" + proxyPass + "] for all realms");
            }
            S3Utils.setGetClient(new Callable<HttpClient>(){

                @Override
                public HttpClient call() throws Exception {
                    boolean verifyHostName = !"false".equals(System.getProperty("soap.checkHostName"));
                    StrictSSLProtocolSocketFactory socketFactory = new StrictSSLProtocolSocketFactory(verifyHostName);
                    Protocol protocol = new Protocol("https", (ProtocolSocketFactory)socketFactory, 443);
                    Protocol.registerProtocol((String)"https", (Protocol)protocol);
                    HttpClient client = new HttpClient();
                    client.getHostConfiguration().setProxy(proxyHost, proxyPort);
                    if (proxyUser != null) {
                        client.getParams().setAuthenticationPreemptive(true);
                        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(proxyUser, proxyPass);
                        client.getState().setProxyCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM), (Credentials)creds);
                    }
                    return client;
                }
            });
        }
    }

    protected void validateBucket(String bucket, AWSCredentials s3Creds) throws IOException {
        if (null != s3Creds) {
            this.ensureBucketReadPerms(bucket, s3Creds);
        } else {
            this.checkBucketExists(bucket);
        }
    }

    protected void checkBucketExists(String bucket) throws IOException {
        S3ServiceImpl.S3ConnectionHelper helper;
        HeadMethod head;
        int code;
        if (this.isOptionSet("verbose")) {
            System.err.println("Checking S3 bucket " + bucket + " exists.");
        }
        if ((code = (head = S3Utils.head((helper = s3Service.getConnectionHelper(bucket)).getBaseUrl(bucket), helper.getBucketName(bucket), null, null)).getStatusCode()) == 404) {
            throw new GeneralError("Bucket " + bucket + " does not exist. Provide --" + "owner-sak" + " to create it, or --" + "no-bucket-setup" + " to ignore this error.");
        }
        if (code / 100 != 2 && code != 403) {
            throw new GeneralError("S3 returned " + code + " (" + head.getStatusText() + ") for bucket " + bucket + ". Provide --" + "no-bucket-setup" + " to ignore this error.");
        }
        if (this.isOptionSet("verbose")) {
            System.err.println("S3 returned " + code + " for bucket " + bucket + ". Okay.");
        }
    }

    protected void ensureBucketReadPerms(String bucket, AWSCredentials s3Creds) throws IOException {
        String acl;
        S3ServiceImpl.S3ConnectionHelper helper;
        GetMethod get;
        int code;
        if (this.isOptionSet("verbose")) {
            System.err.println("Checking permissions of S3 bucket " + bucket);
        }
        if ((code = (get = S3Utils.get((helper = s3Service.getConnectionHelper(bucket)).getBaseUrl(bucket) + "?acl", helper.getBucketName(bucket), "acl", s3Creds)).getStatusCode()) == 200) {
            acl = get.getResponseBodyAsString();
        } else {
            S3Connection bucketConnection;
            S3Connection.OperationResult result;
            if (code == 403) {
                throw new GeneralError("S3 returned " + code + " for ACL on bucket " + bucket + ". Are your access key and secret access key correct?");
            }
            if (code != 404) {
                throw new GeneralError("S3 returned " + code + " (" + get.getStatusText() + ") for ACL on bucket " + bucket + ". Use --" + "no-bucket-setup" + " to ignore this error.");
            }
            if (this.isOptionSet("verbose")) {
                System.err.println("Creating bucket " + bucket);
            }
            if (LangUtils.isEmpty(this.location)) {
                this.location = this.guessLocation();
                if (this.isOptionSet("verbose")) {
                    System.out.println("Location not specified. Guessing by EC2 region: " + this.location);
                }
            }
            if (this.isOptionSet("verbose")) {
                System.out.println("Bucket " + bucket + " does not exist. Creating it with location " + (this.location == null ? "none" : this.location) + ".");
            }
            if (S3Connection.OperationCode.OK != (result = (bucketConnection = s3Service.makeS3Connection(s3Creds, bucket)).createBucket(this.location)).getOperationCode()) {
                throw new GeneralError("Creating S3 bucket " + bucket + " failed (" + result + ")." + " Use --" + "no-bucket-setup" + " to ignore this error.");
            }
            if (this.isOptionSet("verbose")) {
                System.err.println("Checking permissions of newly created S3 bucket " + bucket);
            }
            if ((get = S3Utils.get(helper.getBaseUrl(bucket) + "?acl", helper.getBucketName(bucket), "acl", s3Creds)).getStatusCode() != 200) {
                throw new GeneralError("S3 returned " + code + " (" + get.getStatusText() + ") when trying to get ACL on newly-created bucket " + bucket + ".");
            }
            acl = get.getResponseBodyAsString();
        }
        Document doc = this.parseDocument(acl);
        if (this.hasReadPerms(doc)) {
            return;
        }
        if (this.isOptionSet("verbose")) {
            System.err.println("Giving ec2-bundled-images@amazon.com read permissions on S3 bucket " + bucket);
        }
        this.addReadPerms(doc);
        acl = XmlUtils.toXmlString(doc, true);
        PutMethod put = S3Utils.put(helper.getBaseUrl(bucket) + "?acl", helper.getBucketName(bucket), "acl", acl, s3Creds);
        code = put.getStatusCode();
        if (code != 200) {
            if (this.isOptionSet("verbose")) {
                System.err.println("S3 response: \n" + put.getResponseBodyAsString());
            }
            throw new GeneralError("S3 returned " + code + " (" + put.getStatusText() + ") when setting ACL on bucket " + bucket + ".");
        }
    }

    protected void addReadPerms(Document doc) {
        Node parent;
        Document grant = this.parseDocument(GRANT);
        Node child = grant.getFirstChild();
        if (doc.getElementsByTagName("AccessControlList").getLength() == 0) {
            parent = doc.getElementsByTagName("AccessControlPolicy").item(0);
        } else {
            parent = doc.getElementsByTagName("AccessControlList").item(0);
            child = child.getFirstChild();
        }
        parent.appendChild(doc.importNode(child, true));
    }

    protected boolean hasReadPerms(Document doc) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xpath.evaluate("/AccessControlPolicy/AccessControlList/Grant/Grantee/DisplayName[text()='ec2-bundled-images']", doc, XPathConstants.NODE);
            return node != null;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Error searching bucket ACL", e);
        }
    }

    protected Document parseDocument(String xml) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(xml.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing XML", e);
        }
    }

    protected int getPolicyValidity() {
        try {
            int hours = Integer.parseInt(this.getOptionValue("expires", DEFAULT_VALIDITY));
            if (hours < 1) {
                throw new NumberFormatException();
            }
            return hours;
        }
        catch (NumberFormatException e) {
            throw new InvalidArgument("expires", this.getOptionValue("expires"));
        }
    }

    protected String ensureBase64(String str) throws UnsupportedEncodingException {
        if (!BASE64_RE.matcher(str).matches()) {
            return this.base64Encode(str);
        }
        return str;
    }

    protected String guessLocation() {
        String region = this.getOptionValue("region");
        if (LangUtils.isEmpty(region)) {
            region = this.getRegionFromUrl(this.getOptionValue("url"));
        }
        if (region == null || region.length() < 2) {
            throw new RuntimeException("Cannot guess location with this region: " + region);
        }
        return region.substring(0, 2).toUpperCase();
    }

    protected String getRegionFromUrl(String url) {
        Matcher matcher = EC2_URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        return LangUtils.defaultStrIfEmpty(matcher.group(2), "us-east-1");
    }

    protected String signUploadPolicy(String encodedPolicy, String key) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(signingKey);
        return this.base64Encode(mac.doFinal(encodedPolicy.getBytes()));
    }

    protected String generateUploadPolicy(String bucket, String prefix, int validity) {
        Calendar expires = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        expires.add(10, validity);
        Formatter fmt = new Formatter(Locale.US);
        String policy = "{\"expiration\": \"" + fmt.format("%1$tFT%1$tH:%1$tM:%1$tSZ", expires) + "\"," + "\"conditions\": [" + "{\"bucket\": \"" + bucket + "\"}," + "{\"acl\": \"" + EC2_CANNED_ACL + "\"}," + "[\"starts-with\", \"$key\", \"" + prefix + "\"]" + "]}";
        if (this.isOptionSet("verbose")) {
            System.err.println("Generated upload policy: " + policy);
        }
        return policy;
    }

    protected String base64Encode(String s) throws UnsupportedEncodingException {
        return this.base64Encode(s.getBytes("UTF-8"));
    }

    protected String base64Encode(byte[] data) {
        String base64 = new BASE64Encoder().encodeBuffer(data);
        return base64.replaceAll("\\s", "");
    }

    public static void main(String[] args) {
        new BundleInstance(args).invoke();
    }
}

