/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.menu;

import com.projectlibre1.menu.MenuManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;

public class MenuActionsMap {
    ActionMap actionMap;
    Map menuIdActionMap;
    MenuManager menuManager;
    protected DualHashBidiMap listeners = new DualHashBidiMap();

    public MenuActionsMap(ActionMap actionMap, MenuManager menuManager) {
        this.actionMap = actionMap;
        this.menuManager = menuManager;
        this.menuIdActionMap = new HashMap();
    }

    public Action getConcreteAction(String string) {
        return (Action)this.listeners.get(string);
    }

    public String getStringFromAction(Action action) {
        return (String)this.listeners.getKey(action);
    }

    public void addHandler(String string, AbstractAction abstractAction) {
        this.listeners.put(this.menuManager.getActionStringFromId(string), abstractAction);
        this.menuIdActionMap.put(string, abstractAction);
    }

    public Action getActionFromMenuId(String string) {
        return (Action)this.menuIdActionMap.get(string);
    }

    public void setEnabledDocumentMenuActions(boolean bl) {
        for (String string : this.listeners.keySet()) {
            GlobalMenuAction globalMenuAction = (GlobalMenuAction)this.listeners.get(string);
            if (!globalMenuAction.needsDocument()) continue;
            this.menuManager.setActionEnabled(string, bl && globalMenuAction.allowed(bl));
        }
    }

    public static abstract class GlobalMenuAction
    extends AbstractAction {
        protected boolean needsDocument() {
            return false;
        }

        protected boolean allowed(boolean bl) {
            return true;
        }
    }

    public static abstract class DocumentMenuAction
    extends GlobalMenuAction {
        @Override
        protected boolean needsDocument() {
            return true;
        }
    }
}

