/*
 * -- TRANSFO.C
 */

#include "transfo.h"

/* -- ROTATE_COURBE
 *
 * opere une rotation sur les coordonnees de la courbe.
 * le triaxe est le meme que dans pov :
 *          y^  z
 *           | /      le sens positif est indique par la main
 *           |/       gauche avec le pouce dans le sens de l'axe
 *           /--->x
 *
 *          ____\ angley > 0
 *         /    / 
 *         | y.
 */
void rotate_courbe(float anglex, float angley, float anglez,
                   Coords* courbe, int max) {
  float A=(float)anglex*3.14159265359/180;
  float B=(float)angley*3.14159265359/180;
  float C=(float)anglez*3.14159265359/180;
  float x10, y10, z10, x11, y11, z11, x12, y12, z12, x13, y13, z13;
  int i;

  for (i=0; i<max; i++) {
    x10 = courbe[i].x;
    y10 = courbe[i].y;
    z10 = courbe[i].z;
    x11 = x10;
    y11 = y10*cos(A) - z10*sin(A);
    z11 = y10*sin(A) + z10*cos(A);
    x12 = x11*cos(B) + z11*sin(B);
    y12 = y11;
    z12 = -x11*sin(B)+ z11*cos(B);
    x13 = x12*cos(C) - y12*sin(C);
    y13 = x12*sin(C) + y12*cos(C);
    z13 = z12;
    courbe[i].x = x13;
    courbe[i].y = y13;
    courbe[i].z = z13;
  }
}

/* -- ROTATE_NAPPE
 *
 * opere une rotation sur les coordonnees de la nappe.
 * le triaxe est le meme que dans pov :
 *          y^  z
 *           | /      le sens positif est indique par la main
 *           |/       gauche avec le pouce dans le sens de l'axe
 *           /--->x
 *
 *          ____\ angley > 0
 *         /    / 
 *         | y.
 */
void rotate_nappe(float anglex, float angley, float anglez,
                  Paire* nappe, int max) {
  Coords *courbe1, *courbe2;
  int i;

  courbe1 = (Coords*)calloc(max, sizeof(Coords));
  courbe2 = (Coords*)calloc(max, sizeof(Coords));

  for (i=0; i<max; i++) {
    nappe2courbe(nappe, courbe1, courbe2, max);
    rotate_courbe(anglex, angley, anglez, courbe1, max); 
    rotate_courbe(anglex, angley, anglez, courbe2, max);
    courbe2nappe(courbe1, courbe2, nappe, max);
  }

  free(courbe1);
  free(courbe2);
}
