/*
 * -- TRIANGLE.C
 */

#include "triangle.h"

/* -- TRIANGULARISE
 *
 * produit un define contenant les triangles composant la forme 3D
 *  definie par le tableau de paires de coordonnees appele nappe,
 *  dans le fichier defini par son stream.
 * pour eviter de donner 2 fois le meme nom aux defines POV, un 
 *  entier servant d'index est passe en argument et est concatene
 *  au nom du define, il est ensuite rendu incremente de 1.
 * l'utilisation de cette procedure est la suivante :
 *
 * int i=0;
 * i = triangularise(mon_fichier, nappe1, i);
 * if i=0 then printf("plante !!");
 * i = triangularise(mon_fichier, nappe2, i);
 * if i=0 then printf("plante !!");
 */
int triangularise(FILE* stream, Paire* nappe, int max, int index) {
  char index_str[10];
  int  i;

  fputs("#declare nappe_", stream);
  sprintf(index_str, "%i", index);
  fputs(index_str, stream);
  fputs(" = \n", stream);

  fputs("union {\n", stream);
  for (i=1; i<max; i++) {
    fputs("  triangle {\n"
          "    < ", stream);
    sprintf(index_str, "%f", nappe[i-1].a.x);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i-1].a.y);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i-1].a.z);
    fputs(index_str, stream);
    fputs(">,\n", stream);

    fputs("    < ", stream);
    sprintf(index_str, "%f", nappe[i-1].b.x);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i-1].b.y);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i-1].b.z);
    fputs(index_str, stream);
    fputs(">,\n", stream);

    fputs("    < ", stream);
    sprintf(index_str, "%f", nappe[i].a.x);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i].a.y);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i].a.z);
    fputs(index_str, stream);
    fputs(">\n"
          "  }\n", stream);

    fputs("  triangle {\n"
          "    < ", stream);
    sprintf(index_str, "%f", nappe[i-1].b.x);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i-1].b.y);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i-1].b.z);
    fputs(index_str, stream);
    fputs(">,\n", stream);

    fputs("    < ", stream);
    sprintf(index_str, "%f", nappe[i].b.x);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i].b.y);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i].b.z);
    fputs(index_str, stream);
    fputs(">,\n", stream);

    fputs("    < ", stream);
    sprintf(index_str, "%f", nappe[i].a.x);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i].a.y);
    fputs(index_str, stream);
    fputs(", ", stream);
    sprintf(index_str, "%f", nappe[i].a.z);
    fputs(index_str, stream);
    fputs(">\n"
          "  }\n", stream);
  }  
  fputs("}\n", stream);

  return ++index;
}
