/*
 * -- POVMAKER.C
 */

#define NOM_FICHIER "my_scene.pov"

#include "povcreate/povcreate.h"

#define library      "+L../include \0"
#define inputfile    "+I./my_scene.pov \0"
#define outputfile   "+O./images/morph"
#define largeur      "+W352 \0"
#define hauteur      "+H288 \0"
#define antialiasing "+A1.5 \0"
#define rays         "+R3 \0"
#define interruption "+X \0"
#define statistiques "+V \0"
#define format       "+FT \0"

void fabrique_tranche_de_cube_avec_tranche_de_sphere(Paire *sphere,
                                                     Paire *cube,
                                                     int max,
                                                     float morph) {
  int i;
  float proche = 1;

  for (i=0; i<max; i++) {
    if ((fabs((double)sphere[i].a.x) >= fabs((double)sphere[i].a.y)) &&
        (fabs((double)sphere[i].a.x) >= fabs((double)sphere[i].a.z)))
      proche = fabs((double)sphere[i].a.x);
    else if ((fabs((double)sphere[i].a.y) >= fabs((double)sphere[i].a.x)) &&
             (fabs((double)sphere[i].a.y) >= fabs((double)sphere[i].a.z)))
      proche = fabs((double)sphere[i].a.y);
    else if ((fabs((double)sphere[i].a.z) >= fabs((double)sphere[i].a.x)) &&
             (fabs((double)sphere[i].a.z) >= fabs((double)sphere[i].a.y)))
      proche = fabs((double)sphere[i].a.z);
    proche = 1+(morph*(proche-1)/100);
    cube[i].a.x = sphere[i].a.x / proche;
    cube[i].a.y = sphere[i].a.y / proche;
    cube[i].a.z = sphere[i].a.z / proche;
    if ((fabs((double)sphere[i].b.x) >= fabs((double)sphere[i].b.y)) &&
        (fabs((double)sphere[i].b.x) >= fabs((double)sphere[i].b.z)))
      proche = fabs((double)sphere[i].b.x);
    else if ((fabs((double)sphere[i].b.y) >= fabs((double)sphere[i].b.x)) &&
             (fabs((double)sphere[i].b.y) >= fabs((double)sphere[i].b.z)))
      proche = fabs((double)sphere[i].b.y);
    else if ((fabs((double)sphere[i].b.z) >= fabs((double)sphere[i].b.x)) &&
             (fabs((double)sphere[i].b.z) >= fabs((double)sphere[i].b.y)))
      proche = fabs((double)sphere[i].b.z);
    proche = 1+(morph*(proche-1)/100);
    cube[i].b.x = sphere[i].b.x / proche;
    cube[i].b.y = sphere[i].b.y / proche;
    cube[i].b.z = sphere[i].b.z / proche;
  }
}

int main(void) {
  FILE*  stream;
  int    i, j, num_define;
  int    max=160;   /* nombre de tranche de la sphere et du cube */
  int    jmax=400;  /* nombre d'images de l'animation */
  Paire  *sphere, *cube;
  Coords *courbe1, *courbe2;
  char   commande[400], outputfiles[40], index_str[20];

  for (j=1; j<=jmax; j++) {
    num_define = 0;
    if ((stream = fopen(NOM_FICHIER, "w")) == NULL) {
      fprintf(stderr, "povmaker : impossible d'ouvrir le fichier %s\n",
              NOM_FICHIER);
      return 1;
    }
  
    sphere = (Paire*)calloc(max, sizeof(Paire));
    cube = (Paire*)calloc(max, sizeof(Paire));
    courbe1 = (Coords*)calloc(max, sizeof(Coords));
    courbe2 = (Coords*)calloc(max, sizeof(Coords));

    /* debut du script pov : les includes et les declare de la
       texture de l'objet et du ciel */ 
    fputs("#include \"colors.inc\"\n"
          "#include \"textures.inc\"\n"
          "#include \"stones.inc\"\n\n"
          "#declare Sky_Top = 100\n\n"
          "#declare Colors3 =\n" 
          "color_map  {\n"
          "  [0.0 0.1 color SkyBlue color SkyBlue]\n"
          "  [0.70 color rgb <4/5, 4/5, 5/6>]\n"
          "  [1.0 color White]\n"
          "}\n\n"
          "#declare Storm =\n"
          "color_map {\n"
          "  [0.0 0.1 color Clear color Clear]\n"
          "  [0.70 color rgbf <4/5, 4/5, 5/6, 1/2>]\n"
          "  [1.0 color White]\n"
          "}\n\n"
          "#declare CloudSky =\n"
          "texture {\n"
          "   pigment {\n"
          "      bozo\n"
          "      turbulence 0.5\n"
          "      octaves 3\n"
          "      lambda 6\n"
          "      color_map { Colors3 }\n"
          "      }\n"
          "   finish { ambient 1 diffuse 0 }\n"
          "   scale 1/6\n"
          "   }\n\n"
          "#declare bigarre =\n"
          "texture {\n"
          "  pigment {\n"
          "    bozo\n"
          "    turbulence 2.00  octaves 1  omega 0.01  lambda 0.00\n"
          "    color_map {\n"
          "      [0.00 color rgbf<1.00, 1.00, 1.00, 1.00>]\n"
          "      [0.35 color rgbf<1.00, 0.00, 0.00, 0.39>]\n"
          "      [0.50 color rgbf<0.00, 1.00, 0.00, 0.20>]\n"
          "      [0.65 color rgbf<0.00, 0.00, 1.00, 0.39>]\n"
          "      [1.00 color rgbf<1.00, 1.00, 1.00, 1.00>]\n"
          "    }\n"
          "    phase 0.16\n"
          "    rotate <2.00,4.00,6.00>\n"
          "  }\n"
          "  finish {\n"
          "    ambient 0.50\n"
          "  }\n"
          "}\n"
          "texture {\n"
          "  pigment {\n"
          "    gradient x\n"
          "    turbulence 2.00  octaves 1  omega 0.01  lambda 0.00\n"
          "    color_map {\n"
          "      [0.00 color rgbf<1.00, 1.00, 1.00, 1.00>]\n"
          "      [0.30 color rgbf<0.00, 1.00, 1.00, 0.39>]\n"
          "      [0.50 color rgbf<1.00, 1.00, 0.00, 0.14>]\n"
          "      [0.70 color rgbf<1.00, 0.00, 1.00, 0.39>]\n"
          "      [1.00 color rgbf<1.00, 1.00, 1.00, 1.00>]\n"
          "    }\n"
          "    rotate <0.00,6.00,0.00>\n"
          "  }\n"
          "  normal {\n"
          "    bumps 1.00\n"
          "    scale <0.35,0.35,0.30>\n"
          "  }\n"
          "  finish {\n"
          "    brilliance 2.00\n"
          "    specular 0.26    roughness 0.20    metallic\n"
          "    reflection 0.45\n"
          "  }\n"
          "}\n\n", stream);

    /* fabrication d'une tranche de sphere */
    for (i=0; i<max; i++) {
      courbe1[i].x = cos(i*3.14159265357/(max-1));
      courbe1[i].y = sin(i*3.14159265357/(max-1));
      courbe1[i].z = 0;
      courbe2[i].x = courbe1[i].x;
      courbe2[i].y = courbe1[i].y;
      courbe2[i].z = courbe1[i].z;
    }
    rotate_courbe(360/(max*70/100), 0, 0, courbe2, max);
    /* on force un recouvrement de 30% pour eviter les trous
       dus aux erreurs d'arrondis pendant l'intersection pov */
    courbe2nappe(courbe1, courbe2, sphere, max);

    /* ecriture des declare de nappe dans le script */
    for (i=0; i<max; i++) {
      rotate_nappe((float)(360/((float)max-1)), 0, 0, sphere, max);
      if (j <= jmax/2)
        fabrique_tranche_de_cube_avec_tranche_de_sphere(sphere, cube, max,
                  (float)j*(100/((float)jmax/2)));
      else
        fabrique_tranche_de_cube_avec_tranche_de_sphere(sphere, cube, max,
                  100-((float)j-(float)jmax/2)*100/((float)jmax/2));      	
      num_define = triangularise(stream, cube, max, num_define);
    }
  
    /* ecriture de l'objet dans le script */
    fputs("\n"
          "union {\n", stream);
    for (i=0; i<max; i++) {
      fputs("  object {\n"
            "    nappe_", stream);
      sprintf(index_str, "%i", i);
      fputs(index_str, stream);
      fputs("\n"
            "  }\n", stream);
    }
    
    /* fin du script : l'environnement (camera, lumiere, ciel, etc) */
    fputs("  texture {\n"
          "    Stone21\n"   /* Stone 21 n'est pas mal non plus ! */
          "    scale 0.8\n"
          "  }\n"
          "rotate <0, ", stream);
    sprintf(index_str, "%f", (float)((float)j)*360/(jmax/2));
    fputs(index_str, stream);
    fputs(", 0>\n"
          "}\n"
          "\n", stream);
  
    /* ecriture de l'environnement dans le script */
    fputs("sphere {\n"
          "  <0, 0, 0>, 1\n"
          "  texture { pigment { color SkyBlue } }\n"
          "  texture { CloudSky }\n"          
          "  rotate <-", stream);
          sprintf(index_str, "%f", (float)((float)j)*360/jmax);
          fputs(index_str, stream);
    fputs(", 0, 0>\n"
          "  scale <Sky_Top*10, Sky_Top, Sky_Top*10>\n"
          "}\n\n"
          "light_source {\n"
          "  <15, 15, -15>\n"
          "  color LightGray\n"
          "}\n\n"
          "light_source {\n"
          "  <0, 0, -100>\n"
          "  color LightGray\n"
          "}\n\n"
          "camera {\n"
          "  location <0, 0, -4>\n"
          "  look_at <0, 0, 0>\n"
          "}\n", stream);
  
    free(sphere);
    free(cube);
    free(courbe1);
    free(courbe2);
    fclose(stream);
    
    strcpy(outputfiles, outputfile);
    sprintf(index_str, "%i", j);
    if (strlen(index_str)==1)
      strcat(outputfiles, "00");
    else if (strlen(index_str)==2)
      strcat(outputfiles, "0");
    strcat(outputfiles, index_str);
    strcat(outputfiles, ".tga ");
    
    strcpy(commande,"povray \0");
    strcat(commande,library);
    strcat(commande,inputfile);
    strcat(commande,outputfiles);
    strcat(commande,largeur);
    strcat(commande,hauteur);
    strcat(commande,antialiasing);
    strcat(commande,rays);
    strcat(commande,interruption);
    strcat(commande,statistiques);
    strcat(commande,format);
    /*strcat(commande," +D");*/

    if (-1==system(commande)) printf(" foire !!\n");

    strcpy(commande, "rm ");
    strcat(commande, NOM_FICHIER);
    system(commande);
  }
  
  return 0;
}
