#declare SkinFade = rgb <0, -0.16 * clock, -0.27 * clock>
#declare Fade = White * 0.19 * clock

#declare Lips = blob
{
	threshold 0.6
	sphere { 0, 0.25, 1
		scale <3.5, 1, 0.5>
		rotate z*-15
		translate x*0.45
		pigment { color (Red/4 + Flesh*.75 - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <3.5, 1, 0.5>
		rotate z*15
		translate x*-0.45
		pigment { color (Red/4 + Flesh*.75 - SkinFade) } }
	sphere { 0, 0.25, 1
		scale <2, 1, 0.5>
		rotate z*30
		translate <0.575, -0.365, 0>
		pigment { color (Red/4 + Flesh*.75 - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <2, 1, 0.5>
		rotate z*-30
		translate <-0.575, -0.365, 0>
		pigment { color (Red/4 + Flesh*.75 - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <3, 1, 0.5>
		translate y*-0.385
		pigment { color (Red/4 + Flesh*.75 - SkinFade) }
		}
	finish { Dull }
}

#declare Nose = blob
{
	threshold 0.6
	sphere { 0, 0.25, 1
		scale <1, 3.5, 1>
		pigment { color (Flesh - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <0.75, 0.75, 0.6>
		translate <-0.175, -0.25, 0>
		pigment { color (Flesh - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <0.75, 0.75, 0.6>
		translate <0.175, -0.25, 0>
		pigment { color (Flesh - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <1, 3.5, 1>
		translate y*0.5
		pigment { color (Flesh - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <3.5, 1, 0.4>
		rotate z*(15 - 5*clock)
		translate <0.4, 1, 0>
		pigment { color (Brown + Fade) }
		normal { gradient x }
		}
	sphere { 0, 0.25, 1
		scale <3.5, 1, 0.4>
		rotate z*(-15 + 5*clock)
		translate <-0.4, 1, 0>
		pigment { color (Brown + Fade) }
		normal { gradient x }
		}
	sphere { 0, 0.25, 1
		scale <1.5, 0.7, 0.3>
		translate <0.95, 1.1, 0>
		pigment { color (Flesh - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <1.5, 0.7, 0.3>
		translate <-0.95, 1.1, 0>
		pigment { color (Flesh - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <0.7, 2.5, 0.25>
		translate <1.15, 0.75, 0>
		pigment { color (Flesh - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <0.7, 2.5, 0.25>
		translate <-1.15, 0.75, 0>
		pigment { color (Flesh - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <2.5, 1.25, 0.3>
		translate <0.85, 0.3, 0>
		pigment { color (Flesh - SkinFade) }
		}
	sphere { 0, 0.25, 1
		scale <2.5, 1.25, 0.3>
		translate <-0.85, 0.3, 0>
		pigment { color (Flesh - SkinFade) }
		}

	sphere { 0, 0.27, -1
		scale <1.25, 1, 1>
		translate <0.4, 0.65, 0>
		pigment { color (Flesh - SkinFade) }
		}
	sphere { 0, 0.27, -1
		scale <1.25, 1, 1>
		translate <-0.4, 0.65, 0>
		pigment { color (Flesh - SkinFade) }
		}
	sphere { 0, 0.25, -1
		scale <2.89, 1.5, 1>
		translate <0, -0.89, 0>
		pigment { color (Flesh - SkinFade) }
		}

	sphere { 0, 0.25, 1
		scale <13, 16, 0.1>
		//translate z*0.025
		pigment { color (Flesh - SkinFade) }
		}
	finish { Dull }
}

#declare Eye = union
{
   sphere { 0, 1
	pigment { color Clear }
	finish { Glossy ambient 0.6 }
	no_shadow
	}
   disc { 0, z*-1, 1.2 translate z*1 pigment { color White*0.5 } finish { ambient 1 } no_shadow }
   sphere { 0, 0.9
	pigment { marble
		  turbulence 0.3
		  color_map {
			[0 color White*0.85]
			[0.95 color White*0.85]
			[1 color Red]
			}
		}
	finish { ambient 0.6 }
	no_shadow
	}
   sphere { 0, 0.75
	pigment { color Brown + Fade }
	finish { ambient 0.4 }
	translate z*-0.2
	no_shadow
	}
   sphere { 0, 0.2
	pigment { color White*0.1 }
	finish { ambient 0.6 }
	translate <-0.07, 0, -0.79>
	no_shadow
	}
   rotate y*(sin(clock * 2 * pi) * -5)
}

#declare Strand = object
{

        #declare XY_Angle = 70
        #declare Flex = 0.15
        #declare Length = 1.25
	#declare Radius = 0.025
        #include "hair.inc"
        pigment { color rgbt <1.0, 0.8, 0.3 + 0.5*clock, 0.8> }
	finish { ambient 0.4 }
	normal { granite }
        rotate x*90
}

#declare Sway = sin(clock * 2 * pi) * 25

#declare Wig =
union {

object { Strand
	rotate z*(90 + Sway)
	translate <0.05, 1.9, 0>
	}

object { Strand
	rotate z*(90 + Sway)
	translate <-0.075, 1.92, 0>
	}

object { Strand
	rotate z*(93 + Sway)
	translate <-0.3, 1.85, 0>
	}
object { Strand
	rotate z*(85 + Sway)
	translate <0.4, 1.85, 0>
	}
object { Strand
	rotate z*(100 + Sway)
	translate <-0.22, 1.8, 0>
	}
object { Strand
	rotate z*(80 + Sway)
	translate <0.25, 1.82, 0>
	}
object { Strand
	rotate z*(120 + Sway)
	translate <-0.45, 1.72, 0>
	}
object { Strand
	rotate z*(70 + Sway)
	translate <0.47, 1.7, 0>
	}
object { Strand
	rotate z*(135 + Sway)
	translate <-0.78, 1.52, 0>
	}
object { Strand
	rotate z*(55 + Sway)
	translate <0.75, 1.5, 0>
	}
object { Strand
	rotate z*(130 + Sway)
	translate <-0.7, 1.62, 0>
	}
object { Strand
	rotate z*(60 + Sway)
	translate <0.7, 1.6, 0>
	}
object { Strand
	rotate z*(145 + Sway)
	translate <-1.02, 1.22, 0>
	}
object { Strand
	rotate z*(40 + Sway)
	translate <1, 1.3, 0>
	}
object { Strand
	rotate z*(155 + Sway)
	translate <-1.2, 1, 0>
	}
object { Strand
	rotate z*(25 + Sway)
	translate <1.15, 1.05, 0>
	}

}

#declare Tear =
sphere { 0, 0.04
    scale <1, 0.75, 1>
	pigment { color rgbf <1, 1, 1, 0.9> } finish { Shiny ambient 0.8 ior 2} }

#declare Face = union {
object { Lips translate y*-0.75 finish { ambient 0.6 + 0.2*clock} }
object { Nose finish { ambient 0.6 + 0.2*clock} }
object { Eye scale 0.25 translate <0.4 + 0.03, 0.65, 0.25> }
object { Eye scale 0.25 rotate z*180 translate <-0.43, 0.65, 0.25> }
#ifndef(PROTO)
   object { Wig }
#end
disc { 0, z*-1, 0.65 translate <0, -0.85, 0.05>
	pigment { color Flesh/12 + Red/12 }
	finish { ambient 1 }
	}
}

