//#declare PROTO=1 

#ifdef(PROTO)
#debug "Warning, prototype only!"
#end

#include "colors.inc"
#include "finish.inc"
#include "face.inc"
#include "surface.inc"
#include "skies.inc"

background { color White*0.5 }

camera { location <0, 1.5, 1> look_at z*1 sky z*-1 }

light_source { <-1000, 1000, -1000> color White }

#ifndef(PROTO)
sky_sphere { S_Cloud2 }
#end

object { Face rotate x*-90 rotate y*180 translate <0, 2, 0> }

#if(clock*120 < 41)
	plane { y*1, 0 texture { Surface } no_shadow }
#else
	#include "waveform.inc"
	object { WaveSurface
		rotate y*180
		scale <2, 0.04, 2>
		texture { Surface }
		no_shadow
		}
#end

plane { y*1, -10 pigment { color White*0.15 } no_shadow }

/*
#ifdef(PROTO)
box { <-2, 0.1, -2>, <2, -0.5, 2>
	pigment { color Green }
	}
#end
*/

/*
sphere { <0, 0, 0.4>, 0.015 pigment { color Red } no_shadow }
sphere { <0.1, 0, 0.7> 0.015 pigment {color Red } no_shadow }
sphere { <-0.1, 0, 0.7> 0.015 pigment { color Red } no_shadow }

sphere { <0, 0, 0>, 0.015 pigment { color Red } no_shadow }
sphere { <0.4, 0, 0.65> 0.015 pigment {color Red } no_shadow }
sphere { <-0.4, 0, 0.65> 0.015 pigment { color Red } no_shadow }

sphere { <0, 1.8, 0>, 0.05 pigment { color Blue } no_shadow }
sphere { <0.3, 1.8, 0.65> 0.05 pigment {color Blue } no_shadow }
sphere { <-0.3, 1.8, 0.65> 0.05 pigment { color Blue } no_shadow }
*/

#if(clock*120 >= 21 & clock*120 <= 40)
	object { Tear translate <0, 1.8 - (clock*120 - 20)*1.8/20, 0> }
#end

#if(clock*120 >= 28 & clock*120 <= 47)
	object { Tear translate <0.4, 1.8 - (clock*120 - 27)*1.8/20, 0.65> }
#end

#if(clock*120 >= 33 & clock*120 <= 52)
	object { Tear translate <-0.4, 1.8 - (clock*120 - 32)*1.8/20, 0.65> }
#end
