
static define shiny_black
texture { shiny { color black } }

static define ant
object {
	  object {
	  	sphere <0, 0.06, 0>, 0.04 }
	+ object {
		sphere <0, 0.1, -0.18>, 0.09 }
	+ object {
		sphere <0, 0.07, 0.12>, 0.06 }
	texture {
		shiny {
			color <0.3, 0.2, 0.1>
			}
		}
	}

static define anthill
object {
	sphere <0, 0, 0>, 5
	texture {
		special surface {
			color spherical_imagemap(image("anthill2.jpg"),P)
			}
		}
	}

define erode_exper (noise(5*P, 2) / 3 + |x * 2| > 0.45 ? 1 : 0)

static define gravel_road
object {
	box <-0.2, -0.1, -25>, <0.2, 0.001, 0>
	texture {
		special surface {
			color White * 0.5
			ambient 0
			diffuse 0.7 - 0.5 * erode_exper
			transmission erode_exper, 1
			}
		}
	}

static define paved_road
object {
	box <-0.4, -0.1, -25>, <0.4, 0.002, 0>
	matte_black
	}

static define mud_hut
object {
	  object { sphere <0, 0, 0>, 0.6 }
	- object { sphere <0, 0, 0>, 0.5 }
	texture { matte { color <0.45, 0.27, 0.09> } }
	}

static define square_exper (|fmod(P[0], 1)| < 0.15 ? 1
                     : (|fmod(P[1], 1)| < 0.15 ? 1 : 0))

static define mortar
texture {
   special surface {
      ambient square_exper * grey, 0.1
      diffuse square_exper * grey, 0.6
      transmission white, 1 - square_exper, 1.0
      }
   }

static define bricks
texture {
   special matte {
      color <0.7, 0.25, 0.3>
      normal N + (dnoise (3*P) - <0.5, 0.5, 0.5>)
      }
   scale <0.01, 0.01, 0.01>
   }

static define brick_wall // this is in the x-y plane only so it need to be
                         // rotated for walls in other orientations
texture {
   layered mortar, bricks
   translate <0.5, 0, 0>
   }

// a little hut
static define front_wall_a
object {
     object { box <0, 0, 0>, <6, 2.5, 0.4> } // the wall itself
   - object { box <1.5, 1.5, -0.1>, <2, 2, 0.5> } // the window
   - object { box <3.5, 0, -0.1>, <4.5, 2, 0.5> } // the door
   brick_wall { scale <0.5, 0.25, 1> }
   }

static define back_wall_a
object {
     object { box <0, 0, 0>, <6, 3, 0.4> } // the wall itself
   - object { box <1.5, 1.5, -0.1>, <2, 2, 0.5> } // window
   - object { box <4, 1.5, -0.1>, <4.5, 2, 0.5> }// window
   brick_wall { scale <0.5, 0.25, 1> }
   }

static define side_wall_a
object {
   ( object { polygon 4, <0, 0, 0>, <0, 2.5, 0>, <0, 3, 4>, <0, 0, 4> }
   + object { polygon 4, <0.4, 0, 0>, <0.4, 2.5, 0>, <0.4, 3, 4>, <0.4, 0, 4> })
   - object { box <-0.1, 1.5, 2>, <0.5, 2, 2.5> }
   brick_wall { scale <0.5, 0.25, 1> rotate <0, 90, 0> }
   }

static define roof_a
object {
   box <-0.2, 0, -0.4>, <6.2, 0.1, 4.43>
   rotate <-7.125, 0, 0>
   matte_brown
   }

static define hut_a
object {
     front_wall_a
   + back_wall_a { translate <0, 0, 3.6> }
   + side_wall_a
   + side_wall_a { translate <5.6, 0, 0> }
   + roof_a { translate <0, 2.5, 0> }
   scale <0.25, 0.25, 0.25>
   }

static define house
object {
	  object {
        object { box <-1.3, 0, -0.5>, <1.3, 0.2, 1> }
	  	+ object { box <-0.3, 0, -1>, <0.3, 0.2, -0.5> }
	  	texture { matte { color White * 0.55 } }
	  	}
	+ object {
		  object { box <-1.3, 0.2, -0.5>, <1.3, 2.5, 1> }
		* object {
			box <-1.5, -1.5, -1.5>, <1.5, 1.5, 1.5>
			rotate <45, 0, 0>
			translate <0, 0, 0.25>
         texture { matte { color <0, 0.35, 0.2> } }
			}
      + object { cylinder <-0.3, 0.2, -1>, <-0.3, 0.7, -1>, 0.01 }
      + object { cylinder <0.3, 0.2, -1>, <0.3, 0.7, -1>, 0.01 }
		matte_white
		}
	+ object {
		polygon 4, <-0.3, 0.7, -1>, <0.3, 0.7, -1>,
					  <0.3, 0.9, -0.5>, <-0.3, 0.9, -0.5>
		texture { matte { color <0, 0.35, 0.2> } }
		}
   + object { box <-1, 0.4, -0.51>, <-0.7, 0.7, 1.01> }
	+ object { box <1, 0.4, -0.51>, <0.7, 0.7, 1.01> }
   + object { box <-0.15, 0.4, 0>, <0.15, 0.7, 1.01> }
	+ object { box <-1, 0.95, -0.51>, <-0.7, 1.25, 1.01> }
	+ object { box <1, 0.95, -0.51>, <0.7, 1.25, 1.01> }
	+ object { box <-0.1, 1, -0.51>, <0.1, 1.2, 1.01> }
	+ object { box <-1.31, 0.95, 0.1>, <1.31, 1.25, 0.4> }
	+ object { box <-1.31, 0.4, 0.1>, <1.31, 0.7, 0.4> }
	+ object { box <-1.31, 1.5, 0.15>, <1.31, 1.7, 0.35> }
	shiny_black
	}

static define high_house
object {
	  object { box <-1.5, 0, -1.5>, <-1, 4.4, -1> }
	+ object { box <1.5, 0, -1.5>, <1, 4.4, -1> }
	+ object { box <-1.5, 0, 1.5>, <-1, 4.4, 1> }
	+ object { box <1.5, 0, 1.5>, <1, 4.4, 1> }
	+ object { box <-1.1, 0, -1.1>, <1.1, 4.1, 1.1> shiny_black }
	+ object { box <-1.3, 0, -1.3>, <1.3, 0.2, 1.3> }
	+ object { box <-1.3, 0.6, -1.3>, <1.3, 0.9, 1.3> }
	+ object { box <-1.3, 1.3, -1.3>, <1.3, 1.6, 1.3> }
	+ object { box <-1.3, 2.0, -1.3>, <1.3, 2.3, 1.3> }
	+ object { box <-1.3, 2.7, -1.3>, <1.3, 3.0, 1.3> }
	+ object { box <-1.3, 3.4, -1.3>, <1.3, 3.7, 1.3> }
	+ object { box <-1.3, 4.1, -1.3>, <1.3, 4.4, 1.3> }
	matte_grey
	}

static define glass_tower
object {
     object { box <-1.2, 0.4, -1.2>, <1.2, 5, 1.2> }
	+ object { box <-1, 0, -1>, <1, 1, 1> }
	+ object { box <-1.2, 0, -1.2>, <-1.1, 1, -1,1> }
	+ object { box <1.2, 0, -1.2>, <1.1, 1, -1,1> }
	+ object { box <-1.2, 0, 1.2>, <-1.1, 1, 1,1> }
	+ object { box <1.2, 0, 1.2>, <1.1, 1, 1,1> }
	+ object { box <-1.2, 5, -1.2>, <1.2, 5.1, 1.2> matte_white }
   + object { box <-0.8, 5, -0.8>, <0.8, 5.5, 0.8> }
	+ object { box <-0.8, 5.5, -0.8>, <0.8, 5.6, 0.8> matte_white }
	mirror
	}

static define silver
texture {
	surface {
		color grey
   	ambient 0.1
	   diffuse 0.5
   	brilliance 6
	   specular 0.6
   	microfacet Phong 5
	   reflection white, 0.5
   	}
   }

static define tower1
object {
     object { cone <0, 0, 0>, 0.8, <0, 7, 0>, 0.5 }
   + object { disc <0, 7, 0>, <0, 1, 0>,  0.5 }
   + object { cylinder <0, 2.1, 0>, <0, 2.5, 0>, 1.3 }
	+ object { disc <0, 2.5, 0>, <0, 1, 0>, 1.3 }
   + object { cylinder <0, 2.9, 0>, <0, 3.3, 0>, 1.3 }
	+ object { disc <0, 3.3, 0>, <0, 1, 0>, 1.3 }
   + object { cylinder <0, 3.7, 0>, <0, 4.6, 0>, 1.3 }
	+ object { disc <0, 4.6, 0>, <0, 1, 0>, 1.3 }
   + object { cylinder <0, 5, 0>, <0, 5.4, 0>, 1.2 }
	+ object { disc <0, 5.4, 0>, <0, 1, 0>, 1.2 }
   + object { cylinder <0, 5.8, 0>, <0, 6.2, 0>, 1.1 }
	+ object { disc <0, 6.2, 0>, <0, 1, 0>, 1.1 }
   + object { cylinder <0, 6.6, 0>, <0, 7, 0>, 1 }
	+ object { disc <0, 7, 0>, <0, 1, 0>, 1 }
	silver
	}

static define tower2
object {
     object { cone <0, 0, 0>, 0.7, <0, 8, 0>, 0.4 }
   + object { disc <0, 8, 0>, <0, 1, 0>,  0.4 }
   + object { torus 1.3, 0.25, <0, 1.5, 0>, <0, 1, 0> }
	+ object { sphere <0, 0, 0>, 1.5 scale <1, 0.6, 1> translate <0, 2.6, 0> }
   + object { torus 1.45, 0.1, <0, 2.6, 0>, <0, 1, 0> }
   + object { cylinder <0, 3.8, 0>, <0, 4.6, 0>, 1.3 }
	+ object { disc <0, 4.6, 0>, <0, 1, 0>, 1.3 }
   + object { torus 1.2, 0.25, <0, 5.2, 0>, <0, 1, 0> }
   + object { sphere <0, 0, 0>, 1.1 scale <1, 0.6, 1> translate <0, 6.1, 0> }
   + object { torus 1.06, 0.08, <0, 6.1, 0>, <0, 1, 0> }
   + object { sphere <0, 0, 0>, 0.9 scale <1, 0.6, 1> translate <0, 7.5, 0> }
	+ object { torus 0.87, 0.07, <0, 7.5, 0>, <0, 1, 0> }
	silver
	}

static define tower1b
object {
	  tower1
	+ object { cylinder <0, 7, 0>, <0, 7.5, 0>, 0.4 }
   + object { cylinder <0, 7.4, 0>, <0, 8.1, 0>, 0.8 mirror }
   + object { disc <0, 7.4, 0>, <0, 1, 0>, 0.8 }
   + object { disc <0, 8.1, 0>, <0, 1, 0>, 0.8 }
	silver
	}

static define tower3
object {
	  object { cone <0, 0, 0>, 0.6, <0, 4, 0>, 0.45 }
	+ object {
		  object { sphere <0, 0, 0>, 1 }
      - object { torus cos(radians(20)), 0.04, <0, sin(radians(20)), 0>, <0, 1, 0> }
      - object { torus cos(radians(20)), 0.04, <0, -sin(radians(20)), 0>, <0, 1, 0> }
		+ object { torus cos(radians(40)), 0.03, <0, sin(radians(40)), 0>, <0, 1, 0> shiny_black }
		+ object { torus 1, 0.04, <0, 0, 0>, <0, 1, 0> shiny_black }
		+ object { torus cos(radians(40)), 0.03, <0, -sin(radians(40)), 0>, <0, 1, 0> shiny_black }
		scale <2.5, 0.7, 2.5>
		translate <0, 4, 0>
		}
	silver
	}

static define wallhanger
object {
     object { cylinder <0, 0, 0>, <0, 1, 0>, 1 }
	+ object { disc <0, 0, 0>, <0, 1, 0>, 1 }
	+ object { disc <0, 1, 0>, <0, 1, 0>, 1 }
	+ object { cylinder <0, 1, 0>, <0, 2, 0>, 0.3 }
	+ object {
		  object { sphere <0, 0, 0>, 1 }
      - object { torus cos(radians(20)), 0.04, <0, sin(radians(20)), 0>, <0, 1, 0> }
      - object { torus cos(radians(20)), 0.04, <0, -sin(radians(20)), 0>, <0, 1, 0> }
		+ object { torus cos(radians(40)), 0.03, <0, sin(radians(40)), 0>, <0, 1, 0> shiny_black }
		+ object { torus 1, 0.04, <0, 0, 0>, <0, 1, 0> shiny_black }
		+ object { torus cos(radians(40)), 0.03, <0, -sin(radians(40)), 0>, <0, 1, 0> shiny_black }
		scale <2.5, 1, 2.5>
		translate <0, 2.2, 0>
		}
	silver
	}

static define shiny_white texture { shiny { color white } }

static define adm_bldng
object {
	  object { box <-6, 0, 2.8>, <-3, 0.7, 4.3> }
	+ object { box <-5.9, 0.7, 2.9>, <-3.1, 1, 4.2> shiny_black }
	+ object { box <-6, 1, 2.8>, <-3, 1.2, 4.3> }
	+ object { box <-5.8, 1.2, 3.1>, <-4.5, 1.4, 4.1> }
	+ object { box <-5.7, 1.4, 3.2>, <-4.6, 1.7, 4> shiny_black }
	+ object { box <-5.8, 1.7, 3.1>, <-4.5, 1.85, 4.1> }
	matte_white
	}

static define asmbly_hall
object {
	  object { box <-8.5, 0, 0.3>, <-6.2, 3.3, 2.5> matte_white }
	- object { box <-8.3, 0, 0.5>, <-6, 3.2, 2.3> matte_black }
	+ object {
      polygon 4, <-6.2, 0, 0.5>, <(open==1?-5.3:-6.2), 0, (open==1?0.5:1.4)>,
					  <(open==1?-5.3:-6.2), 3.2, (open==1?0.5:1.4)>, <-6.2, 3.2, 0.5>
					  }
	+ object {
      polygon 4, <-6.2, 0, 2.3>, <(open==1?-5.3:-6.2), 0, (open==1?2.3:1.4)>,
					  <(open==1?-5.3:-6.2), 3.2, (open==1?2.3:1.4)>, <-6.2, 3.2, 2.3>
					  }
	texture { matte { color lightsteelblue } }
	}

static define contr_tower
object {
	  object { cone <0, 0, 0>, 0.4, <0, 3, 0>, 0.3 }
	+ object { torus 1.2, 0.23, <0, 2.8, 0>, <0, 1, 0> shiny_black }
	+ object { parabola <0, 3.4, 0>, <0, 3, 0>, 1.2 }
	matte_white
	}

static define tailfin
object {
	polygon 5, <0.1, 0.3, 0>, <0.2, 0, 0>, <0.56, 0, 0>,
				  <0.56, 0.5, 0>, <0.2, 0.8, 0>
	matte_red
	}

static define rocket
object {
	  object {
	  	lathe 2, <0, 1, 0>, 5,
	  		<0.1, 0.3>, <0.25, 0.9>, <0.25, 1.4>, <0.1, 2>, <0, 2.2>
	  	matte_white
	  	}
	+ tailfin
	+ tailfin { rotate <0, 90, 0> }
	+ tailfin { rotate <0, 180, 0> }
	+ tailfin { rotate <0, 270, 0> }
	rotate <0, 65, 0>
	scale <1, 1.2, 1>
	}

static define launch_pad
object {
	  object {
	  	box <-0.6, 0.3, -0.6>, <0.6, 0.5, 0.6>
	  	texture { matte { color <0.6, 0.2, 0.3> } }
	  	}
	+ object { cylinder <0.6, 0, -0.2>, <0.6, 3, -0.2>, 0.08 }
	+ object { cylinder <0.6, 0, 0.2>, <0.6, 3, 0.2>, 0.08 }
	+ object { cylinder <1, 0, -0.2>, <1, 3, -0.2>, 0.08 }
	+ object { cylinder <1, 0, 0.2>, <1, 3, 0.2>, 0.08 }
	+ object { box <0.6, 1, -0.2>, <1, 1.1, 0.2> }
	+ object { box <0.6, 1.5, -0.2>, <1, 1.6, 0.2> }
	+ object { box <0.6, 2, -0.2>, <1, 2.1, 0.2> }
	+ object { box <0.6, 2.5, -0.2>, <1, 2.6, 0.2> }
	+ object { box <0.6, 3, -0.2>, <1, 3.1, 0.2> }
	texture { matte { color <0.8, 0.3, 0.4> } }
	}

static define water
texture {
   noise surface {
      color <0.4, 0.5, 0.8>
      normal dented_normal
//      frequency 100
      bump_scale 1
      ambient 0.3
      diffuse 0.3
      specular white, 0.7
      reflection 0.6
      microfacet Reitz 10
      }
   scale <10, 1, 10> / 100
   }

static define sculpture
object {
	  object { box <-1, 0, -1>, <1, 0.4, 1> white_marble { scale white * 0.4 } }
	- object { box <-0.8, 0.3, -0.8>, <0.8, 0.5, 0.8> water }
	+ object { sphere <0, 1.6, 0>, 1 mirror }
	}

static define gold
texture {
   metallic {
      color <0.95, 0.7, 0.3>
      }
   }

static define sig
object {
	  object {
	  	cylinder <0, 3.75, 0>, <0, 3.75, 0.5>, 1
	  	uv_bounds 0.25, 0.75, 0, 1
	  	}
	+ object {
	  	cylinder <0, 0, 0>, <0, 0, 0.5>, 1
	  	uv_bounds 0.25, 0.75, 0, 1
	  	rotate <0, 0, 180>
	  	translate <0, 2, 0>
	  	}
	+ object {
	  	cylinder <0, 3.75, 0>, <0, 3.75, 0.5>, 0.75
	  	uv_bounds 0.25, 0.75, 0, 1
	  	}
	+ object {
	  	cylinder <0, 0, 0>, <0, 0, 0.5>, 0.75
	  	uv_bounds 0.25, 0.75, 0, 1
	  	rotate <0, 0, 180>
	  	translate <0, 2, 0>
	  	}
	+ object { box <0, 4.5, 0>, <1.6, 4.75, 0.5> }
	+ object { box <-0.7, 1, 0>, <0, 1.25, 0.5> }
	+ object { box <0, 1.1, 0>, <0.25, 4.7, 0.5> rotate <0, 0, -9> }
	+ object {
		disc <0, 3.75, 0>, <0, 0, 1>, 0.75, 1
		uv_bounds 0.5, 1, 0, 1
		}
	+ object {
		disc <0, 2, 0>, <0, 0, 1>, 0.75, 1
		uv_bounds 0, 0.5, 0, 1
		}
	+ object { box <-1.2, 0, -0.8>, <1.5, 1, 1.3> white_marble }
	gold
	scale white * 0.55
	}

