// ----- atmosphere

// background "light" source
sphere {
  <0,0,0> 1000000
  texture {
    pigment { color rgb <1,1,1> }
    finish {
      ambient 1.0
      diffuse 0.0}
    scale 1000000
  }
  hollow
}

// filtering atmosphere
sphere {
  <0,0,0> 10000
  texture {
    pigment {
      gradient y
      color_map {
        [0.00 color rgbf<0.922, 0.663, 0.451, 1>]
        [0.30 color rgbf<0.910, 0.545, 0.247, 1>]
        [1.00 color rgbf<0.910, 0.545, 0.247, 1>]
      }
    }
    finish {
      ambient 0.3
      diffuse 0.0
    }
    scale 10000
  }
  hollow
}

// ----- gas giant

// gas giant
#declare Planet_Radius = 25000
sphere {
  <0,0,0> Planet_Radius

  texture {
    pigment {
      image_map {
        tga "planet.tga"
        map_type 1
        interpolate 2
      }
    }
    finish {
      ambient 1.0
      diffuse 0.0
    }
  }
  texture {
    pigment {
      gradient -x
      color_map {
        [0.0 color rgbf <1,1,1,1>]
        [0.5 color rgb <1,1,1>]
        [1.0 color rgb <1,1,1>]
      }
    }
    finish {
      ambient 1.0
      diffuse 0.0
    }
    rotate <0,0,0>
    scale Planet_Radius*2
    translate <Planet_Radius,0,0>

  }
  rotate <0,20,45>

  no_shadow

  translate <0, 300, 60000>
  rotate <0,5,0>
}


// ----- major moon

// major moon
#declare Moon_Radius = 2000
sphere {
  <0,0,0> Moon_Radius

  texture {
    pigment {
      bozo
      turbulence 0.6  omega 0.8  lambda 3.0
      color_map {
        [0.00 color rgb<0.510, 0.510, 0.510>]
        [1.00 color rgb<1.000, 1.000, 1.000>]
      }
    }
    normal {
      bumps 1.0
      turbulence 0.6  octaves 5  omega 0.65  lambda 3.0
      scale <0.75, 0.75, 1.0>
    }
    finish {
      ambient 1.0
      specular 0.2
      diffuse 0.0
    }
    scale 900
  }

  texture {
    pigment {
      gradient -x
      color_map {
        [0.0 color rgbf <1,1,1,1>]
        [0.5 color rgbf <1,1,1,0.3>]
        [1.0 color rgbf <1,1,1,0>]
      }
    }
    finish {
      ambient 1.0
      diffuse 0.0
    }
    rotate <0,0,0>
    scale Moon_Radius*2
    translate <Moon_Radius,0,0>

  }
  rotate <0,20,45>

  no_shadow
 
  translate <0,2000,20000>
  rotate <0,-20,0>
}


// ----- minor moon in front of gas giant

// moon
#declare Moon_Radius = 750
sphere {
  <0,0,0> Moon_Radius

  texture {
    pigment { color rgb<0.78, 0.48, 0.44> }
    finish {
      ambient 1.0
      diffuse 0.0
    }
    scale 100
  }

  texture {
    pigment {
      gradient -x
      color_map {
        [0.0 color rgbf <1,1,1,1>]
        [0.5 color rgbf <1,1,1,0.3>]
        [1.0 color rgbf <1,1,1,0>]
      }
    }
    finish {
      ambient 1.0
      diffuse 0.0
    }
    rotate <0,0,0>
    scale Moon_Radius*2
    translate <Moon_Radius,0,0>

  }
  rotate <0,20,45>

  no_shadow
 
  translate <0,1500,25000>
  rotate <0,10,0>
}

// ----- minor moon to the right side of the gas giant

// moon
#declare Moon_Radius = 300
sphere {
  <0,0,0> Moon_Radius

  texture {
    pigment { color rgb<0.47, 0.47, 0.70> }
    finish {
      ambient 1.0
      diffuse 0.0
    }
    scale 100
  }

  texture {
    pigment {
      gradient -x
      color_map {
        [0.0 color rgbf <1,1,1,1>]
        [0.5 color rgbf <1,1,1,0.5>]
        [1.0 color rgbf <1,1,1,0>]
      }
    }
    finish {
      ambient 1.0
      diffuse 0.0
    }
    rotate <0,0,0>
    scale Moon_Radius*2
    translate <Moon_Radius,0,0>

  }
  rotate <0,20,45>

  no_shadow
 
  translate <0,5500,25000>
  rotate <0,50,0>
}


// ----- horizon
#include "horizon.inc"
cylinder {
  <0,0,0> <0,600,0> 700
  open
  
  texture {
    T_Horizon
    scale <1,600,1>
  }

  rotate <0,-70,0>
  hollow 
}
