$HEADER="#include \"colors.inc\"
#include \"textures.inc\"
#include \"shapes.inc\"

background { SkyBlue }

";

# goto create;

$in="spheres.txt";
open (SPHERES, $in) || die "Cant open $in\n";
while (<SPHERES>) {
    my ($n, $x, $y, $z) = split;
    $B{$n}{'x'} = $x;
    $B{$n}{'y'} = $y;
    $B{$n}{'z'} = $z;
    $B{$n}{'xw'} = 0;
    $B{$n}{'yw'} = 0;
    $B{$n}{'zw'} = 0;
    $B{$n}{'sx'} = 1;
    $B{$n}{'sy'} = 1;
    $B{$n}{'sz'} = 1;
    $B{$n}{'sxw'} = 0;
    $B{$n}{'syw'} = 0;
    $B{$n}{'szw'} = 0;
    $B{$n}{'r'} = .9;
    $B{$n}{'s'} = 1;
    my($total) = abs($x + $y + $z);
    $B{$n}{'c'} = "Black" if ($total == 0);
    $B{$n}{'c'} = "White" if ($total == 1);
    $B{$n}{'c'} = "Black" if ($total == 2);
    $B{$n}{'c'} = "White" if ($total == 3);
    # Middle ball is special
    if ($x == 0 && $y == 0 && $z == 0) {
        $mid = $n;
        $B{$n}{'r'} = 3;
        $B{$n}{'c'} = "White";
    }

}
close SPHERES;

$tgas="targas";
$povs="povs";

mkdir ($tgas, 777) if (! -d $tgas);
mkdir ($povs, 777) if (! -d $povs);

$POVOPT="+H240 +W320 +v -p -GA +a -dGT";

$realframe=0;

$startframe0=0;
$maxframe0=20;

$startframe1=1;
$maxframe1=50;

$startframe2=0;
$maxframe2=150;

# goto phase2;

# $abortframe=22;

sub PrintBlob {
    printf OUT "blob {\n    threshold $thresh\n\n";
    
    foreach $s (keys %B) {
        printf OUT "    sphere { <$B{$s}{'x'}, $B{$s}{'y'}, $B{$s}{'z'}>, $B{$s}{'r'}, $B{$s}{'s'}\n";
        printf OUT "       pigment { color $B{$s}{'c'} }\n";
        printf OUT "       finish { ambient .3 diffuse .7 }\n";
        printf OUT "       translate <$B{$s}{'xw'}, $B{$s}{'yw'}, $B{$s}{'zw'}>\n";
        printf OUT "       scale <$B{$s}{'sx'}+$B{$s}{'sxw'}, $B{$s}{'sy'}+$B{$s}{'syw'}, $B{$s}{'sz'}+$B{$s}{'szw'}>\n";
        printf OUT "    }\n";
    }

#     printf OUT "    pigment { color Sienna }\n";
#     printf OUT "    finish { ambient .3 diffuse .7 phong 1 phong_size 90 }\n";
    printf OUT "}\n";
}

$lkx = 0;
$lky = 1;
$lkz = 0;

$ocx = .1;
$ocy = 1.1;
$ocz = -.1;

$ncx = 1.1;
$ncy = 2.1;
$ncz = -1.1;

$oth = .99;

# Phase 0, zoom out slowly staying on center ball

for ($frame=$startframe0; $frame <=$maxframe0; $frame++) {
    $realframe++;
    $out=sprintf "povs\\%003d.pov",$realframe;
    open (OUT, ">".$out) || die "Cant open $out\n";
    print OUT $HEADER;

    $per = $frame/$maxframe1;

    $cx = $ocx*(1-$per) + $ncx*$per;
    $cy = $ocy*(1-$per) + $ncy*$per;
    $cz = $ocz*(1-$per) + $ncz*$per;

    printf OUT "camera {\n";
    printf OUT "   location <$cx, $cy, $cz>\n";
    printf OUT "   up       <0, 1, 0>\n";
    printf OUT "   look_at  <$lkx, $lky, $lkz>\n";
    printf OUT "}\n\n";

    $ctheta = atan2 ($cy-$lky, $cx-$lkx);
    $r = sqrt( (($cx-$lkx)*($cx-$lkx)) + (($cy-$lky)*($cy-$lky)) );
    $lsx = (5 + $r) * cos ($ctheta);
    $lsy = (5 + $r) * sin ($ctheta);
    # Now solve for lsz
    $ctheta = atan2 ($cz-$lkz, $cx-$lkx);
    $r = sqrt( (($cx-$lkx)*($cx-$lkx)) + (($cz-$lkz)*($cz-$lkz)) );
    $lsz = (5 + $r) * sin ($ctheta);

    printf OUT "light_source { < $lsx , $lsy , $lsz > color White }\n\n";

    $thresh=$oth;
    $B{$mid}{'s'} = $startframe2/$maxframe2;
    
    &PrintBlob;

    close OUT;

    $tga=sprintf "targas\\%003d.tga",$realframe;
    $string="povray $POVOPT -I${out} +O${tga}";
    printf "$string\n";
    system ($string);
    last if ($realframe == $abortframe);
}

exit 0 if ($realframe == $abortframe);

phase1:

$ocx = $cx;
$ocy = $cy;
$ocz = $cz;

$ncx = 4;
$ncy = 4;
$ncz = -4;

# Phase 1, zoom out all the way re-center on cube center

for ($frame=$startframe1; $frame <=$maxframe1; $frame++) {
    $realframe++;
    $out=sprintf "povs\\%003d.pov",$realframe;
    open (OUT, ">".$out) || die "Cant open $out\n";
    print OUT $HEADER;

    $per = $frame/$maxframe1;

    $cx = $ocx*(1-$per) + $ncx*$per;
    $cy = $ocy*(1-$per) + $ncy*$per;
    $cz = $ocz*(1-$per) + $ncz*$per;

    $lky = 1 - ($frame/$maxframe1);

    printf OUT "camera {\n";
    printf OUT "   location <$cx, $cy, $cz>\n";
    printf OUT "   up       <0, 1, 0>\n";
    printf OUT "   look_at  <$lkx, $lky, $lkz>\n";
    printf OUT "}\n\n";

    $ctheta = atan2 ($cy-$lky, $cx-$lkx);
    $r = sqrt( (($cx-$lkx)*($cx-$lkx)) + (($cy-$lky)*($cy-$lky)) );
    $lsx = (5 + $r) * cos ($ctheta);
    $lsy = (5 + $r) * sin ($ctheta);
    # Now solve for lsz
    $ctheta = atan2 ($cz-$lkz, $cx-$lkx);
    $r = sqrt( (($cx-$lkx)*($cx-$lkx)) + (($cz-$lkz)*($cz-$lkz)) );
    $lsz = (5 + $r) * sin ($ctheta);

    printf OUT "light_source { < $lsx , $lsy , $lsz > color White }\n\n";

    $thresh=$oth;

    $B{$mid}{'s'} = $startframe2/$maxframe2;
    
    &PrintBlob;

    close OUT;

    $tga=sprintf "targas\\%003d.tga",$realframe;
    $string="povray $POVOPT -I${out} +O${tga}";
    printf "$string\n";
    system ($string);
    last if ($realframe == $abortframe);
}

exit 0 if ($realframe == $abortframe);

# value=current variance
# max=maximum allowed variance
# minc=max increment of change
# returns new variance
sub Vary {
    my ($vary, $max, $minc) = @_;
    my ($nvary, $count);
    
    return 0 if ($max == 0 || $minc == 0);
    $nvary = $vary + (rand() - .5)*2*$minc;
    # Make sure our new value is within range
    while ($nvary > $max || $nvary < -$max) {
        $count++;
        if ($count%50 == 0) {
            # Rand is failing us, interpolate
            $nvary = $max;
        } else {
            $nvary = $vary + (rand() - .5)*2*$minc;
        }
    }

    return $nvary;
}

$Wigtmax = .3;
$Wigsmax = .3;

sub Wiggle {
    my($myper, $mymax) = @_;
    my($tmax) = $Wigtmax*(sin($pi*$per));
    my($smax) = $Wigsmax*(sin($pi*$per));
    
    foreach $s (keys %B) {
        next if ($s == $mid); # Leave the middle sphere alone
        $B{$s}{'xw'} = &Vary($B{$s}{'xw'}, $tmax, $tmax/10);
        $B{$s}{'yw'} = &Vary($B{$s}{'yw'}, $tmax, $tmax/10);
        $B{$s}{'zw'} = &Vary($B{$s}{'zw'}, $tmax, $tmax/10);

        $B{$s}{'sxw'} = &Vary($B{$s}{'sxw'}, $smax, $smax/10);
        $B{$s}{'syw'} = &Vary($B{$s}{'syw'}, $smax, $smax/10);
        $B{$s}{'szw'} = &Vary($B{$s}{'szw'}, $smax, $smax/10);
    }

}

phase2:

$pi = 3.14159;
$dx = 4;
$dy = 4;
$r = sqrt($dx*$dx+$dy*$dy);
$nth = 0.0462000095333333;

# Phase 2, growth + wiggle

for ($frame=$startframe2; $frame <=$maxframe2; $frame++) {
    $realframe++;
    $out=sprintf "povs\\%003d.pov", $realframe;
    open (OUT, ">".$out) || die "Cant open $out\n";
    print OUT $HEADER;

    $per = $frame/$maxframe2;

    $theta = (2*$pi*$per)+$pi/4;
    printf OUT "#declare Theta=$theta\n";
    $cx = $r*sin($theta);
    $cy = $r*cos($theta);

    printf OUT "camera {\n";
    printf OUT "   location <$cx, $cy, $cz>\n";
    printf OUT "   up       <0, 1, 0>\n";
    printf OUT "   look_at  <$lkx, $lky, $lkz>\n";
    printf OUT "}\n";
    
    $ctheta = atan2 ($cy-$lky, $cx-$lkx);
    printf OUT "#declare Camera_Theta=$ctheta\n";
    $r = sqrt( (($cx-$lkx)*($cx-$lkx)) + (($cy-$lky)*($cy-$lky)) );
    $lsx = (5 + $r) * cos ($ctheta);
    $lsy = (5 + $r) * sin ($ctheta);

    printf OUT "light_source { < $lsx , $lsy , $lsz > color White }\n\n";

    $thresh=(1-$per)*$oth+$per*$nth;
    $B{$mid}{'s'} = $per;

    &Wiggle($per, $maxframe2);
    &PrintBlob;
    close OUT;

    $tga=sprintf "targas\\%003d.tga", $realframe;
    $string="povray $POVOPT -I${out} +O${tga}";
    printf "$string\n";
    system ($string);

    last if ($realframe == $abortframe);
}

create:

$gen=1;
$bname="metab";
$ofile="${bname}${gen}.flc";
while (-f $ofile) {
    $gen++;
    $ofile="${bname}${gen}.flc";
}


system ("c:\\bin\\date");
system ("dta /O${ofile} targas\\*.tga /ra");
system ("c:\\bin\\date");
# system ("vfd ${ofile} -A1");
# system ("c:\\bin\\date");
# system ("avi2mpg1 -n ${bname}${gen}.avi");
# system ("c:\\bin\\date");

exit 0;

