//Final_Clock = 8
//100 frames

#include "colors.inc"

sky_sphere {
pigment {
gradient y
color_map {
[0 color rgb <0.8, 0.8, 1>]
[1 color rgb <0.2, 0.4, 1>]
}
}

}

plane {y, 1000
pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.95, 0.95, 0.95>
                   color rgb <0.9, 0.9, 0.9>]
          [0.1 0.5 color rgb <0.85, 0.85, 0.85>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale 10000*<0.2, 0.5, 0.2>
      translate <6200, 155, 1550>
      translate <400*clock, 10*clock, 100*clock>
    }
    //rotate -135*x
    finish {ambient 1}
    hollow
 }

height_field {
tga "ground.tga"
scale <1000, 100, 1000>
translate <-500, -150, -500>
smooth
pigment {
spotted
turbulence .05
color_map {
[0 color LightWood]
[1 color rgb <0.5, 0.76, 0.45>]
}
scale 30
}
finish {ambient .3 diffuse 1.2 phong .3 phong_size 30}
normal {crackle .7}
hollow
}

plane {y, -2500
pigment {color <0.7, 1, .9>}
finish {ambient .4 phong 1 phong_size 11}
normal {bumps 1 scale 400 }
no_shadow
hollow
}



fog {
    distance 100
    colour rgbt<0.95, 1, 1, .2>
    fog_type 2
    fog_offset 20
    fog_alt .5
    turbulence 0.2
    turb_depth 0.2
    }





#include "leaf4a.inc"

object {plant scale .25 rotate 90*y translate <2, -5, 9>
pigment {color rgbf <0.5, 0.7, 0.4, .1>}
finish {ambient .2 phong .5 phong_size 11 diffuse .8}
}

object {plant scale .25 rotate -45*y translate <-30-(2*clock), -5, -25>
pigment {color rgbt <0.5, 0.7, 0.4, .1>}
finish {ambient .2 phong .5 phong_size 11 diffuse .8}
}

object {plant scale .25 translate <-40, -5, 55>
pigment {color rgbf <0.5, 0.7, 0.4, .1>}
finish {ambient .2 phong .5 phong_size 11 diffuse .8}
}

object {plant scale .25 rotate 180*y translate <55, -5, -30>
pigment {color rgbf <0.5, 0.7, 0.4, .1>}
finish {ambient .2 phong .5 phong_size 11 diffuse .8}
}


camera { //location <0, 20, 0> look_at 0 }
//#if (clock < 7)
location <-20-(2*clock), -5, 0> look_at <0, -5, -1*clock>
//#else
//location <-30, -5, 0> look_at <0, -5, -7>
//#end
}

light_source {<30, 70, 20> color 0.2*White}

light_source { <20, 20, -40> color 0.9*White
	//spotlight
	//radius 20
	//falloff 40
	//tightness 6
	//area_light <2, 0, 0>, <0, 2, 0>, 3, 3

	//point_at 0}
    }

/*light_source { <20, 20, -40> color 1*White
	spotlight
	radius 20
	falloff 40
	tightness 6
	area_light <2, 0, 0>, <0, 2, 0>, 3, 3

	point_at 0}
*/

blob {
threshold 0.05
sphere {<0, 0, 0>, .5, 1 scale <1, .75, 1> translate 6.5*y }
sphere {<0, 0, 0>, 1, 1 scale <1, .8, 1> translate 6*y }
sphere {<0, 0, 0>, 2, 1 scale <1, .8, 1> translate 5.5*y }
sphere {<0, 0, 0>, 2.2, 1 scale <1, .8, 1> translate 5.15*y }
sphere {<0, 0, 0>, 2.4, 1 scale <1, .8, 1> translate 4.75*y }
sphere {<0, 0, 0>, 2.8, 1 scale <1, .8, 1> translate 4.25*y }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 3.75*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 3.25*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .88, 1> translate 2.8*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 2.5*y  }
sphere {<0, 0, 0>, 2.75, 1 scale <1, .8, 1> translate <.25, 2, 0> }
sphere {<0, 0, 0>, 2.7, 1 scale <1, .8, 1> translate <.4, 1.5, 0> }
sphere {<0, 0, 0>, 2.6, 1 scale <1, .8, 1> translate <.5, 1, 0> }
sphere {<0, 0, 0>, 2.55, 1 scale <1, .8, 1> translate <.55, .5, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.6, 0, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.55, -0.5, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.5, -1, 0> }
sphere {<0, 0, 0>, 2.55, 1 scale <1, .8, 1> translate <.45, -1.4, 0> }
sphere {<0, 0, 0>, 2.6, 1 scale <1, .8, 1> translate <.4, -1.75, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.33, -2.1, 0>}
sphere {<0, 0, 0>, 2.4, 1 scale <1, .8, 1> translate <.25, -2.4, 0> }
sphere {<0, 0, 0>, 2.3, 1 scale <1, .8, 1> translate <.25, -2.85, 0> }
sphere {<0, 0, 0>, 2.2, 1 scale <1, .8, 1> translate <.25, -3, 0> }
sphere {<0, 0, 0>, 2, 1 scale <1, .7, 1> translate <.25, -3.5, 0> }
sphere {<0, 0, 0>, 1.75, 1 scale <1, .6, 1> translate <.3, -3.75, 0> }
sphere {<0, 0, 0>, 1.5, 1 scale <1, .68, 1> translate <.35, -4, 0> }
sphere {<0, 0, 0>, 1.25, 1 scale <1, .6, 1> translate <.2, -4.25, 0> }
sphere {<0, 0, 0>, 1, 1 scale <1, .4, 1> translate <.15, -4.5, 0> }
sphere {<0, 0, 0>, .9, 1 scale <1, .3, 1> translate <.1, -4.8, 0> }

//attempt to make fancy

sphere {<0, 3, -2.6>, .27, 1.5 }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 10*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 20*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 30*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 40*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 50*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 60*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate -10*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 70*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 80*y }

sphere {<0, 3.5, -2.6>, .20, 1.5 }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 2*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 4*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 6*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 8*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 10*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 12*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 14*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 16*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 18*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 20*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 22*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 24*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 26*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 28*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 30*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 32*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 34*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 36*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 38*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 40*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 42*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 44*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 46*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 48*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 50*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 52*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 54*y }

sphere {<0, -2.3, -2.2>, .25, 1.5 translate .25*x }
sphere {<0, -1, -2.2>, .23, 1.5 rotate 45*y translate .5*x }
sphere {<0, -1.7, -2.3>, .21 1.5 rotate 27*y translate .5*x }
texture {
pigment {color rgbt <1, 1, 1, 1>}
finish {phong .6 phong_size 30}
}
hollow

}



/***********************************************************************/

//wrinkled to extended wings

#if (clock < 1 )

#declare butterfly = union {
blob {
threshold .1
sphere {<0, 6, 0>, .5, 1}
sphere {<0, 5, 0>, .8, 1 }
sphere {<0, 4.5, 0>, 1, 1}
sphere {<0, 4, 0>, .8, 1}
sphere {<0, 3.5, 0>, .6, 1}
sphere {<0, 3, 0>, .5, 1}
sphere {<0, 2.5, 0>, .6, 1}
sphere {<0, 2, 0>, .7, 1}
sphere {<0, 1.5, 0>, .8, 1}
sphere {<0, 1, 0>, .8, 1 }
sphere {<0, .5, 0>, .7, 1}
sphere {<0, 0, 0>, .6, 1}
sphere {<0, -.5, 0>, .5, 1}
sphere {<0, -1, 0>, .4, 1}
sphere {<0, -1.125, 0>, .3, 1}
sphere {<0, -1.25, 0>, .2, 1}
sphere {<0, -1.275, 0>, .1, 1}
pigment {
image_map {
tga "body.tga"
map_type 2
}
scale <.2, 8, .2>
rotate -80*y
translate -2*y
}
/*spotted

color_map {
[0 color White]
[0.2 color White]
[0.3 color 0.01*White]
[1 color 0.01*White]
}
scale .4
}
*/
finish {ambient 1}
}

prism {
cubic_spline
-.1
.1
11

<-3, 4>, <0, 6>, <9.5, 3>, <9, 0>, <6, 0>, <4, -1>,
<2, -1>, <0, 3>, <-.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate 5*z*clock
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .2 phong .8 phong_size 30 metallic}
normal {wrinkles 1-(.2*clock) scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate 60*y*clock
scale <.2+(.1*clock), 1, 1>
}

prism {
cubic_spline
-.1
.1
11
<3, 4>, <0, 6>, <-9.5, 3>, <-9, 0>, <-6, 0>, <-4, -1>,
<-2, -1>, <0, 3>, <.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate -5*clock*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .2 phong .8 phong_size 30 metallic}
normal {wrinkles 1-(.2*clock) scale <0.02, .2, .2> turbulence 0.05}
}

texture {
pigment { color rgbt <1, 1, 1, 1>}
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate -60*y*clock
scale <.2+(.1*clock), 1, 1>

}

prism {
cubic_spline
-.11
.09
9
<-2, 4>, <0, 3>, <4, 0>, <3, -2>, <1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .2 metallic}
rotate 55*y*clock
scale <.2+(.1*clock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<2, 4>, <0, 3>, <-4, 0>, <-3, -2>, <-1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>

rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .2 metallic}
rotate -55*y*clock
scale <.2+(.1*clock), 1, 1>
}

}

#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*x rotate -make*z}

#declare make = make + .4
#end
translate <5, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*x rotate make*z}

#declare make = make + .4
#end
translate <-5, 5.5, 0>
pigment {color 0.3*White}
}

union {
object {antenae1}

object {antenae2}

object {butterfly }
scale 1.4 rotate 90*y translate -11.9*y translate -5*x translate (-1*clock)*z }

#end


//***************************************************************************************************************

//wrinkled to extended wings

#if (clock > 1 & clock <= 2 )
#declare nclock = clock - 1

#declare butterfly = union {
blob {
threshold .1
sphere {<0, 6, 0>, .5, 1}
sphere {<0, 5, 0>, .8, 1 }
sphere {<0, 4.5, 0>, 1, 1}
sphere {<0, 4, 0>, .8, 1}
sphere {<0, 3.5, 0>, .6, 1}
sphere {<0, 3, 0>, .5, 1}
sphere {<0, 2.5, 0>, .6, 1}
sphere {<0, 2, 0>, .7, 1}
sphere {<0, 1.5, 0>, .8, 1}
sphere {<0, 1, 0>, .8, 1 }
sphere {<0, .5, 0>, .7, 1}
sphere {<0, 0, 0>, .6, 1}
sphere {<0, -.5, 0>, .5, 1}
sphere {<0, -1, 0>, .4, 1}
sphere {<0, -1.125, 0>, .3, 1}
sphere {<0, -1.25, 0>, .2, 1}
sphere {<0, -1.275, 0>, .1, 1}
pigment {
image_map {
tga "body.tga"
map_type 2
}
scale <.2, 8, .2>
rotate -80*y
translate -2*y
}
/*spotted

color_map {
[0 color White]
[0.2 color White]
[0.3 color 0.01*White]
[1 color 0.01*White]
}
scale .4
}
*/
finish {ambient 1}
}


prism {
cubic_spline
-.1
.1
11

<-3, 4>, <0, 6>, <9.5, 3>, <9, 0>, <6, 0>, <4, -1>,
<2, -1>, <0, 3>, <-.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate (5+(2*nclock))*z
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .2+(.1*nclock) phong .8 phong_size 30 metallic}
normal {wrinkles 8-(.2*nclock) scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate (60-(60*nclock))*y
scale <.3+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.1
.1
11
<3, 4>, <0, 6>, <-9.5, 3>, <-9, 0>, <-6, 0>, <-4, -1>,
<-2, -1>, <0, 3>, <.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate (-5-(2*nclock))*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .2+(.1*nclock) phong .8 phong_size 30 metallic}
normal {wrinkles .8-(.2*nclock) scale <0.02, .2, .2> turbulence 0.05}
}

texture {
pigment { color rgbt <1, 1, 1, 1>}
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate (-60+(60*nclock))*y
scale <.3+(.1*nclock), 1, 1>

}

prism {
cubic_spline
-.11
.09
9
<-2, 4>, <0, 3>, <4, 0>, <3, -2>, <1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .2+(.1*nclock) metallic}
rotate (55-(55*nclock))*y
scale <.3+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<2, 4>, <0, 3>, <-4, 0>, <-3, -2>, <-1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>

rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .2+(.1*nclock) metallic}
rotate (-55+(55*nclock))*y
scale <.3+(.1*nclock), 1, 1>
}

}

#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*x rotate -make*z}

#declare make = make + .4
#end
translate <5, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*x rotate make*z}

#declare make = make + .4
#end
translate <-5, 5.5, 0>
pigment {color 0.3*White}
}

union {
object {antenae1}

object {antenae2}

object {butterfly   }
scale 1.4 rotate 90*y translate -11.9*y translate -5*x translate (-1-(1*nclock))*z }

#end

/***********************************************************************/

//wrinkled to extended wings

#if (clock > 2 & clock <=3 )
#declare nclock = clock - 2

#declare butterfly = union {
blob {
threshold .1
sphere {<0, 6, 0>, .5, 1}
sphere {<0, 5, 0>, .8, 1 }
sphere {<0, 4.5, 0>, 1, 1}
sphere {<0, 4, 0>, .8, 1}
sphere {<0, 3.5, 0>, .6, 1}
sphere {<0, 3, 0>, .5, 1}
sphere {<0, 2.5, 0>, .6, 1}
sphere {<0, 2, 0>, .7, 1}
sphere {<0, 1.5, 0>, .8, 1}
sphere {<0, 1, 0>, .8, 1 }
sphere {<0, .5, 0>, .7, 1}
sphere {<0, 0, 0>, .6, 1}
sphere {<0, -.5, 0>, .5, 1}
sphere {<0, -1, 0>, .4, 1}
sphere {<0, -1.125, 0>, .3, 1}
sphere {<0, -1.25, 0>, .2, 1}
sphere {<0, -1.275, 0>, .1, 1}
pigment {
image_map {
tga "body.tga"
map_type 2
}
scale <.2, 8, .2>
rotate -80*y
translate -2*y
}
/*spotted

color_map {
[0 color White]
[0.2 color White]
[0.3 color 0.01*White]
[1 color 0.01*White]
}
scale .4
}
*/
finish {ambient 1}
}

prism {
cubic_spline
-.1
.1
11

<-3, 4>, <0, 6>, <9.5, 3>, <9, 0>, <6, 0>, <4, -1>,
<2, -1>, <0, 3>, <-.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate (7+(2*nclock))*z
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .3+(.1*nclock) phong .8 phong_size 30 metallic}
normal {wrinkles .6-(.2*nclock) scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate (60*nclock)*y
scale <.4+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.1
.1
11
<3, 4>, <0, 6>, <-9.5, 3>, <-9, 0>, <-6, 0>, <-4, -1>,
<-2, -1>, <0, 3>, <.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate (-7-(2*nclock))*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .3+(.1*nclock) phong .8 phong_size 30 metallic}
normal {wrinkles .6-(.2*nclock) scale <0.02, .2, .2> turbulence 0.05}
}

texture {
pigment { color rgbt <1, 1, 1, 1>}
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate (-60*nclock)*y
scale <.4+(.1*nclock), 1, 1>

}

prism {
cubic_spline
-.11
.09
9
<-2, 4>, <0, 3>, <4, 0>, <3, -2>, <1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .3+(.1*nclock) metallic}
rotate (55*nclock)*y
scale <.4+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<2, 4>, <0, 3>, <-4, 0>, <-3, -2>, <-1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>

rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .3+(.1*nclock) metallic}
rotate (-55*nclock)*y
scale <.4+(.1*nclock), 1, 1>
}

}

#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*x rotate -make*z}

#declare make = make + .4
#end
translate <5, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*x rotate make*z}

#declare make = make + .4
#end
translate <-5, 5.5, 0>
pigment {color 0.3*White}
}

union {
object {antenae1}

object {antenae2}

object {butterfly    }
scale 1.4 rotate 90*y translate -11.9*y translate -5*x translate (-2-(1*nclock))*z }

#end


//***************************************************************************************************************

//wrinkled to extended wings

#if (clock > 3 & clock <= 4 )
#declare nclock = clock - 3

#declare butterfly = union {
blob {
threshold .1
sphere {<0, 6, 0>, .5, 1}
sphere {<0, 5, 0>, .8, 1 }
sphere {<0, 4.5, 0>, 1, 1}
sphere {<0, 4, 0>, .8, 1}
sphere {<0, 3.5, 0>, .6, 1}
sphere {<0, 3, 0>, .5, 1}
sphere {<0, 2.5, 0>, .6, 1}
sphere {<0, 2, 0>, .7, 1}
sphere {<0, 1.5, 0>, .8, 1}
sphere {<0, 1, 0>, .8, 1 }
sphere {<0, .5, 0>, .7, 1}
sphere {<0, 0, 0>, .6, 1}
sphere {<0, -.5, 0>, .5, 1}
sphere {<0, -1, 0>, .4, 1}
sphere {<0, -1.125, 0>, .3, 1}
sphere {<0, -1.25, 0>, .2, 1}
sphere {<0, -1.275, 0>, .1, 1}
pigment {
image_map {
tga "body.tga"
map_type 2
}
scale <.2, 8, .2>
rotate -80*y
translate -2*y
}
/*spotted

color_map {
[0 color White]
[0.2 color White]
[0.3 color 0.01*White]
[1 color 0.01*White]
}
scale .4
}
*/
finish {ambient 1}
}


prism {
cubic_spline
-.1
.1
11

<-3, 4>, <0, 6>, <9.5, 3>, <9, 0>, <6, 0>, <4, -1>,
<2, -1>, <0, 3>, <-.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate (9+(2*nclock))*z
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .4+(.1*nclock) phong .8 phong_size 30 metallic}
normal {wrinkles .4-(.2*nclock) scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate (60-(60*nclock))*y
scale <.5+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.1
.1
11
<3, 4>, <0, 6>, <-9.5, 3>, <-9, 0>, <-6, 0>, <-4, -1>,
<-2, -1>, <0, 3>, <.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate (-9-(2*nclock))*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .4+(.1*nclock) phong .8 phong_size 30 metallic}
normal {wrinkles .4-(.2*nclock) scale <0.02, .2, .2> turbulence 0.05}
}

texture {
pigment { color rgbt <1, 1, 1, 1>}
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate (-60+(60*nclock))*y
scale <.5+(.1*nclock), 1, 1>

}

prism {
cubic_spline
-.11
.09
9
<-2, 4>, <0, 3>, <4, 0>, <3, -2>, <1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .4+(.1*nclock) metallic}
rotate (55-(55*nclock))*y
scale <.5+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<2, 4>, <0, 3>, <-4, 0>, <-3, -2>, <-1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>

rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .4+(.1*nclock) metallic}
rotate (-55+(55*nclock))*y
scale <.5+(.1*nclock), 1, 1>
}

}

#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*x rotate -make*z}

#declare make = make + .4
#end
translate <5, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*x rotate make*z}

#declare make = make + .4
#end
translate <-5, 5.5, 0>
pigment {color 0.3*White}
}

union {
object {antenae1}

object {antenae2}

object {butterfly }
scale 1.4 rotate 90*y translate -11.9*y translate -5*x translate (-3-(1*nclock))*z }

#end

//************************************************************************************************************
//************************************************************************************************************

#if (clock > 4 & clock <= 5 )

#declare nclock = clock - 4

#declare butterfly = union {
blob {
threshold .1
sphere {<0, 6, 0>, .5, 1}
sphere {<0, 5, 0>, .8, 1 }
sphere {<0, 4.5, 0>, 1, 1}
sphere {<0, 4, 0>, .8, 1}
sphere {<0, 3.5, 0>, .6, 1}
sphere {<0, 3, 0>, .5, 1}
sphere {<0, 2.5, 0>, .6, 1}
sphere {<0, 2, 0>, .7, 1}
sphere {<0, 1.5, 0>, .8, 1}
sphere {<0, 1, 0>, .8, 1 }
sphere {<0, .5, 0>, .7, 1}
sphere {<0, 0, 0>, .6, 1}
sphere {<0, -.5, 0>, .5, 1}
sphere {<0, -1, 0>, .4, 1}
sphere {<0, -1.125, 0>, .3, 1}
sphere {<0, -1.25, 0>, .2, 1}
sphere {<0, -1.275, 0>, .1, 1}
pigment {
image_map {
tga "body.tga"
map_type 2
}
scale <.2, 8, .2>
rotate -80*y
translate -2*y
}
/*spotted

color_map {
[0 color White]
[0.2 color White]
[0.3 color 0.01*White]
[1 color 0.01*White]
}
scale .4
}
*/
finish {ambient 1}
}

prism {
cubic_spline
-.1
.1
11

<-3, 4>, <0, 6>, <9.5, 3>, <9, 0>, <6, 0>, <4, -1>,
<2, -1>, <0, 3>, <-.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate (11+(2*nclock))*z
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .5+(.1*nclock) phong .8 phong_size 30 metallic}
normal {wrinkles .2-(.2*nclock) scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate 60*y*nclock
scale <.6+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.1
.1
11
<3, 4>, <0, 6>, <-9.5, 3>, <-9, 0>, <-6, 0>, <-4, -1>,
<-2, -1>, <0, 3>, <.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate (-11-(2*nclock))*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .5+(.1*nclock) phong .8 phong_size 30 metallic}
normal {wrinkles .2-(.2*nclock) scale <0.02, .2, .2> turbulence 0.05}
}

texture {
pigment { color rgbt <1, 1, 1, 1>}
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate -60*y*nclock
scale <.6+(.1*nclock), 1, 1>

}

prism {
cubic_spline
-.11
.09
9
<-2, 4>, <0, 3>, <4, 0>, <3, -2>, <1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .5+(.1*nclock) metallic}
rotate 55*nclock*y
scale <.6+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<2, 4>, <0, 3>, <-4, 0>, <-3, -2>, <-1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>

rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .5+(.1*nclock) metallic}
rotate -55*nclock*y
scale <.6+(.1*nclock), 1, 1>
}

}

#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*x rotate -make*z}

#declare make = make + .4
#end
translate <5, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*x rotate make*z}

#declare make = make + .4
#end
translate <-5, 5.5, 0>
pigment {color 0.3*White}
}

union {
object {antenae1}

object {antenae2}

object {butterfly }
scale 1.4 rotate 90*y translate -11.9*y translate -5*x translate (-4-(1*nclock))*z }

#end


//***************************************************************************************************************

//wrinkled to extended wings

#if (clock > 5 & clock <= 6 )
#declare nclock = clock - 5

#declare butterfly = union {
blob {
threshold .1
sphere {<0, 6, 0>, .5, 1}
sphere {<0, 5, 0>, .8, 1 }
sphere {<0, 4.5, 0>, 1, 1}
sphere {<0, 4, 0>, .8, 1}
sphere {<0, 3.5, 0>, .6, 1}
sphere {<0, 3, 0>, .5, 1}
sphere {<0, 2.5, 0>, .6, 1}
sphere {<0, 2, 0>, .7, 1}
sphere {<0, 1.5, 0>, .8, 1}
sphere {<0, 1, 0>, .8, 1 }
sphere {<0, .5, 0>, .7, 1}
sphere {<0, 0, 0>, .6, 1}
sphere {<0, -.5, 0>, .5, 1}
sphere {<0, -1, 0>, .4, 1}
sphere {<0, -1.125, 0>, .3, 1}
sphere {<0, -1.25, 0>, .2, 1}
sphere {<0, -1.275, 0>, .1, 1}
pigment {
image_map {
tga "body.tga"
map_type 2
}
scale <.2, 8, .2>
rotate -80*y
translate -2*y
}
/*spotted

color_map {
[0 color White]
[0.2 color White]
[0.3 color 0.01*White]
[1 color 0.01*White]
}
scale .4
}
*/
finish {ambient 1}
}


prism {
cubic_spline
-.1
.1
11

<-3, 4>, <0, 6>, <9.5, 3>, <9, 0>, <6, 0>, <4, -1>,
<2, -1>, <0, 3>, <-.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate (13+(2*nclock))*z
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .6 phong .8 phong_size 30 metallic}
normal {wrinkles 0 scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate (60-(60*nclock))*y
scale <.7+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.1
.1
11
<3, 4>, <0, 6>, <-9.5, 3>, <-9, 0>, <-6, 0>, <-4, -1>,
<-2, -1>, <0, 3>, <.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate (-13-(2*nclock))*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .6 phong .8 phong_size 30 metallic}
normal {wrinkles 0 scale <0.02, .2, .2> turbulence 0.05}
}

texture {
pigment { color rgbt <1, 1, 1, 1>}
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate (-60+(60*nclock))*y
scale <.7+(.1*nclock), 1, 1>

}

prism {
cubic_spline
-.11
.09
9
<-2, 4>, <0, 3>, <4, 0>, <3, -2>, <1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .6 metallic}
rotate (55-(55*nclock))*y
scale <.7+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<2, 4>, <0, 3>, <-4, 0>, <-3, -2>, <-1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>

rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .6 metallic}
rotate (-55+(55*nclock))*y
scale <.7+(.1*nclock), 1, 1>
}

}

#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*x rotate -make*z}

#declare make = make + .4
#end
translate <5, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*x rotate make*z}

#declare make = make + .4
#end
translate <-5, 5.5, 0>
pigment {color 0.3*White}
}

union {
object {antenae1}

object {antenae2}

object {butterfly }
scale 1.4 rotate 90*y translate -11.9*y translate -5*x translate (-5-(1*nclock))*z }

#end

//******************************************************************************************************

#if (clock > 6 & clock <= 7 )

#declare nclock = clock - 6

#declare butterfly = union {
blob {
threshold .1
sphere {<0, 6, 0>, .5, 1}
sphere {<0, 5, 0>, .8, 1 }
sphere {<0, 4.5, 0>, 1, 1}
sphere {<0, 4, 0>, .8, 1}
sphere {<0, 3.5, 0>, .6, 1}
sphere {<0, 3, 0>, .5, 1}
sphere {<0, 2.5, 0>, .6, 1}
sphere {<0, 2, 0>, .7, 1}
sphere {<0, 1.5, 0>, .8, 1}
sphere {<0, 1, 0>, .8, 1 }
sphere {<0, .5, 0>, .7, 1}
sphere {<0, 0, 0>, .6, 1}
sphere {<0, -.5, 0>, .5, 1}
sphere {<0, -1, 0>, .4, 1}
sphere {<0, -1.125, 0>, .3, 1}
sphere {<0, -1.25, 0>, .2, 1}
sphere {<0, -1.275, 0>, .1, 1}
pigment {
image_map {
tga "body.tga"
map_type 2
}
scale <.2, 8, .2>
rotate -80*y
translate -2*y
}
/*spotted

color_map {
[0 color White]
[0.2 color White]
[0.3 color 0.01*White]
[1 color 0.01*White]
}
scale .4
}
*/
finish {ambient 1}
}

prism {
cubic_spline
-.1
.1
11

<-3, 4>, <0, 6>, <9.5, 3>, <9, 0>, <6, 0>, <4, -1>,
<2, -1>, <0, 3>, <-.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .6 phong .8 phong_size 30 metallic}
normal {wrinkles 0 scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate 60*nclock*y
scale <.8+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.1
.1
11
<3, 4>, <0, 6>, <-9.5, 3>, <-9, 0>, <-6, 0>, <-4, -1>,
<-2, -1>, <0, 3>, <.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .6 phong .8 phong_size 30 metallic}
normal {wrinkles 0 scale <0.02, .2, .2> turbulence 0.05}
}

texture {
pigment { color rgbt <1, 1, 1, 1>}
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate -60*nclock*y
scale <.8+(.1*nclock), 1, 1>

}

prism {
cubic_spline
-.11
.09
9
<-2, 4>, <0, 3>, <4, 0>, <3, -2>, <1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .6 metallic}
rotate 55*nclock*y
scale <.8+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<2, 4>, <0, 3>, <-4, 0>, <-3, -2>, <-1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>

rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .6 metallic}
rotate -55*nclock*y
scale <.8+(.1*nclock), 1, 1>
}

}

#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*x rotate -make*z}

#declare make = make + .4
#end
translate <5, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*x rotate make*z}

#declare make = make + .4
#end
translate <-5, 5.5, 0>
pigment {color 0.3*White}
}

union {
object {antenae1}

object {antenae2}

object {butterfly }
scale 1.4 rotate 90*y translate -11.9*y translate -5*x translate (-6-(1*nclock))*z }

#end


//***************************************************************************************************************

//wrinkled to extended wings

#if (clock > 7 & clock <= 8 )
#declare nclock = clock - 7

#declare butterfly = union {
blob {
threshold .1
sphere {<0, 6, 0>, .5, 1}
sphere {<0, 5, 0>, .8, 1 }
sphere {<0, 4.5, 0>, 1, 1}
sphere {<0, 4, 0>, .8, 1}
sphere {<0, 3.5, 0>, .6, 1}
sphere {<0, 3, 0>, .5, 1}
sphere {<0, 2.5, 0>, .6, 1}
sphere {<0, 2, 0>, .7, 1}
sphere {<0, 1.5, 0>, .8, 1}
sphere {<0, 1, 0>, .8, 1 }
sphere {<0, .5, 0>, .7, 1}
sphere {<0, 0, 0>, .6, 1}
sphere {<0, -.5, 0>, .5, 1}
sphere {<0, -1, 0>, .4, 1}
sphere {<0, -1.125, 0>, .3, 1}
sphere {<0, -1.25, 0>, .2, 1}
sphere {<0, -1.275, 0>, .1, 1}
pigment {
image_map {
tga "body.tga"
map_type 2
}
scale <.2, 8, .2>
rotate -80*y
translate -2*y
}
/*spotted

color_map {
[0 color White]
[0.2 color White]
[0.3 color 0.01*White]
[1 color 0.01*White]
}
scale .4
}
*/
finish {ambient 1}
}


prism {
cubic_spline
-.1
.1
11

<-3, 4>, <0, 6>, <9.5, 3>, <9, 0>, <6, 0>, <4, -1>,
<2, -1>, <0, 3>, <-.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .6 phong .8 phong_size 30 metallic}
normal {wrinkles 0 scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate (60-(60*nclock))*y
scale <.9+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.1
.1
11
<3, 4>, <0, 6>, <-9.5, 3>, <-9, 0>, <-6, 0>, <-4, -1>,
<-2, -1>, <0, 3>, <.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .6 phong .8 phong_size 30 metallic}
normal {wrinkles 0 scale <0.02, .2, .2> turbulence 0.05}
}

texture {
pigment { color rgbt <1, 1, 1, 1>}
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}

rotate (-60+(60*nclock))*y
scale <.9+(.1*nclock), 1, 1>

}

prism {
cubic_spline
-.11
.09
9
<-2, 4>, <0, 3>, <4, 0>, <3, -2>, <1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .6 metallic}
rotate (55-(55*nclock))*y
scale <.9+(.1*nclock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<2, 4>, <0, 3>, <-4, 0>, <-3, -2>, <-1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>

rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
pigment {
image_map {
tga "wing1.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .6 metallic}
rotate (-55+(55*nclock))*y
scale <.9+(.1*nclock), 1, 1>
}

}

#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*x rotate -make*z}

#declare make = make + .4
#end
translate <5, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*x rotate make*z}

#declare make = make + .4
#end
translate <-5, 5.5, 0>
pigment {color 0.3*White}
}

union {
object {antenae1}

object {antenae2}

object {butterfly }
scale 1.4 rotate 90*y translate -11.9*y translate -5*x translate -7*z }

#end
