//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 4 lights, 36 textures and 1566 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/28/1997    (28.12.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  < %camera translate% >
  direction <0.0,     0.0,  0.8823>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   < %lookat translate% >
}

// *******  L I G H T S *******
light_source {   // CameraLight
  < %camera translate% > + 0.1*z
  color rgb < %cameralight color% >
  shadowless
}

light_source {   // Light1
  < %sunlight1 translate% >
  color rgb <0.333, 0.333, 0.333>
}

light_source {   // Light2
  < %sunlight2 translate% >
  color rgb <0.329, 0.329, 0.329>
  atmospheric_attenuation on
}

light_source {   // Light3
  < %sunlight3 translate% >
  color rgb <0.333, 0.333, 0.333>
  atmospheric_attenuation on
}

light_source {   // Light4
  < %sunlight4 translate% >
  color rgb <0.324, 0.324, 0.324>
  atmospheric_attenuation on
}


// ********  TEXTURES  *******
//

#include "snail2.inc"

//  $MRY$: 'txtClouds'
#declare txtClouds = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgbf<1.000, 1.000, 1.000, 1.000> ]
       [ 0.494  color rgbf<1.000, 1.000, 1.000, 1.000> ]
       [ 1.000  color rgbf<1.000, 1.000, 1.000, 0.149> ]
     }
     turbulence 0.500
     octaves 3
     lambda 6.000
     scale     <0.1500, 0.1500, 0.1500>
     translate < %clouds translate% >
   }
   finish {
     diffuse 0.000
     ambient 1.000
   }
}


//  $MRY$: 'txtWater'
#declare txtWater = texture {
   pigment {
     color rgbf<0.000, 0.000, 0.460, 0.799>
   }
   normal {
     ripples 0.3000
     frequency 10.000
     scale     0.3000
     phase %water degrees%
   }
   finish {
     reflection 0.200
     ior 1.330
   }
}



// ********  REFERENCED OBJECTS  *******

#declare FencePost1 = object {
  cylinder { // FencePost1
    <0,0,1>, <0,0,0>, 1
    texture {
      txtFencePost
      scale <1.0, 1.0, 0.4>
    }
    scale <0.2, 0.2, 3.0>
    translate  -0.5*z
  }
}
#declare Fence1 = union { // Fence1
  object { FencePost1 }
  object { // FencePost2->FencePost1
    FencePost1
    translate  -7.5*x
  }
  object { // FencePost3->FencePost1
    FencePost1
    translate  -15.0*x
  }
  object { // FencePost4->FencePost1
    FencePost1
    translate  -22.5*x
  }
  object { // FencePost5->FencePost1
    FencePost1
    translate  -30.0*x
  }
  object { // FencePost6->FencePost1
    FencePost1
    translate  -37.5*x
  }
  object { // FencePost7->FencePost1
    FencePost1
    translate  -45.0*x
  }
  object { // FencePost8->FencePost1
    FencePost1
    translate  -52.5*x
  }
  object { // FencePost9->FencePost1
    FencePost1
    translate  -60.0*x
  }
  object { // FencePost10->FencePost1
    FencePost1
    translate  -67.5*x
  }
  object { // FencePost11->FencePost1
    FencePost1
    translate  -75.0*x
  }
  object { // FencePost12->FencePost1
    FencePost1
    translate  -82.5*x
  }
  object { // FencePost13->FencePost1
    FencePost1
    translate  -90.0*x
  }
  object { // FencePost14->FencePost1
    FencePost1
    translate  -97.5*x
  }
  object { // FencePost15->FencePost1
    FencePost1
    translate  -105.0*x
  }
  object { // FencePost16->FencePost1
    FencePost1
    translate  -112.5*x
  }
  object { // FencePost17->FencePost1
    FencePost1
    translate  -120.0*x
  }
  object { // FencePost18->FencePost1
    FencePost1
    translate  -127.5*x
  }
  object { // FencePost19->FencePost1
    FencePost1
    translate  -135.0*x
  }
  object { // FencePost20->FencePost1
    FencePost1
    translate  -142.5*x
  }
  object { // FencePost21->FencePost1
    FencePost1
    translate  -150.0*x
  }
  object { // FencePost22->FencePost1
    FencePost1
    translate  -157.5*x
  }
  object { // FencePost23->FencePost1
    FencePost1
    translate  -165.0*x
  }
  object { // FencePost24->FencePost1
    FencePost1
    translate  -172.5*x
  }
  object { // FencePost25->FencePost1
    FencePost1
    translate  -180.0*x
  }
  object { // FencePost26->FencePost1
    FencePost1
    translate  -187.5*x
  }
  object { // FencePost27->FencePost1
    FencePost1
    translate  -195.0*x
  }
  object { // FencePost28->FencePost1
    FencePost1
    translate  -202.5*x
  }
  object { // FencePost29->FencePost1
    FencePost1
    translate  -210.0*x
  }
  object { // FencePost30->FencePost1
    FencePost1
    translate  -217.5*x
  }
  object { // FencePost31->FencePost1
    FencePost1
    translate  -225.0*x
  }
  object { // FencePost32->FencePost1
    FencePost1
    translate  -232.5*x
  }
  object { // FencePost33->FencePost1
    FencePost1
    translate  -240.0*x
  }
  object { // FencePost34->FencePost1
    FencePost1
    translate  -247.5*x
  }
  object { // FencePost35->FencePost1
    FencePost1
    translate  -255.0*x
  }
  object { // FencePost36->FencePost1
    FencePost1
    translate  -262.5*x
  }
  object { // FencePost37->FencePost1
    FencePost1
    translate  -270.0*x
  }
  object { // FencePost38->FencePost1
    FencePost1
    translate  -277.5*x
  }
  object { // FencePost39->FencePost1
    FencePost1
    translate  -285.0*x
  }
  object { // FencePost40->FencePost1
    FencePost1
    translate  -292.5*x
  }
  object { // FencePost41->FencePost1
    FencePost1
    translate  -300.0*x
  }
  object { // FencePost42->FencePost1
    FencePost1
    translate  7.5*x
  }
  object { // FencePost43->FencePost1
    FencePost1
    translate  15.0*x
  }
  object { // FencePost44->FencePost1
    FencePost1
    translate  22.5*x
  }
  object { // FencePost45->FencePost1
    FencePost1
    translate  30.0*x
  }
  object { // FencePost46->FencePost1
    FencePost1
    translate  37.5*x
  }
  object { // FencePost47->FencePost1
    FencePost1
    translate  45.0*x
  }
  object { // FencePost48->FencePost1
    FencePost1
    translate  52.5*x
  }
  object { // FencePost49->FencePost1
    FencePost1
    translate  60.0*x
  }
  object { // FencePost50->FencePost1
    FencePost1
    translate  67.5*x
  }
  object { // FencePost51->FencePost1
    FencePost1
    translate  75.0*x
  }
  object { // FencePost52->FencePost1
    FencePost1
    translate  82.5*x
  }
  object { // FencePost53->FencePost1
    FencePost1
    translate  90.0*x
  }
  object { // FencePost54->FencePost1
    FencePost1
    translate  97.5*x
  }
  object { // FencePost55->FencePost1
    FencePost1
    translate  105.0*x
  }
  object { // FencePost56->FencePost1
    FencePost1
    translate  112.5*x
  }
  object { // FencePost57->FencePost1
    FencePost1
    translate  120.0*x
  }
  object { // FencePost58->FencePost1
    FencePost1
    translate  127.5*x
  }
  object { // FencePost59->FencePost1
    FencePost1
    translate  135.0*x
  }
  object { // FencePost60->FencePost1
    FencePost1
    translate  142.5*x
  }
  object { // FencePost61->FencePost1
    FencePost1
    translate  150.0*x
  }
  object { // FencePost62->FencePost1
    FencePost1
    translate  157.5*x
  }
  object { // FencePost63->FencePost1
    FencePost1
    translate  165.0*x
  }
  object { // FencePost64->FencePost1
    FencePost1
    translate  172.5*x
  }
  object { // FencePost65->FencePost1
    FencePost1
    translate  180.0*x
  }
  object { // FencePost66->FencePost1
    FencePost1
    translate  187.5*x
  }
  object { // FencePost67->FencePost1
    FencePost1
    translate  195.0*x
  }
  object { // FencePost68->FencePost1
    FencePost1
    translate  202.5*x
  }
  object { // FencePost69->FencePost1
    FencePost1
    translate  210.0*x
  }
  object { // FencePost70->FencePost1
    FencePost1
    translate  217.5*x
  }
  object { // FencePost71->FencePost1
    FencePost1
    translate  225.0*x
  }
  object { // FencePost72->FencePost1
    FencePost1
    translate  232.5*x
  }
  object { // FencePost73->FencePost1
    FencePost1
    translate  240.0*x
  }
  object { // FencePost74->FencePost1
    FencePost1
    translate  247.5*x
  }
  object { // FencePost75->FencePost1
    FencePost1
    translate  255.0*x
  }
  object { // FencePost76->FencePost1
    FencePost1
    translate  262.5*x
  }
  object { // FencePost77->FencePost1
    FencePost1
    translate  270.0*x
  }
  object { // FencePost78->FencePost1
    FencePost1
    translate  277.5*x
  }
  object { // FencePost79->FencePost1
    FencePost1
    translate  285.0*x
  }
  object { // FencePost80->FencePost1
    FencePost1
    translate  292.5*x
  }
  object { // FencePost81->FencePost1
    FencePost1
    translate  300.0*x
  }
  cylinder { // FenceRail1
    <0,0,1>, <0,0,0>, 1
    texture {
      txtFenceRail
      scale <1.0, 1.0, 0.002>
    }
    scale <0.12, 0.12, 600.0>
    rotate -90.0*y
    translate  <300.0, 0.0, 2.146476>
  }
  cylinder { // FenceRail2
    <0,0,1>, <0,0,0>, 1
    texture {
      txtFenceRail
      scale <1.0, 1.0, 0.002>
    }
    scale <0.12, 0.12, 600.0>
    rotate -90.0*y
    translate  <300.0, 0.0, 0.977755>
  }
  translate  <0.0, -13.842236, -0.051338>
}


#declare San_Franscisco = object {
  height_field {
    tga "C:\1\SNAIL\MAPS\SANFRNHF.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <100.0, 100.0, 1.5>
  translate  -0.735294*z
  texture {
    txtRoadAndGrass
    rotate 90.0*z
  translate <0.000000, -100.000000, 0.000000>
  }
}

#declare LeftPupil = object {
  sphere { // LeftPupil
    <0,0,0>,1
    texture {
      txtPupil
    }
    scale <0.012433, 0.046112, 0.043522>
    scale < %snailpupil scale% >
    translate  <1.552514, 0.12359, 2.563492>
  }
}
#declare ShellHalf1 = union {
  sphere { // sphere0_2
    <0,0,0>,1
    scale 0.8
    translate  10.75*x
  }
  sphere { // sphere1_3
    <0,0,0>,1
    scale 0.8128
    translate  <10.782, -0.00401, 0.0398>
  }
  sphere { // sphere2_4
    <0,0,0>,1
    scale 0.8256
    translate  <10.814, -0.01598, 0.07839>
  }
  sphere { // sphere3_5
    <0,0,0>,1
    scale 0.8384
    translate  <10.846, -0.03564, 0.11458>
  }
  sphere { // sphere4_6
    <0,0,0>,1
    scale 0.8512
    translate  <10.878, -0.06262, 0.14724>
  }
  sphere { // sphere5_7
    <0,0,0>,1
    scale 0.864
    translate  <10.91, -0.09635, 0.17526>
  }
  sphere { // sphere6_8
    <0,0,0>,1
    scale 0.8768
    translate  <10.942, -0.13614, 0.19765>
  }
  sphere { // sphere7_9
    <0,0,0>,1
    scale 0.8896
    translate  <10.974, -0.18118, 0.21348>
  }
  sphere { // sphere8_10
    <0,0,0>,1
    scale 0.9024
    translate  <11.006, -0.2305, 0.22197>
  }
  sphere { // sphere9_11
    <0,0,0>,1
    scale 0.9152
    translate  <11.038, -0.28306, 0.22243>
  }
  sphere { // sphere10_12
    <0,0,0>,1
    scale 0.928
    translate  <11.07, -0.33773, 0.21433>
  }
  sphere { // sphere11_13
    <0,0,0>,1
    scale 0.9408
    translate  <11.102, -0.39329, 0.19729>
  }
  sphere { // sphere12_14
    <0,0,0>,1
    scale 0.9536
    translate  <11.134, -0.44848, 0.17108>
  }
  sphere { // sphere13_15
    <0,0,0>,1
    scale 0.9664
    translate  <11.16599, -0.502, 0.13564>
  }
  sphere { // sphere14_16
    <0,0,0>,1
    scale 0.9792
    translate  <11.19799, -0.55254, 0.09108>
  }
  sphere { // sphere15_17
    <0,0,0>,1
    scale 0.992
    translate  <11.22999, -0.59882, 0.03767>
  }
  sphere { // sphere16_18
    <0,0,0>,1
    scale 1.0048
    translate  <11.26199, -0.63955, -0.02412>
  }
  sphere { // sphere17_19
    <0,0,0>,1
    scale 1.0176
    translate  <11.29399, -0.67351, -0.0937>
  }
  sphere { // sphere18_20
    <0,0,0>,1
    scale 1.0304
    translate  <11.32599, -0.69957, -0.17028>
  }
  sphere { // sphere19_21
    <0,0,0>,1
    scale 1.0432
    translate  <11.35799, -0.71667, -0.25294>
  }
  sphere { // sphere20_22
    <0,0,0>,1
    scale 1.056
    translate  <11.38999, -0.72386, -0.34062>
  }
  sphere { // sphere21_23
    <0,0,0>,1
    scale 1.0688
    translate  <11.42199, -0.72032, -0.43213>
  }
  sphere { // sphere22_24
    <0,0,0>,1
    scale 1.0816
    translate  <11.45399, -0.70538, -0.52616>
  }
  sphere { // sphere23_25
    <0,0,0>,1
    scale 1.0944
    translate  <11.48599, -0.67851, -0.62131>
  }
  sphere { // sphere24_26
    <0,0,0>,1
    scale 1.1072
    translate  <11.51799, -0.63937, -0.7161>
  }
  sphere { // sphere25_27
    <0,0,0>,1
    scale 1.12
    translate  <11.54999, -0.58779, -0.80902>
  }
  sphere { // sphere26_28
    <0,0,0>,1
    scale 1.1328
    translate  <11.58199, -0.52377, -0.89848>
  }
  sphere { // sphere27_29
    <0,0,0>,1
    scale 1.1456
    translate  <11.61399, -0.44753, -0.98291>
  }
  sphere { // sphere28_30
    <0,0,0>,1
    scale 1.1584
    translate  <11.64599, -0.35946, -1.06075>
  }
  sphere { // sphere29_31
    <0,0,0>,1
    scale 1.1712
    translate  <11.67799, -0.26015, -1.13045>
  }
  sphere { // sphere30_32
    <0,0,0>,1
    scale 1.184
    translate  <11.70999, -0.1504, -1.19054>
  }
  sphere { // sphere31_33
    <0,0,0>,1
    scale 1.1968
    translate  <11.74199, -0.03116, -1.23961>
  }
  sphere { // sphere32_34
    <0,0,0>,1
    scale 1.2096
    translate  <11.77399, 0.09642, -1.27636>
  }
  sphere { // sphere33_35
    <0,0,0>,1
    scale 1.2224
    translate  <11.80599, 0.23103, -1.29962>
  }
  sphere { // sphere34_36
    <0,0,0>,1
    scale 1.2352
    translate  <11.83799, 0.37121, -1.30836>
  }
  sphere { // sphere35_37
    <0,0,0>,1
    scale 1.248
    translate  <11.86999, 0.51537, -1.30169>
  }
  sphere { // sphere36_38
    <0,0,0>,1
    scale 1.2608
    translate  <11.90199, 0.66179, -1.27892>
  }
  sphere { // sphere37_39
    <0,0,0>,1
    scale 1.2736
    translate  <11.93398, 0.80866, -1.23954>
  }
  sphere { // sphere38_40
    <0,0,0>,1
    scale 1.2864
    translate  <11.96598, 0.95409, -1.18326>
  }
  sphere { // sphere39_41
    <0,0,0>,1
    scale 1.2992
    translate  <11.99798, 1.09613, -1.11>
  }
  sphere { // sphere40_42
    <0,0,0>,1
    scale 1.312
    translate  <12.02998, 1.23282, -1.01988>
  }
  sphere { // sphere41_43
    <0,0,0>,1
    scale 1.3248
    translate  <12.06198, 1.36218, -0.91328>
  }
  sphere { // sphere42_44
    <0,0,0>,1
    scale 1.3376
    translate  <12.09398, 1.48225, -0.79078>
  }
  sphere { // sphere43_45
    <0,0,0>,1
    scale 1.3504
    translate  <12.12598, 1.59113, -0.65322>
  }
  sphere { // sphere44_46
    <0,0,0>,1
    scale 1.3632
    translate  <12.15798, 1.687, -0.50163>
  }
  sphere { // sphere45_47
    <0,0,0>,1
    scale 1.376
    translate  <12.18998, 1.76812, -0.33729>
  }
  sphere { // sphere46_48
    <0,0,0>,1
    scale 1.3888
    translate  <12.22198, 1.83289, -0.16165>
  }
  sphere { // sphere47_49
    <0,0,0>,1
    scale 1.4016
    translate  <12.25398, 1.87985, 0.02362>
  }
  sphere { // sphere48_50
    <0,0,0>,1
    scale 1.4144
    translate  <12.28598, 1.90773, 0.21668>
  }
  sphere { // sphere49_51
    <0,0,0>,1
    scale 1.4272
    translate  <12.31798, 1.91544, 0.41553>
  }
  sphere { // sphere50_52
    <0,0,0>,1
    scale 1.44
    translate  <12.34998, 1.90211, 0.61803>
  }
  sphere { // sphere51_53
    <0,0,0>,1
    scale 1.4528
    translate  <12.38198, 1.86709, 0.82193>
  }
  sphere { // sphere52_54
    <0,0,0>,1
    scale 1.4656
    translate  <12.41398, 1.80998, 1.02487>
  }
  sphere { // sphere53_55
    <0,0,0>,1
    scale 1.4784
    translate  <12.44598, 1.73064, 1.22445>
  }
  sphere { // sphere54_56
    <0,0,0>,1
    scale 1.4912
    translate  <12.47798, 1.62918, 1.41822>
  }
  sphere { // sphere55_57
    <0,0,0>,1
    scale 1.504
    translate  <12.50998, 1.506, 1.60373>
  }
  sphere { // sphere56_58
    <0,0,0>,1
    scale 1.5168
    translate  <12.54198, 1.36176, 1.77854>
  }
  sphere { // sphere57_59
    <0,0,0>,1
    scale 1.5296
    translate  <12.57398, 1.1974, 1.94027>
  }
  sphere { // sphere58_60
    <0,0,0>,1
    scale 1.5424
    translate  <12.60598, 1.01411, 2.08662>
  }
  sphere { // sphere59_61
    <0,0,0>,1
    scale 1.5552
    translate  <12.63798, 0.81336, 2.21541>
  }
  sphere { // sphere60_62
    <0,0,0>,1
    scale 1.568
    translate  <12.66998, 0.59686, 2.3246>
  }
  sphere { // sphere61_63
    <0,0,0>,1
    scale 1.5808
    translate  <12.70197, 0.36655, 2.41231>
  }
  sphere { // sphere62_64
    <0,0,0>,1
    scale 1.5936
    translate  <12.73397, 0.12461, 2.47687>
  }
  sphere { // sphere63_65
    <0,0,0>,1
    scale 1.6064
    translate  <12.76597, -0.12662, 2.51682>
  }
  sphere { // sphere64_66
    <0,0,0>,1
    scale 1.6192
    translate  <12.79797, -0.38458, 2.53095>
  }
  sphere { // sphere65_67
    <0,0,0>,1
    scale 1.632
    translate  <12.82997, -0.64659, 2.51831>
  }
  sphere { // sphere66_68
    <0,0,0>,1
    scale 1.6448
    translate  <12.86197, -0.90986, 2.47826>
  }
  sphere { // sphere67_69
    <0,0,0>,1
    scale 1.6576
    translate  <12.89397, -1.17147, 2.4104>
  }
  sphere { // sphere68_70
    <0,0,0>,1
    scale 1.6704
    translate  <12.92597, -1.42847, 2.3147>
  }
  sphere { // sphere69_71
    <0,0,0>,1
    scale 1.6832
    translate  <12.95797, -1.67789, 2.19141>
  }
  sphere { // sphere70_72
    <0,0,0>,1
    scale 1.696
    translate  <12.98997, -1.91673, 2.04111>
  }
  sphere { // sphere71_73
    <0,0,0>,1
    scale 1.7088
    translate  <13.02197, -2.14207, 1.8647>
  }
  sphere { // sphere72_74
    <0,0,0>,1
    scale 1.7216
    translate  <13.05397, -2.35106, 1.66341>
  }
  sphere { // sphere73_75
    <0,0,0>,1
    scale 1.7344
    translate  <13.08597, -2.54094, 1.43876>
  }
  sphere { // sphere74_76
    <0,0,0>,1
    scale 1.7472
    translate  <13.11797, -2.70911, 1.1926>
  }
  sphere { // sphere75_77
    <0,0,0>,1
    scale 1.76
    translate  <13.14997, -2.85317, 0.92705>
  }
  sphere { // sphere76_78
    <0,0,0>,1
    scale 1.7728
    translate  <13.18197, -2.97089, 0.6445>
  }
  sphere { // sphere77_79
    <0,0,0>,1
    scale 1.7856
    translate  <13.21397, -3.06032, 0.3476>
  }
  sphere { // sphere78_80
    <0,0,0>,1
    scale 1.7984
    translate  <13.24597, -3.11975, 0.03921>
  }
  sphere { // sphere79_81
    <0,0,0>,1
    scale 1.8112
    translate  <13.27797, -3.14778, -0.27761>
  }
  sphere { // sphere80_82
    <0,0,0>,1
    scale 1.824
    translate  <13.30997, -3.14332, -0.59962>
  }
  sphere { // sphere81_83
    <0,0,0>,1
    scale 1.8368
    translate  <13.34197, -3.10561, -0.92346>
  }
  sphere { // sphere82_84
    <0,0,0>,1
    scale 1.8496
    translate  <13.37397, -3.03425, -1.24568>
  }
  sphere { // sphere83_85
    <0,0,0>,1
    scale 1.8624
    translate  <13.40597, -2.9292, -1.56274>
  }
  sphere { // sphere84_86
    <0,0,0>,1
    scale 1.8752
    translate  <13.43797, -2.7908, -1.8711>
  }
  sphere { // sphere85_87
    <0,0,0>,1
    scale 1.888
    translate  <13.46996, -2.61974, -2.16724>
  }
  sphere { // sphere86_88
    <0,0,0>,1
    scale 1.9008
    translate  <13.50196, -2.41711, -2.44768>
  }
  sphere { // sphere87_89
    <0,0,0>,1
    scale 1.9136
    translate  <13.53396, -2.18436, -2.70905>
  }
  sphere { // sphere88_90
    <0,0,0>,1
    scale 1.9264
    translate  <13.56596, -1.92331, -2.9481>
  }
  sphere { // sphere89_91
    <0,0,0>,1
    scale 1.9392
    translate  <13.59796, -1.6361, -3.16176>
  }
  sphere { // sphere90_92
    <0,0,0>,1
    scale 1.952
    translate  <13.62996, -1.32525, -3.34719>
  }
  sphere { // sphere91_93
    <0,0,0>,1
    scale 1.9648
    translate  <13.66196, -0.99354, -3.50178>
  }
  sphere { // sphere92_94
    <0,0,0>,1
    scale 1.9776
    translate  <13.69396, -0.64408, -3.62319>
  }
  sphere { // sphere93_95
    <0,0,0>,1
    scale 1.9904
    translate  <13.72596, -0.28021, -3.70943>
  }
  sphere { // sphere94_96
    <0,0,0>,1
    scale 2.0032
    translate  <13.75796, 0.09449, -3.75881>
  }
  sphere { // sphere95_97
    <0,0,0>,1
    scale 2.016
    translate  <13.78996, 0.47627, -3.77003>
  }
  sphere { // sphere96_98
    <0,0,0>,1
    scale 2.0288
    translate  <13.82196, 0.8612, -3.74218>
  }
  sphere { // sphere97_99
    <0,0,0>,1
    scale 2.0416
    translate  <13.85396, 1.24526, -3.67474>
  }
  sphere { // sphere98_100
    <0,0,0>,1
    scale 2.0544
    translate  <13.88596, 1.62435, -3.56761>
  }
  sphere { // sphere99_101
    <0,0,0>,1
    scale 2.0672
    translate  <13.91796, 1.99435, -3.42113>
  }
  sphere { // sphere100_102
    <0,0,0>,1
    scale 2.08
    translate  <13.94996, 2.35114, -3.23607>
  }
  sphere { // sphere101_103
    <0,0,0>,1
    scale 2.0928
    translate  <13.98196, 2.69069, -3.0136>
  }
  sphere { // sphere102_104
    <0,0,0>,1
    scale 2.1056
    translate  <14.01396, 3.00905, -2.75536>
  }
  sphere { // sphere103_105
    <0,0,0>,1
    scale 2.1184
    translate  <14.04596, 3.30245, -2.46337>
  }
  sphere { // sphere104_106
    <0,0,0>,1
    scale 2.1312
    translate  <14.07796, 3.56731, -2.14007>
  }
  sphere { // sphere105_107
    <0,0,0>,1
    scale 2.144
    translate  <14.10996, 3.80027, -1.78827>
  }
  sphere { // sphere106_108
    <0,0,0>,1
    scale 2.1568
    translate  <14.14196, 3.99828, -1.41115>
  }
  sphere { // sphere107_109
    <0,0,0>,1
    scale 2.1696
    translate  <14.17396, 4.15858, -1.01221>
  }
  sphere { // sphere108_110
    <0,0,0>,1
    scale 2.1824
    translate  <14.20596, 4.27879, -0.59525>
  }
  sphere { // sphere109_111
    <0,0,0>,1
    scale 2.1952
    translate  <14.23796, 4.3569, -0.16433>
  }
  sphere { // sphere110_112
    <0,0,0>,1
    scale 2.208
    translate  <14.26995, 4.39131, 0.27628>
  }
  sphere { // sphere111_113
    <0,0,0>,1
    scale 2.2208
    translate  <14.30195, 4.38088, 0.72211>
  }
  sphere { // sphere112_114
    <0,0,0>,1
    scale 2.2336
    translate  <14.33395, 4.32491, 1.16857>
  }
  sphere { // sphere113_115
    <0,0,0>,1
    scale 2.2464
    translate  <14.36595, 4.22316, 1.61098>
  }
  sphere { // sphere114_116
    <0,0,0>,1
    scale 2.2592
    translate  <14.39795, 4.07591, 2.04463>
  }
  sphere { // sphere115_117
    <0,0,0>,1
    scale 2.272
    translate  <14.42995, 3.88391, 2.4648>
  }
  sphere { // sphere116_118
    <0,0,0>,1
    scale 2.2848
    translate  <14.46195, 3.64838, 2.86687>
  }
  sphere { // sphere117_119
    <0,0,0>,1
    scale 2.2976
    translate  <14.49395, 3.37104, 3.2463>
  }
  sphere { // sphere118_120
    <0,0,0>,1
    scale 2.3104
    translate  <14.52595, 3.0541, 3.59873>
  }
  sphere { // sphere119_121
    <0,0,0>,1
    scale 2.3232
    translate  <14.55795, 2.7002, 3.92001>
  }
  sphere { // sphere120_122
    <0,0,0>,1
    scale 2.336
    translate  <14.58995, 2.31242, 4.20627>
  }
  sphere { // sphere121_123
    <0,0,0>,1
    scale 2.3488
    translate  <14.62195, 1.89425, 4.45392>
  }
  sphere { // sphere122_124
    <0,0,0>,1
    scale 2.3616
    translate  <14.65395, 1.44956, 4.65974>
  }
  sphere { // sphere123_125
    <0,0,0>,1
    scale 2.3744
    translate  <14.68595, 0.98257, 4.82088>
  }
  sphere { // sphere124_126
    <0,0,0>,1
    scale 2.3872
    translate  <14.71795, 0.49779, 4.93495>
  }
  sphere { // sphere125_127
    <0,0,0>,1
    scale 2.4
    translate  <14.74995, 0.0, 5.0>
  }
  sphere { // sphere126_128
    <0,0,0>,1
    scale 2.4128
    translate  <14.78195, -0.50582, 5.01455>
  }
  sphere { // sphere127_129
    <0,0,0>,1
    scale 2.4256
    translate  <14.81395, -1.01453, 4.97766>
  }
  sphere { // sphere128_130
    <0,0,0>,1
    scale 2.4384
    translate  <14.84595, -1.52085, 4.8889>
  }
  sphere { // sphere129_131
    <0,0,0>,1
    scale 2.4512
    translate  <14.87795, -2.01949, 4.74839>
  }
  sphere { // sphere130_132
    <0,0,0>,1
    scale 2.464
    translate  <14.90995, -2.50512, 4.55679>
  }
  sphere { // sphere131_133
    <0,0,0>,1
    scale 2.4768
    translate  <14.94195, -2.97249, 4.31531>
  }
  sphere { // sphere132_134
    <0,0,0>,1
    scale 2.4896
    translate  <14.97395, -3.41645, 4.02569>
  }
  sphere { // sphere133_135
    <0,0,0>,1
    scale 2.5024
    translate  <15.00595, -3.83204, 3.69023>
  }
  sphere { // sphere134_136
    <0,0,0>,1
    scale 2.5152
    translate  <15.03794, -4.2145, 3.31172>
  }
  sphere { // sphere135_137
    <0,0,0>,1
    scale 2.528
    translate  <15.06994, -4.55937, 2.89346>
  }
  sphere { // sphere136_138
    <0,0,0>,1
    scale 2.5408
    translate  <15.10194, -4.86249, 2.4392>
  }
  sphere { // sphere137_139
    <0,0,0>,1
    scale 2.5536
    translate  <15.13394, -5.12012, 1.95313>
  }
  sphere { // sphere138_140
    <0,0,0>,1
    scale 2.5664
    translate  <15.16594, -5.3289, 1.43984>
  }
  sphere { // sphere139_141
    <0,0,0>,1
    scale 2.5792
    translate  <15.19794, -5.48597, 0.90426>
  }
  sphere { // sphere140_142
    <0,0,0>,1
    scale 2.592
    translate  <15.22994, -5.58895, 0.35162>
  }
  sphere { // sphere141_143
    <0,0,0>,1
    scale 2.6048
    translate  <15.26194, -5.63599, -0.21257>
  }
  sphere { // sphere142_144
    <0,0,0>,1
    scale 2.6176
    translate  <15.29394, -5.62582, -0.78265>
  }
  sphere { // sphere143_145
    <0,0,0>,1
    scale 2.6304
    translate  <15.32594, -5.55773, -1.35278>
  }
  sphere { // sphere144_146
    <0,0,0>,1
    scale 2.6432
    translate  <15.35794, -5.43162, -1.91704>
  }
  sphere { // sphere145_147
    <0,0,0>,1
    scale 2.656
    translate  <15.38994, -5.24799, -2.46952>
  }
  sphere { // sphere146_148
    <0,0,0>,1
    scale 2.6688
    translate  <15.42194, -5.00795, -3.00433>
  }
  sphere { // sphere147_149
    <0,0,0>,1
    scale 2.6816
    translate  <15.45394, -4.71321, -3.51568>
  }
  sphere { // sphere148_150
    <0,0,0>,1
    scale 2.6944
    translate  <15.48594, -4.36607, -3.99797>
  }
  sphere { // sphere149_151
    <0,0,0>,1
    scale 2.7072
    translate  <15.51794, -3.96943, -4.44581>
  }
  sphere { // sphere150_152
    <0,0,0>,1
    scale 2.72
    translate  <15.54994, -3.52671, -4.8541>
  }
  sphere { // sphere151_153
    <0,0,0>,1
    scale 2.7328
    translate  <15.58194, -3.04188, -5.21809>
  }
  sphere { // sphere152_154
    <0,0,0>,1
    scale 2.7456
    translate  <15.61394, -2.5194, -5.53344>
  }
  sphere { // sphere153_155
    <0,0,0>,1
    scale 2.7584
    translate  <15.64594, -1.96417, -5.79624>
  }
  sphere { // sphere154_156
    <0,0,0>,1
    scale 2.7712
    translate  <15.67794, -1.3815, -6.00308>
  }
  sphere { // sphere155_157
    <0,0,0>,1
    scale 2.784
    translate  <15.70994, -0.77706, -6.15111>
  }
  sphere { // sphere156_158
    <0,0,0>,1
    scale 2.7968
    translate  <15.74194, -0.15681, -6.23802>
  }
  sphere { // sphere157_159
    <0,0,0>,1
    scale 2.8096
    translate  <15.77394, 0.47305, -6.26215>
  }
  sphere { // sphere158_160
    <0,0,0>,1
    scale 2.8224
    translate  <15.80593, 1.10615, -6.22244>
  }
  sphere { // sphere159_161
    <0,0,0>,1
    scale 2.8352
    translate  <15.83793, 1.73598, -6.11849>
  }
  sphere { // sphere160_162
    <0,0,0>,1
    scale 2.848
    translate  <15.86993, 2.356, -5.95056>
  }
  sphere { // sphere161_163
    <0,0,0>,1
    scale 2.8608
    translate  <15.90193, 2.95969, -5.71959>
  }
  sphere { // sphere162_164
    <0,0,0>,1
    scale 2.8736
    translate  <15.93393, 3.54063, -5.42718>
  }
  sphere { // sphere163_165
    <0,0,0>,1
    scale 2.8864
    translate  <15.96593, 4.09255, -5.07557>
  }
  sphere { // sphere164_166
    <0,0,0>,1
    scale 2.8992
    translate  <15.99793, 4.60938, -4.66767>
  }
  sphere { // sphere165_167
    <0,0,0>,1
    scale 2.912
    translate  <16.02993, 5.08539, -4.20699>
  }
  sphere { // sphere166_168
    <0,0,0>,1
    scale 2.9248
    translate  <16.06193, 5.51515, -3.69765>
  }
  sphere { // sphere167_169
    <0,0,0>,1
    scale 2.9376
    translate  <16.09393, 5.8937, -3.1443>
  }
  sphere { // sphere168_170
    <0,0,0>,1
    scale 2.9504
    translate  <16.12593, 6.21652, -2.55211>
  }
  sphere { // sphere169_171
    <0,0,0>,1
    scale 2.9632
    translate  <16.15793, 6.4796, -1.92673>
  }
  sphere { // sphere170_172
    <0,0,0>,1
    scale 2.976
    translate  <16.18993, 6.67955, -1.27419>
  }
  sphere { // sphere171_173
    <0,0,0>,1
    scale 2.9888
    translate  <16.22193, 6.81355, -0.6009>
  }
  sphere { // sphere172_174
    <0,0,0>,1
    scale 3.0016
    translate  <16.25393, 6.87945, 0.08646>
  }
  sphere { // sphere173_175
    <0,0,0>,1
    scale 3.0144
    translate  <16.28593, 6.87578, 0.78097>
  }
  sphere { // sphere174_176
    <0,0,0>,1
    scale 3.0272
    translate  <16.31793, 6.80178, 1.47557>
  }
  sphere { // sphere175_177
    <0,0,0>,1
    scale 3.04
    translate  <16.34993, 6.65739, 2.16312>
  }
  sphere { // sphere176_178
    <0,0,0>,1
    scale 3.0528
    translate  <16.38193, 6.44329, 2.83646>
  }
  sphere { // sphere177_179
    <0,0,0>,1
    scale 3.0656
    translate  <16.41393, 6.16089, 3.48851>
  }
  sphere { // sphere178_180
    <0,0,0>,1
    scale 3.0784
    translate  <16.44593, 5.81233, 4.11232>
  }
  sphere { // sphere179_181
    <0,0,0>,1
    scale 3.0912
    translate  <16.47793, 5.40043, 4.70115>
  }
  sphere { // sphere180_182
    <0,0,0>,1
    scale 3.104
    translate  <16.50993, 4.92873, 5.24857>
  }
  sphere { // sphere181_183
    <0,0,0>,1
    scale 3.1168
    translate  <16.54193, 4.40141, 5.74849>
  }
  sphere { // sphere182_184
    <0,0,0>,1
    scale 3.1296
    translate  <16.57393, 3.82327, 6.19524>
  }
  sphere { // sphere183_185
    <0,0,0>,1
    scale 3.1424
    translate  <16.60592, 3.19968, 6.58364>
  }
  sphere { // sphere184_186
    <0,0,0>,1
    scale 3.1552
    translate  <16.63792, 2.53657, 6.90908>
  }
  sphere { // sphere185_187
    <0,0,0>,1
    scale 3.168
    translate  <16.66992, 1.8403, 7.16751>
  }
  sphere { // sphere186_188
    <0,0,0>,1
    scale 3.1808
    translate  <16.70192, 1.11767, 7.35556>
  }
  sphere { // sphere187_189
    <0,0,0>,1
    scale 3.1936
    translate  <16.73392, 0.37582, 7.47055>
  }
  sphere { // sphere188_190
    <0,0,0>,1
    scale 3.2064
    translate  <16.76592, -0.37784, 7.5105>
  }
  sphere { // sphere189_191
    <0,0,0>,1
    scale 3.2192
    translate  <16.79792, -1.13571, 7.4742>
  }
  sphere { // sphere190_192
    <0,0,0>,1
    scale 3.232
    translate  <16.82992, -1.89004, 7.36123>
  }
  sphere { // sphere191_193
    <0,0,0>,1
    scale 3.2448
    translate  <16.86192, -2.63307, 7.17192>
  }
  sphere { // sphere192_194
    <0,0,0>,1
    scale 3.2576
    translate  <16.89392, -3.35705, 6.90743>
  }
  sphere { // sphere193_195
    <0,0,0>,1
    scale 3.2704
    translate  <16.92592, -4.05435, 6.56967>
  }
  sphere { // sphere194_196
    <0,0,0>,1
    scale 3.2832
    translate  <16.95792, -4.71754, 6.16136>
  }
  sphere { // sphere195_197
    <0,0,0>,1
    scale 3.296
    translate  <16.98992, -5.33947, 5.68595>
  }
  sphere { // sphere196_198
    <0,0,0>,1
    scale 3.3088
    translate  <17.02192, -5.91333, 5.14763>
  }
  sphere { // sphere197_199
    <0,0,0>,1
    scale 3.3216
    translate  <17.05392, -6.43275, 4.55127>
  }
  sphere { // sphere198_200
    <0,0,0>,1
    scale 3.3344
    translate  <17.08592, -6.89185, 3.90239>
  }
  sphere { // sphere199_201
    <0,0,0>,1
    scale 3.3472
    translate  <17.11792, -7.28532, 3.20713>
  }
  sphere { // sphere200_202
    <0,0,0>,1
    scale 3.36
    translate  <17.14992, -7.60845, 2.47213>
  }
  sphere { // sphere201_203
    <0,0,0>,1
    scale 3.3728
    translate  <17.18192, -7.85723, 1.70453>
  }
  sphere { // sphere202_204
    <0,0,0>,1
    scale 3.3856
    translate  <17.21392, -8.02837, 0.91188>
  }
  sphere { // sphere203_205
    <0,0,0>,1
    scale 3.3984
    translate  <17.24592, -8.11935, 0.10203>
  }
  sphere { // sphere204_206
    <0,0,0>,1
    scale 3.4112
    translate  <17.27792, -8.12844, -0.71687>
  }
  sphere { // sphere205_207
    <0,0,0>,1
    scale 3.424
    translate  <17.30992, -8.05475, -1.53653>
  }
  sphere { // sphere206_208
    <0,0,0>,1
    scale 3.4368
    translate  <17.34192, -7.89821, -2.34856>
  }
  sphere { // sphere207_209
    <0,0,0>,1
    scale 3.4496
    translate  <17.37391, -7.65963, -3.14457>
  }
  sphere { // sphere208_210
    <0,0,0>,1
    scale 3.4624
    translate  <17.40591, -7.34066, -3.91626>
  }
  sphere { // sphere209_211
    <0,0,0>,1
    scale 3.4752
    translate  <17.43791, -6.94377, -4.65548>
  }
  sphere { // sphere210_212
    <0,0,0>,1
    scale 3.488
    translate  <17.46991, -6.4723, -5.35436>
  }
  sphere { // sphere211_213
    <0,0,0>,1
    scale 3.5008
    translate  <17.50191, -5.93036, -6.00536>
  }
  sphere { // sphere212_214
    <0,0,0>,1
    scale 3.5136
    translate  <17.53391, -5.32282, -6.60136>
  }
  sphere { // sphere213_215
    <0,0,0>,1
    scale 3.5264
    translate  <17.56591, -4.65527, -7.13574>
  }
  sphere { // sphere214_216
    <0,0,0>,1
    scale 3.5392
    translate  <17.59791, -3.934, -7.60244>
  }
  sphere { // sphere215_217
    <0,0,0>,1
    scale 3.552
    translate  <17.62991, -3.16586, -7.99607>
  }
  sphere { // sphere216_218
    <0,0,0>,1
    scale 3.5648
    translate  <17.66191, -2.3583, -8.31191>
  }
  sphere { // sphere217_219
    <0,0,0>,1
    scale 3.5776
    translate  <17.69391, -1.51919, -8.54601>
  }
  sphere { // sphere218_220
    <0,0,0>,1
    scale 3.5904
    translate  <17.72591, -0.65685, -8.69522>
  }
  sphere { // sphere219_221
    <0,0,0>,1
    scale 3.6032
    translate  <17.75791, 0.22014, -8.75723>
  }
  sphere { // sphere220_222
    <0,0,0>,1
    scale 3.616
    translate  <17.78991, 1.10294, -8.7306>
  }
  sphere { // sphere221_223
    <0,0,0>,1
    scale 3.6288
    translate  <17.82191, 1.98256, -8.61481>
  }
  sphere { // sphere222_224
    <0,0,0>,1
    scale 3.6416
    translate  <17.85391, 2.84998, -8.41022>
  }
  sphere { // sphere223_225
    <0,0,0>,1
    scale 3.6544
    translate  <17.88591, 3.69623, -8.11814>
  }
  sphere { // sphere224_226
    <0,0,0>,1
    scale 3.6672
    translate  <17.91791, 4.51246, -7.74075>
  }
  sphere { // sphere225_227
    <0,0,0>,1
    scale 3.68
    translate  <17.94991, 5.29007, -7.28115>
  }
  sphere { // sphere226_228
    <0,0,0>,1
    scale 3.6928
    translate  <17.98191, 6.02075, -6.7433>
  }
  sphere { // sphere227_229
    <0,0,0>,1
    scale 3.7056
    translate  <18.01391, 6.69662, -6.13201>
  }
  sphere { // sphere228_230
    <0,0,0>,1
    scale 3.7184
    translate  <18.04591, 7.31029, -5.45289>
  }
  sphere { // sphere229_231
    <0,0,0>,1
    scale 3.7312
    translate  <18.07791, 7.85494, -4.71226>
  }
  sphere { // sphere230_232
    <0,0,0>,1
    scale 3.744
    translate  <18.10991, 8.3244, -3.91716>
  }
  sphere { // sphere231_233
    <0,0,0>,1
    scale 3.7568
    translate  <18.1419, 8.71323, -3.07525>
  }
  sphere { // sphere232_234
    <0,0,0>,1
    scale 3.7696
    translate  <18.1739, 9.01674, -2.1947>
  }
  sphere { // sphere233_235
    <0,0,0>,1
    scale 3.7824
    translate  <18.2059, 9.23109, -1.2842>
  }
  sphere { // sphere234_236
    <0,0,0>,1
    scale 3.7952
    translate  <18.2379, 9.35334, -0.35278>
  }
  sphere { // sphere235_237
    <0,0,0>,1
    scale 3.808
    translate  <18.2699, 9.38144, 0.59024>
  }
  sphere { // sphere236_238
    <0,0,0>,1
    scale 3.8208
    translate  <18.3019, 9.31431, 1.5353>
  }
  sphere { // sphere237_239
    <0,0,0>,1
    scale 3.8336
    translate  <18.3339, 9.15181, 2.47278>
  }
  sphere { // sphere238_240
    <0,0,0>,1
    scale 3.8464
    translate  <18.3659, 8.8948, 3.39304>
  }
  sphere { // sphere239_241
    <0,0,0>,1
    scale 3.85919
    translate  <18.3979, 8.54512, 4.28654>
  }
  sphere { // sphere240_242
    <0,0,0>,1
    scale 3.87199
    translate  <18.4299, 8.10554, 5.14394>
  }
  sphere { // sphere241_243
    <0,0,0>,1
    scale 3.88479
    translate  <18.4619, 7.57981, 5.95617>
  }
  sphere { // sphere242_244
    <0,0,0>,1
    scale 3.89759
    translate  <18.4939, 6.97258, 6.71456>
  }
  sphere { // sphere243_245
    <0,0,0>,1
    scale 3.91039
    translate  <18.5259, 6.28938, 7.41094>
  }
  sphere { // sphere244_246
    <0,0,0>,1
    scale 3.92319
    translate  <18.5579, 5.53654, 8.03767>
  }
  sphere { // sphere245_247
    <0,0,0>,1
    scale 3.93599
    translate  <18.5899, 4.72118, 8.5878>
  }
  sphere { // sphere246_248
    <0,0,0>,1
    scale 3.94879
    translate  <18.6219, 3.85111, 9.05508>
  }
  sphere { // sphere247_249
    <0,0,0>,1
    scale 3.96159
    translate  <18.6539, 2.93476, 9.43406>
  }
  sphere { // sphere248_250
    <0,0,0>,1
    scale 3.97439
    translate  <18.6859, 1.98112, 9.72016>
  }
  sphere { // sphere249_251
    <0,0,0>,1
    scale 3.98719
    translate  <18.7179, 0.9996, 9.90971>
  }
  sphere { // sphere250_252
    <0,0,0>,1
    scale 3.99999
    translate  <18.7499, -0.00001, 9.99999>
  }
  scale <0.1, 0.1, 0.08>
  rotate <-145.0, 0.0, -90.0>
  translate  <-0.4, 0.0, 1.4>
}




// ********  OBJECTS  *******

object { // Fence2->Fence1
  Fence1
  translate  <0.0, 28.022131, -0.257381>
}


object { Fence1 }




//#include "trees.inc"

object {
  Tree1
  rotate 90.0*x
  translate  <-21.721157, 31.3171, -1.5>
}


box { // Water
  <-1, -1, -1>, <1, 1, 1>
  scale <300.0, 13.416838, -1.993118>
  translate  -3.509425*z
  texture {
    txtWater
  }
}

// ***  effect stuff ***

   #declare camera_location = < %camera translate% >
   #declare camera_look_at = < %lookat translate% >
   #declare camera_sky = <0, 0, 1>
   #declare camera_direction = < %camera rgb% >

   #declare effect_location = < %sunlight1 translate% >
   #declare effect_type="sun"
   #declare effect_scale = 1.3
   #declare effect_always_on_top = true


   #if ( %drawlens degrees% )
      #debug "Parcing lens.inc - Steve\n"
      #include "C:\1\SNAIL\lens.inc"
      #debug "Finished parcing lens.inc - Steve\n"
   #else
      #debug "NOT parcing lens.inc - Steve\n"
   #end

// *** end lens effect stuff ***

/*union { // SunShift
  sphere { // Sun
    <0,0,0>,1
    texture {
      txtSun
    }
    no_shadow
    hollow
    scale 4500.0
    translate  < %sunlight1 translate% >
  }
  sphere { // SunFlare
    <0,0,0>,1
    no_shadow
    hollow
    translate  < %sunlight1 translate% >
  }
  //rotate < %sunshift rotate% >
}*/

sphere { // Clouds
  <0,0,0>,1
  texture {
    txtClouds
  }
  no_shadow
  hollow
  scale 74171.882812
}


union { // Ground
  object { San_Franscisco }
  object { // San_Franscisc1->San Franscisco
    San_Franscisco
    texture {
      txtGrass
    }
    scale <1.0, 1.0, -1.0>
    rotate -180.0*x
    translate  200.0*y
  }
  object { // San_Franscisc3->San Franscisco
    San_Franscisco
    scale <1.0, 1.0, -1.0>
    rotate <180.0, 0.0, 180.0>
    translate  -200.0*x
  }
  object { // San_Franscisc5->San Franscisco
    San_Franscisco
    texture {
      txtGrass
    }
    rotate -180.0*z
    translate  <-200.0, 200.0, 0.0>
  }
  object { // San_Franscisc6->San Franscisco
    San_Franscisco
    texture {
      txtGrass
    }
    rotate -180.0*z
    translate  <200.0, 200.0, 0.0>
  }
  object { // San_Franscisc7->San Franscisco
    San_Franscisco
    texture {
      txtGrass
    }
    rotate -180.0*z
    translate  <200.0, -200.0, 0.0>
  }
  object { // San_Franscisc8->San Franscisco
    San_Franscisco
    texture {
      txtGrass
    }
    rotate -180.0*z
    translate  <-200.0, -200.0, 0.0>
  }
  object { // San_Franscisc2->San Franscisco
    San_Franscisco
    texture {
      txtGrass
    }
    scale <1.0, 1.0, -1.0>
    rotate -180.0*x
    translate  -200.0*y
  }
  object { // San_Franscisc4->San Franscisco
    San_Franscisco
    scale <1.0, 1.0, -1.0>
    rotate <180.0, 0.0, 180.0>
    translate  200.0*x
  }
  texture {
    txtGrass
  }
}


sphere { // Sky
  <0,0,0>,1
  texture {
    txtBlueSky
  }
  hollow
  scale 100000.0
}

#if ( %drawtruck degrees% )
   #debug "Parcing truck - Steve\n"
   #include "truck.inc"
   union { // Truck
     object { TruckBody }
     object { Wheel }
     object { TruckBumper }
     object { Bed }
     object { Tank1 }
     object { // Tank2->Tank1
       Tank1
       translate  <-3.083885, 0.0, 0.0>
     }
     object { WheelGroup1 }
     object { // WheelGroup2->WheelGroup1
       WheelGroup1
       translate  2.2*y
     }
     object { // WheelGroup3->WheelGroup1
       WheelGroup1
       rotate -180.0*z
       translate  20.535*y
     }
     object { // WheelGroup4->WheelGroup1
       WheelGroup1
       rotate -180.0*z
       translate  18.336*y
     }
     object { // Wheel1->Wheel
       Wheel
       rotate <0.0, 0.0, -180.0>
       translate  <0.0, 3.335, 0.0>
     }
     object { FrameCSG }
     object { Exhaust1 }
     object { Exhaust2 }
     scale 0.59
     rotate 90.0*z
     translate  < %truck translate% >
   }
   #debug "Finished parcing truck - Steve\n"
#else
   #debug "NOT parcing truck - Steve\n"
#end

#declare SnailBody1 = blob {
  threshold 0.6
  component 1.0, 0.530268, < %snailblob1 translate% >
  component 1.0, 0.826856, < %snailblob2 translate% >
  component 1.0, 0.224834, <-0.025316, -0.725738, -0.599156>
  component 1.0, 0.224834, <0.126582, -0.725738, -0.481013>
  component 1.0, 0.216238, <0.295359, -0.725738, -0.43038>
  component 1.0, 0.224834, <0.43038, -0.725738, -0.261603>
  component 1.0, 0.224834, <0.447257, -0.725738, -0.059072>
  component 1.0, 0.207287, <0.329114, -0.725738, 0.413502>
  component 1.0, 0.216238, <0.177215, -0.725738, 0.531646>
  component 1.0, 0.224834, <-0.008439, -0.725738, 0.565401>
  component 1.0, 0.224834, <0.43038, -0.725738, 0.21097>
  component 1.0, 0.55687, < %snailblob19 translate% >
  component 1.308379, 0.561805, < %snailblob20 translate% >
  component 1.260897, 0.805206, < %snailblob21 translate% >
  component 1.232818, 1.18881, <-0.194093, -0.232236, -0.025316>
  component 1.0, 0.716088, <-0.357806, -0.357806, 0.0>
  component 1.0, 1.035213, <-0.742616, -0.388186, 0.0>
  component 1.0, 0.654108, <-1.6, -0.546836, 0.0>
  component 1.0, 0.398153, <-2.032068, -0.614346, 0.0>
  component 1.0, 0.224834, <-0.21097, -0.725738, -0.632911>
  component 1.0, 0.224834, <-0.43038, -0.725738, -0.616034>
  component 1.0, 0.224834, <-0.556962, -0.725738, -0.57384>
  component 1.0, 0.224834, <-0.691983, -0.725738, -0.523207>
  component 1.0, 0.224834, <-1.046414, -0.725738, -0.421941>
  component 1.0, 0.224834, <-1.198312, -0.725738, -0.371308>
  component 1.0, 0.224834, <-1.350211, -0.725738, -0.371308>
  component 1.0, 0.224834, <-1.476793, -0.725738, -0.329114>
  component 1.0, 0.224834, <-1.654009, -0.725738, -0.320675>
  component 1.0, 0.224834, <-1.940928, -0.725738, -0.253165>
  component 1.0, 0.224834, <-1.822785, -0.725738, -0.28692>
  component 1.0, 0.224834, <-2.227848, -0.725738, -0.050633>
  component 1.0, 0.224834, <-2.126582, -0.725738, -0.168776>
  component 1.0, 0.224834, <-2.227848, -0.725738, 0.118143>
  component 1.0, 0.224834, <-2.059072, -0.725738, 0.202532>
  component 1.0, 0.224834, <-1.890295, -0.725738, 0.219409>
  component 1.0, 0.224834, <-1.721519, -0.725738, 0.28692>
  component 1.0, 0.224834, <-1.552743, -0.725738, 0.320675>
  component 1.0, 0.224834, <-1.383966, -0.725738, 0.337553>
  component 1.0, 0.224834, <-1.248945, -0.725738, 0.388186>
  component 1.0, 0.224834, <-1.130802, -0.725738, 0.405063>
  component 1.0, 0.224834, <-0.995781, -0.725738, 0.438819>
  component 1.0, 0.224834, <-0.843882, -0.725738, 0.489451>
  component 1.0, 0.224834, <-0.675106, -0.725738, 0.506329>
  component 1.0, 0.224834, <-0.371308, -0.725738, 0.607595>
  component 1.0, 0.224834, <-0.236287, -0.725738, 0.624473>
  component 1.0, 0.697202, <-1.329958, -0.465823, 0.0>
  component 1.0, 0.224834, <0.35443, -0.57384, -0.270042>
  component 1.0, 0.224834, <0.388186, -0.57384, -0.067511>
  component 1.0, 0.224834, <0.253165, -0.57384, -0.405063>
  component 1.0, 0.224834, <0.405063, -0.57384, 0.084388>
  component 1.0, 0.224834, <0.337553, -0.57384, 0.28692>
  component 1.0, 0.224834, <0.118143, -0.57384, -0.489451>
  component 1.0, 0.224834, <0.0, -0.57384, -0.523207>
  component 1.0, 0.224834, <-0.151899, -0.57384, -0.506329>
  component 1.0, 0.224834, <0.202532, -0.57384, 0.35443>
  component 1.0, 0.224834, <0.067511, -0.57384, 0.388186>
  component 1.260897, 0.676721, < %snailblob22 translate% >
  component 1.0, 0.564887, < %snailblob3 translate% >
  component 1.0, 0.531293, < %snailblob23 translate% >
  component 1.0, 0.789323, <-1.08692, -0.438819, 0.0>
  component 1.0, 0.536595, <-1.829536, -0.57384, 0.0>
  component 1.0, 0.224834, <-0.523207, -0.725738, 0.540084>
  component 1.0, 0.224834, <-0.945148, -0.725738, -0.438819>
  component 1.0, 0.224834, <-0.827004, -0.725738, -0.506329>
  component 1.0, 0.095983, < %snailblob4 translate% >
  component 1.0, 0.095983, < %snailblob5 translate% >
  component 1.0, 0.095983, < %snailblob6 translate% >
  component 1.0, 0.095983, < %snailblob7 translate% >
  component 1.0, 0.095983, < %snailblob8 translate% >
  component 1.0, 0.095983, < %snailblob9 translate% >
  component 1.0, 0.095983, < %snailblob10 translate% >
  component 1.0, 0.216588, < %snailblob11 translate% >
  component 1.0, 0.095983, < %snailblob12 translate% >
  component 1.0, 0.095983, < %snailblob13 translate% >
  component 1.0, 0.095983, < %snailblob14 translate% >
  component 1.0, 0.095983, < %snailblob15 translate% >
  component 1.0, 0.095983, < %snailblob16 translate% >
  component 1.0, 0.095983, < %snailblob17 translate% >
  component 1.0, 0.216588, < %snailblob18 translate% >

sturm
  texture {
    txtSnailBody
  }
  rotate 90.0*x
}

#declare GlassesCSG = difference {
  torus { // GlassesCenter
    1.5, 0.1  rotate -x*90
    scale 0.07
    rotate -90.0*y
  }
  box { // GlassesCut
    <-1, -1, -1>, <1, 1, 1>
    scale 0.15
    translate  -0.15*z
  }
  scale 0.496316
  translate  <1.544794, -0.024428, 2.591115>
}
#declare RightGlasses = union {
  torus { // RightEyeGlass
    1.5, 0.1  rotate -x*90
    scale 0.07
    rotate 90.0*y
    translate  <1.543957, -0.1813, 2.591751>
  }
  cylinder { // RtGlassesArm
    <0,0,1>, <0,0,0>, 1
    scale <0.007, 0.007, 0.404543>
    rotate <180.0, -89.070557, -180.0>
    translate  <1.542322, -0.076602, 2.592291>
  }
  translate  0.313129*y
}
#declare LeftGlasses = union {
  torus { // LeftEyeGlass
    1.5, 0.1  rotate -x*90
    scale 0.07
    rotate 90.0*y
    translate  <1.543957, -0.1813, 2.591751>
  }
  cylinder { // LftGlassesArmCy
    <0,0,1>, <0,0,0>, 1
    scale <0.007, 0.007, 0.404543>
    rotate <-180.0, -86.185425, -180.0>
    translate  <1.542322, -0.286126, 2.592291>
  }
}
#declare LeftEyeLidCSG = intersection {
  sphere { // LeftEyeLidSph
    <0,0,0>,1
    texture {
      txtSnailBody
    }
    scale <0.015229, 0.107196, 0.107614>
    translate  <0.850255, 0.131792, 1.656219>
  }
  box { // LeftEyeLidCut
    <-1, -1, -1>, <1, 1, 1>
    scale 0.113989
    translate  <0.84, 0.13, 1.88> + < %snaileyelid translate% >
  }
  texture {
    txtSnailBody
  }
  translate  <0.701413, 0.0, 0.935218>
}
#declare RightEyeLidCSG = intersection {
  sphere { // RightEyeLidSph
    <0,0,0>,1
    texture {
      txtSnailBody
    }
    scale <0.015529, 0.109308, 0.109734>
    translate  <0.850691, -0.181562, 1.656219>
  }
  box { // RightEyeLidCut
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1139
    translate  <0.84, -0.18, 1.88> + < %snaileyelid translate% > + <%snailwink translate% >
  }
  texture {
    txtSnailBody
  }
  translate  <0.701413, 0.0, 0.935218>
}
#declare Glasses1 = union {
  object { GlassesCSG }
  object { RightGlasses }
  object { LeftGlasses }
  sphere { // LeftEye
    <0,0,0>,1
    texture {
      txtEye
    }
    scale < %zlefteye scale% >
    translate  < %zlefteye translate% >
  }
  sphere { // RightEye
    <0,0,0>,1
    texture {
      txtEye
    }
    scale < %zrighteye scale% >
    translate  < %zrighteye translate% >
  }
  object { LeftPupil
    translate  < %snailpupil translate% >
  }
  object { // RightPupil->LeftPupil
    LeftPupil
    translate  < %snailpupil2 translate% > + < %snailpupil translate% >
  }
  object { LeftEyeLidCSG }
  object { RightEyeLidCSG }
  texture {
    txtGlasses
  }
  rotate  < %snailglasses rotate% >
  translate  < %snailglasses translate% >
}
#declare Shell = union {
  object { ShellHalf1 }
  object { // ShellHalf2->ShellHalf1
    ShellHalf1
    rotate <-180.0, 0.0, 0.0>
    translate  <0.0, -3.65311, 2.65652>
  }
  texture {
    txtShell
  }
  translate  <-0.700413, 1.776311, -0.935218>
}
union { // Snail
  object { SnailBody1 }
  object { Glasses1 }
  object { Shell }
  scale 0.025
  rotate 90.0*z
  translate  < %snail translate% >
}

#if ( %safe degrees% )
   #debug "Parcing safe - Steve\n"
   #include "safe.inc"
   union { // Safe
     object { SafeCSG1 }
     object { Hinge1 }
     object { Hinge2 }
     object { Knob }
     object { Handle }
     texture {
       txtSafe
       scale <3.8, 0.608, 3.8>
       rotate <90.0, 0.0, 45.0>
     }
     scale 0.3
     rotate < %safe rgb% >
     translate  < %safe translate% >
   }
   #debug "Finished parcing safe - Steve\n"
#else
   #debug "NOT parcing safe - Steve\n"
#end
