
// Glenn's Buildings POV-Ray Object File
// This file does not render.  #include "AFBuildings.inc" in another .pov file
// created 18-Mar-98  updated 12-Apr-98
// copyright 1998 Glenn McCarter

// A collection of various landscape elements
// Intended scale is English system (inches)

#declare DBldg1 =
	box {
		<0,0,0>,<60*Feet,50*Feet,22*Feet>
		texture { BrownRock }
	}
#declare DBldg2 =
	box {
		<0,0,0>,<160*Feet,90*Feet,17*Feet>
		texture { LtGreyRock }
	}
#declare DBldg3 =
	box {
		<0,0,0>,<50*Feet,70*Feet,33*Feet>
		texture { WhitePaint }
	}
#declare TallPole =
	cone {
		<0,0,0>,21,<0,0,60*Feet>,14
		texture { WhitePaint }
	}
#declare Tower =
	union {
		cone {
			<0,0,0>,18*Feet,<0,0,360*Feet>,3*Feet
		}
		cylinder {
			<0,0,0>,<0,0,11*Feet>,33*Feet
			translate <0,0,240*Feet>
		}
		cylinder {
			<0,0,0>,<0,0,11*Feet>,33*Feet
			translate <0,0,255*Feet>
		}
		texture { WhitePaint }
	}

#declare SmokeStack =
	cone {
		<0,0,0>,8*Feet,<0,0,120*Feet>,5*Feet
		texture { BrownRock }
	}

#declare Fence =
	box {
		<0,-2,0>,<300*Feet,2,6*Feet>
		texture { LtGreyRock }
	}

#declare SquareEnd =
	union {
		box {
			<-12,-12,0>,<12,12,7>
		}
		box {
			<-10,-10,0>,<10,10,11>
		}
		box { // main
			<-9,-9,0>,<9,9,77>
		}
		box {
			<-10,-10,76>,<10,10,80>
		}
		sphere {
			<0,0,87>,9
		}
		cylinder {
			<0,0,79>,<0,0,84>,5
		}
		texture { LtGreyRock }
	}

//Thanks to Jamie Vives for the material map technique used here.
#declare CastIronFenceTex =
texture {
	material_map{
		gif "QuikFence1.gif"
		texture { ClearTex }
		texture { Grey30Paint }
	}
}
#declare CastIronFence =
	height_field {
		gif "QuikFence1.gif"
		smooth
		rotate -90*x
		texture { CastIronFenceTex }      // maping the material_map on to the height_field
		rotate <90,0,90>
//		translate <0,-0.5,0>
		scale <20*Feet,20*Feet,8*Feet>
 }
