
// Glenn's POV-Ray Animation File - Air Freight master file
// created 6-Mar-98
// last update 29-Mar-98
// copyright 1998 Glenn McCarter

//#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//===============================================
//             Variables
//===============================================


/*
SCENES             TIME     30FPS                  24FPS
----------------   -----  --------------------    ---------
0  opening title   0 sec    0 frames    0 cum         0 cum
1  the crane       5 sec  150 frames  150 cum       120 cum
2  the tease       4 sec  120 frames  270 cum       216 cum
3a the liftoff 1   3 sec   90 frames  360 cum       288 cum
3b the liftoff 2   3 sec   90 frames  450 cum       360 cum
4a cruising        3 sec   90 frames  540 cum       432 cum fly
4b the express     4 sec  120 frames  660 cum       528 cum turn-in
4c the chase       2 sec   60 frames  720 cum       576 cum follow
4d the city        8 sec  240 frames  960 cum       768 cum climb up
5a the transfer    2 sec   60 frames 1020 cum       816 cum
5b lower in        2 sec   60 frames 1080 cum       864 cum
4e sky train      10 sec  300 frames 1380 cum      1104 cum
6  the climb    (deleted)
7  the docking     8 sec  240 frames 1620 cum      1296 cum
8a anticipation 1  3 sec   90 frames 1710 cum      1368 cum drop
8b anticipation 2  2 sec   60 frames 1770 cum      1416 cum grip
8c revelation 1    6 sec  180 frames 1950 cum      1560 cum extraction spline
9  revelation 2    7 sec  210 frames 2160 cum      1728 cum
10 the theme    (deleted)
11 credits         4 sec  120 frames 2280 cum      1824 cum
        TOTAL    76 sec 2280 frames
Initial_Clock = 0
Final_Clock = 2730
*/

#if ( clock <= 1020 )
	#if ( clock > 960 )
		#declare Sclock = (clock-960)/60 // scene clock goes from 0 to 1 within scene
		#include "Scene5a.pov"
	#end
#end
#if ( clock <= 1050 )
	#if ( clock > 1020 )
		#declare Sclock = (clock-1020)/30 // scene clock goes from 0 to 1 within scene
		#include "Scene5c.pov"
	#end
#end
