
// Glenn's Cargo POV-Ray Object File
// This file does not render.  #include "Cargo.inc" in another .pov file
// created 19-Mar-98  updated 5-Apr-98
// copyright 1998 Glenn McCarter

// Various crates, barrels, tarps
// Intended scale is English system (inches)


#declare DrumHt = 48
#declare DrumRad = 13
#declare FiftyFiveGallonDrum =
	union {
		cylinder { // main
			<.7,0,0>,<0,0,DrumHt>,DrumRad
		}
		torus { // top rim
			DrumRad,.4
			rotate x*90
			scale <1,1,2>
			translate <0,0,DrumHt>
		}
		torus { // middle lower
			DrumRad,.8
			rotate x*90
			scale <1,1,1>
			translate <0,0,DrumHt*1/3>
		}
		torus { // middle upper
			DrumRad,.8
			rotate x*90
			scale <1,1,1>
			translate <0,0,DrumHt*2/3>
		}
		torus { // bottom rim
			DrumRad,.4
			rotate x*90
			scale <1,1,2>
			translate <0,0,0>
		}
		texture { DullMetal }
	}

#declare Pallet =
	box {
		<-3*Feet,-3*Feet,0>,<3*Feet,3*Feet,5>
		texture { WhitePaint }
	}

#declare Strap =
	box {
		<0,-1.2,0>,<48,1.2,.36>
		texture { BrownRock }
	}

#declare TL = 20*Feet
#declare LongTube =
	union {
		difference { // main pipe
			cylinder {
				<11,0,0>,<TL-11,0,0>,2.6
			}
			cylinder {
				<-1,0,0>,<TL+1,0,0>,2.0
			}
		} // end difference
		difference { // end cap
			cylinder {
				<0,0,0>,<12,0,0>,3.2
			}
			cylinder {
				<-1,0,0>,<13,0,0>,2.6
			}
		} // end difference
		difference { // end cap
			cylinder {
				<TL,0,0>,<TL-12,0,0>,3.2
			}
			cylinder {
				<TL+1,0,0>,<TL-13,0,0>,2.6
			}
		} // end difference
		texture { DarkMetal }
	} // end union

//===============================================
//             Groups
//===============================================

#declare BarrelGroup =
	union {
		object { FiftyFiveGallonDrum translate < 12, 25,0> }
		object { FiftyFiveGallonDrum translate < 12, -8,0> }
		object { FiftyFiveGallonDrum translate <-12,  8,0> }
		object { FiftyFiveGallonDrum translate <-12,-25,0> }
	}

#declare BarrelsWithStraps =
	union {
		object { BarrelGroup }
		object { Strap scale <0.7,1,1> rotate <0,0,-90> translate <12,18,DrumHt+1> }
		object { Strap scale <0.7,1,1> rotate <0,0,-90> translate <-12,-8,DrumHt+1> }
		object { Strap scale <1.2,1,1> rotate <0,58,90> translate <12,25+DrumRad,DrumHt+1> }
		object { Strap scale <1.4,1,1> rotate <0,43,-90> translate <12,-8-DrumRad,DrumHt+1> }
		object { Strap scale <1.25,1,1> rotate <0,45,90> translate <-12,8+DrumRad,DrumHt+1> }
		object { Strap scale <1.4,1,1> rotate <0,58,-90> translate <-12,-25-DrumRad,DrumHt+1> }
	}

#declare TubeGroup3 =
	union {
		object { LongTube translate <0,3.6,3.2> }
		object { LongTube translate <0,-3.6,3.2> }
		object { LongTube translate <0,0,3.2+5> }
	}

