// Glenn's POV-Ray Standard Objects File - RH Coordinate System
// created 20-June-96
// last update 1-Nov-97
// copyright Glenn McCarter

// This file is intended to be a generic collection of
// useful objects.  Especially good for testing scenes --
// reference a few of these objects and see how things look.

#declare TestSphere =
    sphere {
    <0,.5,0>, .5
    texture { pigment {color LightGrey } }
    finish {ambient 0 diffuse 0 metallic specular 0.80 roughness 1/120 reflection .99 }
  }

// Table is defined with center of tabletop at <0,0,0>
// Legs extend 36 down
#declare TableTop =
   box {
     <-24,-15,-1>,<24,15,0>
        texture { GWood rotate z*90}
   }
#declare TableLeg =
   box {
     <-1,-1,-36>,<1,1,-1>
        texture { GWood rotate x*90}
   }
#declare Table =
   union {
     object { TableTop }
     object { TableLeg translate <-22.5,-13.5,0> }
     object { TableLeg translate <-22.5,13.5,0> }
     object { TableLeg translate <22.5,-13.5,0> }
     object { TableLeg translate <22.5,13.5,0> }

   }

#declare Jar =
  difference {
    merge {
      cylinder { // outside wall
        <0,0,.5>, <0,0,7.825>, 2
        texture { GGlass1 }
      }
      sphere { // bottom
        <0,0,0>, 2
        scale <1,1,.16>
        translate <0,0,.5>
        texture { GGlass1 }
      }
      torus { // top edge
        1.875, .125
        scale <1,1,1>
        translate <0,7.825,0>
        texture { GGlass1 }
      }
    }
    cylinder { // inner space
      <0,0,.5>, <0,0,9>, 1.75
      texture { GGlass1 }
    }
  }

// Paper Clip sitting on the Z=0 plane
#declare PaperClipWireDia = .05
#declare PCWR = PaperClipWireDia/2 //WireRadius
#declare PaperClip =
  union { //centerline at the origin, for now...
    cylinder { <0,0,0>, <.8,0,0>, PCWR translate <-.3,.14,0> } //outer end
    cylinder { <0,0,0>, <1,0,0>, PCWR translate <-.5,-.14,0> }  //longest
    cylinder { <0,0,0>, <.8,0,0>, PCWR translate <-.5,.14-PCWR*2,0> }  //shorter
    cylinder { <0,0,0>, <.6,0,0>, PCWR translate <-.3,-.1,0> }  //inside end
    object {torus { .14, PCWR }
      clipped_by{plane{-x,0}}
      rotate x*90
      translate <.5,0,0>
    }
    object {torus { (.14+.14-PCWR*2)/2, PCWR }
      clipped_by{plane{x,0}}
      rotate x*90
      translate <-.5,(-PCWR),0>
    }
    object {torus { (.14-PCWR*2+.1)/2, PCWR }
      clipped_by{plane{-x,0}}
      rotate x*90
      translate <.3,0,0>
    }
    texture { pigment {color LightGrey } }
    finish {ambient 0 diffuse 0 metallic specular 0.80 roughness 1/120 reflection .6 }
    translate <0,0,PCWR> //set it on the Z=0 surface
  }

// A simple pad of paper 8.5 x 11
#declare LargePad =
   box {
     <0,0,0>,<11,8.5,0.3>
     texture { PaperWhite }
   }
