// Glenn's POV-Ray Textures File
// created 20-June-96
// last update 26-Feb-98
// copyright Glenn McCarter

//------------- Colors -------------------

#declare White = rgb<1,1,1>
#declare Black = rgb<0,0,0>
#declare Red = rgb<1,0,0>
#declare Green = rgb<0,1,0>
#declare Blue = rgb<0,0,1>
#declare Yellow = rgb<1,1,0>
#declare LightGrey = rgb<.66,.66,.66>

//------------- Simple Textures -------------------

#declare WhiteTex = texture { pigment { color rgb<1,1,1> } normal { bumps .4} }
#declare BlackTex = texture { pigment { color rgb<0,0,0> } normal { bumps .4} }
#declare RedTex = texture { pigment { color rgb<1,0,0> } normal { bumps .4} }
#declare GreenTex = texture { pigment { color rgb<0,1,0> } normal { bumps .4} }
#declare BlueTex = texture { pigment { color rgb<0,0,1> } normal { bumps .4} }
#declare YellowTex = texture { pigment { color rgb<1,1,0> } normal { bumps .4} }
#declare LightGreyTex = texture { pigment { color rgb<.66,.66,.66> } normal { bumps .4} }

//------------- White Textures -------------------
#declare BrightWhite =
    texture {
      pigment { color <1,1,1> }
      finish { ambient .8 phong .6 }
    }

#declare WhitePaint =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient .2 specular .7 roughness .005 }
	}

#declare PaperWhite =
    texture {
      pigment { color <1,1,1> }
      finish { ambient .3 specular 0.3 roughness 0.6 }
    }

#declare TestWhite =
    texture {
      pigment { color <1,1,1> }
      finish { ambient .3 phong .6 }
    }

//------------- Black Textures -------------------

#declare BlackPaint =
	texture {
		pigment { Black }
		finish { ambient .2 specular .7 roughness .005 }
	}
#declare FlatBlack =
	texture {
		pigment { Black }
		finish { ambient 0 specular 0 roughness .005 }
	}

//------------- Chrome Textures -------------------

#declare MirrorTex =
	texture {
		pigment { Black }
		finish { ambient .00 reflection 1.0 }
	}

//------------- Glass Textures -------------------
#declare GGlass1 =
      texture {
        pigment { color rgbf<.95,.95,.95,.8> }
        finish {phong .6 phong_size 200
          refraction 1
          ior 1.5
          reflection .3
        }
      }

#declare GBlueGlass =
      texture {
        pigment { color rgbf<.88,.82,.98,.9> }
        finish {
          specular .85
          roughness .002
          refraction 1
          ior 1.5
          reflection .24
        }
      }

#declare GGoldGlass =
      texture {
        pigment { color rgbf<.88,.88,.68,.9> }
        finish {
          specular .8
          roughness .02
          refraction 1
          ior 1.5
          reflection .2
        }
      }

//------------- Wood Textures -------------------

//----------------------------------
// following wood stuff is from the
// POV-Ray include files.
//----------------------------------
#declare M_Wood1A =
color_map {
    [0.0, 0.1 color rgb <0.88, 0.60, 0.40>
              color rgb <0.88, 0.60, 0.40>]
    [0.1, 0.9 color rgb <0.88, 0.60, 0.40>
              color rgb <0.60, 0.30, 0.20>]
    [0.9, 1.0 color rgb <0.60, 0.30, 0.20>
              color rgb <0.60, 0.30, 0.20>]
}
#declare M_Wood1B =
color_map {
    [0.0, 0.1 color rgbf <0.55, 0.32, 0.20, 0.100>
              color rgbf <0.55, 0.32, 0.20, 0.500>]
    [0.1, 0.2 color rgbf <0.55, 0.35, 0.20, 0.650>
              color rgbf <0.88, 0.60, 0.40, 0.975>]
    [0.2, 0.3 color rgbf <0.88, 0.60, 0.40, 0.975>
              color rgbf <0.60, 0.30, 0.20, 1.000>]
    [0.3, 0.4 color rgbf <0.60, 0.30, 0.20, 0.100>
              color rgbf <0.60, 0.30, 0.20, 0.500>]
    [0.4, 0.9 color rgbf <0.60, 0.30, 0.20, 0.650>
              color rgbf <0.88, 0.60, 0.40, 0.975>]
    [0.9, 1.0 color rgbf <0.88, 0.60, 0.40, 0.975>
              color rgbf <0.55, 0.32, 0.20, 1.000>]
}
#declare P_WoodGrain1A =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
}
#declare P_WoodGrain1B =
pigment {
    wood
    turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>
    rotate <5, 10, 5>
    translate -x*2
}
// Natural oak (light)
#declare T_Wood1 =
    texture { pigment { P_WoodGrain1A  color_map { M_Wood1A }}}
    texture { pigment { P_WoodGrain1B  color_map { M_Wood1B }}}
//----------- end POV-Ray files -----------------------

#declare GWood =
      texture { T_Wood1
        scale 7
        finish {reflection .1}
      }

#declare GWoodCol1 =
color_map {
	[0.0 color rgb <0.88, 0.60, 0.40>]
	[0.1 color rgb <0.88, 0.60, 0.40>]
	[0.1 color rgb <0.88, 0.60, 0.40>]
	[0.9 color rgb <0.60, 0.30, 0.20>]
	[0.9 color rgb <0.60, 0.30, 0.20>]
	[1.0 color rgb <0.60, 0.30, 0.20>]
}
#declare GWoodCol2 =
color_map {
	[0.0 color rgbf <0.55, 0.32, 0.20, 0.100>]
	[0.1 color rgbf <0.55, 0.32, 0.20, 0.500>]
	[0.1 color rgbf <0.55, 0.35, 0.20, 0.650>]
	[0.2 color rgbf <0.88, 0.60, 0.40, 0.975>]
	[0.2 color rgbf <0.88, 0.60, 0.40, 0.975>]
	[0.3 color rgbf <0.60, 0.30, 0.20, 1.000>]
	[0.3 color rgbf <0.60, 0.30, 0.20, 0.100>]
	[0.4 color rgbf <0.60, 0.30, 0.20, 0.500>]
	[0.4 color rgbf <0.60, 0.30, 0.20, 0.650>]
	[0.9 color rgbf <0.88, 0.60, 0.40, 0.975>]
	[0.9 color rgbf <0.88, 0.60, 0.40, 0.975>]
	[1.0 color rgbf <0.55, 0.32, 0.20, 1.000>]
}
#declare GWoodColD1 = //darker
color_map {
	[0.0 color rgb <0.44, 0.30, 0.20>]
	[0.1 color rgb <0.44, 0.30, 0.20>]
	[0.1 color rgb <0.44, 0.30, 0.20>]
	[0.9 color rgb <0.30, 0.15, 0.10>]
	[0.9 color rgb <0.30, 0.15, 0.10>]
	[1.0 color rgb <0.30, 0.15, 0.10>]
}
#declare GWoodColD2 = //darker
color_map {
	[0.0 color rgbf <0.27, 0.16, 0.10, 0.100>]
	[0.1 color rgbf <0.27, 0.16, 0.10, 0.500>]
	[0.1 color rgbf <0.27, 0.17, 0.10, 0.650>]
	[0.2 color rgbf <0.44, 0.30, 0.20, 0.975>]
	[0.2 color rgbf <0.44, 0.30, 0.20, 0.975>]
	[0.3 color rgbf <0.30, 0.15, 0.10, 1.000>]
	[0.3 color rgbf <0.30, 0.15, 0.10, 0.100>]
	[0.4 color rgbf <0.30, 0.15, 0.10, 0.500>]
	[0.4 color rgbf <0.30, 0.15, 0.10, 0.650>]
	[0.9 color rgbf <0.44, 0.30, 0.20, 0.975>]
	[0.9 color rgbf <0.44, 0.30, 0.20, 0.975>]
	[1.0 color rgbf <0.27, 0.16, 0.10, 1.000>]
}
#declare WoodGrainPig1 =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
}
#declare WoodGrainPig2 =
pigment {
    wood
    turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>
    rotate <5, 10, 5>
    translate -x*2
}
#declare GWoodTex = //this is a layered texture
    texture { pigment { WoodGrainPig1  color_map { GWoodColD1 }}}
    texture { pigment { WoodGrainPig2  color_map { GWoodColD2 }}}

#declare Formica =
      texture { GWoodTex
        scale 7
        finish {ambient .02 reflection .1}
      }

#declare DarkCork =
texture {
    pigment {
        granite
        color_map {
            [0.00, 0.60 color rgb <0.43, 0.21, 0.032>
                        color rgb <0.48, 0.31, 0.10>]
            [0.60, 0.65 color rgb <0.35, 0.25, 0.05>
                        color rgb <0.35, 0.15, 0.05>]
            [0.65, 1.00 color rgb <0.40, 0.13, 0.06>
                        color rgb <0.45, 0.35, 0.05>]
        }
    }
    finish{
        specular 0.1
        roughness 0.5
    }
    scale 0.25     // Generally looks best scaled longer on one axis
}

