
// Glenn's Gantry Crane POV-Ray Object File
// This file does not render.  #include "GantryCrane.inc" in another .pov file
// created 9-Mar-98  updated 9-Mar-98
// copyright 1998 Glenn McCarter

// An overhead gantry crane for moving large shipping containers
// Intended scale is English system (inches)
// Crane sits on +Z plane, rolls in X direction

//===============================================
//             Textures
//===============================================

#declare CraneTex =
	texture {
		pigment { color rgb<.38,.40,.54> }
		normal { bumps .1 scale 4 }
		finish { ambient .1 diffuse .7 specular .3 roughness .12 }
	}

//===============================================
//             Objects
//===============================================

#declare Width = 50*Feet

#declare SupportAssy =
	union {
		box {
			<-30,-30,0>,<30,30,50*Feet>
			texture { CraneTex }
		}
	}
#declare CFoot =
	box {
		<-6*Feet,-4*Feet,0>,<6*Feet,4*Feet,5*Feet>
		texture { CraneTex }
	}
#declare CrossLink =
	box {
		<-6*Feet,-30,-44>,<6*Feet,30,44>
		texture { CraneTex }
	}
#declare OverheadAssy =
	difference {
		box {
			<-30,-Width-5*Feet,-50>,<30,Width+5*Feet,50>
		}
		box {
			<-33,-Width-6*Feet,-45>,<-24,Width+6*Feet,45>
		}
		texture { CraneTex }
	}

#declare GantryCrane =
	union {
		object { SupportAssy rotate <0,10,0> translate <-16*Feet,-Width,0> }
		object { SupportAssy rotate <0,-10,0> translate <16*Feet,-Width,0> }
		object { SupportAssy rotate <0,10,0> translate <-16*Feet, Width,0> }
		object { SupportAssy rotate <0,-10,0> translate <16*Feet, Width,0> }
		object { CFoot translate <-16*Feet,-Width,0> }
		object { CFoot translate < 16*Feet,-Width,0> }
		object { CFoot translate <-16*Feet, Width,0> }
		object { CFoot translate < 16*Feet, Width,0> }
		object { OverheadAssy translate <-6*Feet,0,50*Feet> }
		object { OverheadAssy translate < 6*Feet,0,50*Feet> }
		object { CrossLink translate <0,-Width,50*Feet> }
		object { CrossLink translate <0, Width,50*Feet> }
	}
