
// Glenn's HangarLights POV-Ray Object File
// This file does not render.  #include "HangarLights.inc" in another .pov file
// created 15-Mar-98  updated 15-Mar-98
// copyright 1998 Glenn McCarter

// Lighting for Hangar
// Intended scale is English system (inches), floor is +Z
// Origin in the middle of the floor

//===============================================
//             Lighting
//===============================================
/*
#declare OverHeadBulbs =
	union {
object {FadeBulb100Watt translate < -40*Feet, 0*Feet,48*Feet> }
object {FadeBulb100Watt translate <  40*Feet, 0*Feet,48*Feet> }
	}
*/
#declare Sun =
  light_source {
 	  <0,0,0>
//   	colour rgb <5.0, 4.0, 3.0> // blindingly bright
//   	colour rgb <3.7, 2.8, 2.0> // pretty darn bright
   	colour rgb <1.5, 1.2, .9> // fairly bright
//   	colour rgb <1, .8, .6> // rather dimmish
//		area_light <.2*Miles,0,0>,<0,.2*Miles,0> 3, 3
	}

#declare HotBulb =
  light_source {
 	  <0,0,0>
   	color rgb <3.6, 3.62, 4.1>
		fade_distance 6*Feet
		fade_power 1
	}
#declare OverHeadBulbs =
	union {
		object {HotBulb translate < -40*Feet, 0*Feet,48*Feet> }
		object {HotBulb translate <  40*Feet, 0*Feet,48*Feet> }
	}

#declare YellowBulb =
  light_source {
 	  <-46*Feet,-40*Feet,18*Feet>
   	color rgb <3.2, 3.12, 2.1>
		fade_distance 6*Feet
		fade_power 1
	}
//#object { YellowBulb }

#declare SpecialSpot =
	light_source
	{
		0*x                     // light's position (translated below)
		color rgb <1.4,1.4,1.4>       // light's color
		spotlight               // this kind of light source
		translate <22*Feet, -50*Feet, 8*Feet>
		point_at <0, 0, 5*Feet>      // direction of spotlight
		radius 25                // hotspot (inner, in degrees)
		tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
		falloff 38               // intensity falloff radius (outer, in degrees)
		fade_distance 16*Feet
		fade_power 1
	}

#object { SpecialSpot }

#declare FloodSpot =
	light_source
	{
		0*x                     // light's position (translated below)
		color rgb <1,1,1>       // light's color
//		spotlight               // this kind of light source
		translate <-33*Feet, 25*Feet, 6*Feet>
//		point_at <0, 0, 5*Feet>      // direction of spotlight
//		radius 45                // hotspot (inner, in degrees)
//		tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
//		falloff 68               // intensity falloff radius (outer, in degrees)
//		radius 145                // hotspot (inner, in degrees)
//		tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
//		falloff 168               // intensity falloff radius (outer, in degrees)
		fade_distance 16*Feet
		fade_power 1
	}

#object { FloodSpot }

