
// Glenn's Container POV-Ray Object File - OldTruck
// This file does not render.  #include "OlcTruck.inc" in another .pov file
// created 21Mar-98  updated 21-Mar-98
// copyright 1998 Glenn McCarter

// A junky old flying truck
// Intended scale is English system (inches)
// Truck sits on +X+Z plane, origin at ground level below truck
// at interface between bed and cab

//===============================================
//             Textures
//===============================================

#declare BodyTex =
	texture {
		pigment { color rgb<.20,.20,.84> }
		normal { bumps .1 scale 30 }
		finish { ambient .1 diffuse .7 specular 1.0 roughness .01 }
	}

//===============================================
//             Objects
//===============================================

#include "OldCab.pov"
#include "OldCabWshield.pov"
#declare OldCabAssy =
	union {
		object { OldCab texture { BodyTex } }
		object { WindShield texture { AFGoldGlass } }
		rotate <90,0,0>
		scale <60,60,60>
		translate <0,0,0>
	}


#declare BWidth = 12*Feet
#declare BLength = 40*Feet
#declare Bed =
	box {
		<-BLength,-BWidth/2,0>,<0,BWidth/2,4>
		texture { SteelTex }
	}
#declare BedChassis =
	union {
		box {
			<-BLength+18,-10,0>,<0,10,12>
			texture { SteelTex }
			translate <0,-3*Feet,0>
		}
		box {
			<-BLength+18,-10,0>,<0,10,12>
			texture { SteelTex }
			translate <0,3*Feet,0>
		}
	}
#declare FEngine =
	union {
		sphere {
			<0,0,0>,11
			scale <6,1,1>
			texture { BodyTex }
			clipped_by { box{<-5*Feet,-30,-30>,<5*Feet,30,30>}}
		}
		cylinder {
			<-5.3*Feet,0,0>,<5.3*Feet,0,0>,5
			texture { FlatBlack }
		}
	}
#declare REngine =
	object { FEngine scale 2.3 }

#declare Tractor =
	union {
		object { OldCabAssy translate <3*Feet,0,5*Feet> }
		object { FEngine scale 1.3 translate <-3*Feet,-BWidth/2-24,4*Feet> }
		object { FEngine scale 1.3 translate <-3*Feet,BWidth/2+24,4*Feet> }
		translate <4*Feet,0,0> // origin at pivot point
	}
#declare Trailer =
	union {
		object { Bed  translate <0,0,6*Feet> }
		object { BedChassis translate <0,0,5*Feet> }
		object { REngine translate <-20*Feet,-BWidth/2,3*Feet> }
		object { REngine translate <-20*Feet,BWidth/2,3*Feet> }
	}

#declare Truck =
	union {
		object { Tractor rotate z*8 }
		object { Bed  translate <0,0,6*Feet> }
		object { BedChassis translate <0,0,5*Feet> }
		object { REngine translate <-20*Feet,-BWidth/2,3*Feet> }
		object { REngine translate <-20*Feet,BWidth/2,3*Feet> }
	}
