
// Glenn's POV-Ray Animation File - Air Freight Scene 0, "Opening Title"
// created 13-Mar-98
// last update 19-Mar-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog=1
//#declare Sclock = 1.0 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

#declare SignPoint = <0,0,48>

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 50
	location SignPoint-<5*Feet,0,0>
  look_at SignPoint
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//	location <40*Feet,-90*Feet,6*Feet>
//	look_at <71*Feet,0,5*Feet>
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
object {FadeBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }



//===============================================
//             Environment
//===============================================

//#include "AFEnviron.inc"
//object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
//#include "City.inc"
//object { City translate <2*Miles,0,0> }
//object { GroundPlaneWhite }


//===============================================
//             Objects
//===============================================

#declare SignBackground =
	box {
		<0,0,0>,<1,6*Feet,4*Feet>
		translate <0.2,-3*Feet,-2*Feet>
		texture { FlatBlack }
//		texture { WhitePaint }
	}
#declare Lettering1 =
	text {
		ttf "c:\Windows\Fonts\ARIALBD.TTF",
		"AIR",
		.05,     // THICKNESS_FLOAT
		0       //OFFSET_VECTOR
//		texture { WhitePaint }
//		texture { BrightWhite }
		texture { BrightBlue }
		scale <12,8,1>
		rotate <90,0,-90>
		translate <0,0,0>
	}
#declare Lettering2 =
	text {
		ttf "c:\Windows\Fonts\ARIALBD.TTF",
		"FREIGHT",
		.05,     // THICKNESS_FLOAT
		0       //OFFSET_VECTOR
//		texture { WhitePaint }
		texture { AmbientWhite }
		scale <6,4,1>
		rotate <90,0,-90>
		translate <0,0,0>
	}
#declare Lettering3 =
	text {
		ttf "c:\Windows\Fonts\ARIAL.TTF",
		"by",
		.05,     // THICKNESS_FLOAT
		0       //OFFSET_VECTOR
//		texture { WhitePaint }
		texture { AmbientWhite }
		scale <2.8,2.5,1>
		rotate <90,0,-90>
		translate <0,0,0>
	}
#declare Lettering4 =
	text {
		ttf "c:\Windows\Fonts\ARIAL.TTF",
		"Glenn McCarter",
		.05,     // THICKNESS_FLOAT
		0       //OFFSET_VECTOR
//		texture { WhitePaint }
		texture { AmbientWhite }
		scale <3,2.6,1>
		rotate <90,0,-90>
		translate <0,0,0>
	}
#declare YBox =
	union {
	box {
		<0,0,0>,<.01,1,1>
		texture {
			pigment {
				gradient y
				color_map {
//					[0.00 color rgb<0,0,2> ] // ends visible
					[0.03 color rgb<0,0,0> ]
					[0.30 color rgb<0,0,0> ]
					[0.32 color rgb<1,1,1> ]
					[0.36 color rgb<1,1,1> ]
					[0.50 color rgbt<1,1,1,1> ]
					[0.97 color rgbt<1,1,1,1> ]
//					[1.00 color rgb<2,0,0> ] // ends visible
				}
			}
			finish { ambient .6 }
			scale 1
			translate <0,-1,0>
		}
	}
	box { // long black tail
		<0,-1,0>,<.01,0.01,1>
		texture { pigment { color rgb<0,0,0> } finish { ambient 0 } }
	}
	} // end union
#declare ZBox =
	union {
	box {
		<0,0,0>,<.01,1,1>
		texture {
			pigment {
				gradient z
				color_map {
//					[0.00 color rgb<0,0,2> ] // ends visible
					[0.03 color rgb<0,0,0> ]
					[0.35 color rgb<0,0,0> ]
					[0.36 color rgb<1,1,1> ]
					[0.39 color rgb<1,1,1> ]
					[0.48 color rgbt<1,1,1,1> ]
					[0.97 color rgbt<1,1,1,1> ]
//					[1.00 color rgb<2,0,0> ] // ends visible
				}
			}
			finish { ambient .6 }
			scale 1
			translate <0,-1,0>
		}
	}
	box { // long black tail
		<0,0,-1>,<.01,1,0.01>
		texture { pigment { color rgb<0,0,0> } finish { ambient 0 } }
	}
	} // end union
#declare Sign =
	union {
		object { SignBackground translate <0,0,0>}
		object { Lettering1 translate <-.1,14,(-Sclock*4)+8> } //Air
		object { Lettering2 translate <-.1,(-Sclock*7)+9,0> } //Freight
		object { Lettering3 translate <-.1,20,(-Sclock*4)-7> } //by
		object { Lettering4 translate <-.1,(Sclock*5)+11,-11> } //GMc
		object { ZBox scale <1,24,150> translate <-.5,-8,(-Sclock*130)-30> } //Air
		object { YBox scale <1,260,4> translate <-.4,(-Sclock*240)-00,-.5> } //Freight
		object { ZBox scale <1,4,150> translate <-.3,17,(-Sclock*250)+50> } //by
		object { YBox scale <1,-260,3> translate <-.2,(Sclock*300)-50,-11.6> } //GMc
	}


//===============================================
//             Object Placement
//===============================================

object { Sign translate SignPoint }
//object { SkyTrain rotate <0,18,0> translate FlyPoint+<0,0,0> }
//#declare FDist = 600*Miles
//object { FarStation translate <-FDist,0,FDist*.33> }
//object { SkyTrain }
