
// Glenn's POV-Ray Animation File - Air Freight Scene 3a, "The Liftoff 1"
// created 6-Mar-98
// last update 28-Mar-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog = 0
//#declare Sclock = .75 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 40
  location <6.5*Feet, -16*Feet, 3*Feet>
  look_at <9*Feet, -12*Feet, 4*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 40
//    direction z*50
  location <15*Feet, -16*Feet, 3*Feet>
  look_at <18*Feet, 0, 6*Feet>
  location <6*Feet, -16*Feet, 3*Feet>
  look_at <10*Feet, -12*Feet, 4*Feet>
//  location <68*Feet, -36*Feet, 23*Feet>
//  look_at <28*Feet, 0, 6*Feet>

  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare OrangeGlow =
	texture {
		pigment { color rgb<.99,.62,.01> }
		finish { ambient .8 diffuse .4 }
	}

//===============================================
//             Lighting
//===============================================

object {FadeBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
object {FadeBulb100Watt translate <-20*Feet,-24*Feet,14*Feet> }
// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <50*Feet, -11*Feet, 50*Feet> // <x y z> position of light
  point_at <50*Feet, -11*Feet, 0>      // direction of spotlight
  radius 45                // hotspot (inner, in degrees)
  tightness 30            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 68               // intensity falloff radius (outer, in degrees)
	fade_distance 10*Feet
	fade_power 1
}


//===============================================
//             Environment
//===============================================

#include "AFEnviron.inc"
object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
#include "AFBuildings.inc"

//===============================================
//             Objects
//===============================================

#include "Container.inc"
#include "Truck1.inc"
#include "Cranes.inc"

#declare Flame =
	light_source {
		<0,0,0>
		color rgb<.99,.74,.03>*Sclock*Sclock
		fade_distance 26
		fade_power 1
	}
#declare LoadedTruck =
	union {
		object { Truck }
		object { Flame translate <-29.0*Feet, 6*Feet,36> } // light
		object { Flame translate <-29.0*Feet,-6*Feet,36> } // light
		object { Base translate <-18*Feet,0,6*Feet+4.5> }
		object { Lid translate <-18*Feet,0,7*Feet-7> }
	}


//===============================================
//             Object Placement
//===============================================

object { LoadedTruck translate <46*Feet+(Sclock*Sclock*10),0,sin(Sclock*pi/2)*2*Feet> }

object { DBldg1 rotate z*0 translate <350*Feet,360*Feet,0> }
object { DBldg2 rotate z*0 translate <350*Feet,520*Feet,0> }
object { DBldg3 rotate z*30 translate <300*Feet,720*Feet,0> }
object { TallPole translate <340*Feet,520*Feet,0> }
object { TallPole translate <450*Feet,740*Feet,0> }
object { Tower translate <1280*Feet,2440*Feet,0> }
object { DBldg3 scale <2,2,.7> rotate z*-30 translate <560*Feet,1220*Feet,0> }

object { DBldg1 rotate z*0 translate <50*Feet,360*Feet,0> }
object { DBldg2 scale <2,2,1> translate <50*Feet,900*Feet,0> }
