
// Glenn's POV-Ray Animation File - Air Freight Scene 4e, "Sky Train"
// created 12-Mar-98
// last update 12-Mar-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog=0
//#declare Sclock = 0.36 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

// flypoint 528 feet/sec = 360 mph, 10 sec shot
#declare FlyPoint = <-6600*Feet,0,4400*Feet> // start point
	+<-cos(radians(18))*Sclock*10*200*Feet,0,sin(radians(18))*Sclock*10*200*Feet>


#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 50
	location <-7300*Feet,-48*Feet,4650*Feet>
  look_at FlyPoint+<0,0,20*Feet-Sclock*60*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//	location <40*Feet,-90*Feet,6*Feet>
//	look_at <71*Feet,0,5*Feet>
//  location FlyPoint+<-8*Feet,-3*Feet,440*Feet> // overhead train
//  location FlyPoint+<-88*Feet,-44*Feet,12*Feet>
	location <-7300*Feet,-48*Feet,4650*Feet>
  look_at FlyPoint+<0,0,20*Feet-Sclock*60*Feet>
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
//object {StdBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }



//===============================================
//             Environment
//===============================================

#include "AFEnviron.inc"
object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
#include "AFCity.inc"
object { City translate <2*Miles,0,0> }
//object { GroundPlaneWhite }
sky_sphere {
    pigment {
      gradient z
      color_map {
        [ 0.50  color rgb<.99,.99,.99> ]
        [ 0.54  color rgb<.22,.22,.65> ]
        [ 0.80  color rgb<.02,.02,.10> ]
      }
      scale 2
      translate -1
    }
  }



//===============================================
//             Objects
//===============================================

#include "SkyTrain.inc"

#declare FarStation =
	union {
		box { <-.3,-1.2,-.1>,<.3,1.2,.1> translate <0,0,-.3> texture { WhitePaint }}
		box { <-.3,-1.2,-.1>,<.3,1.2,.1> translate <0,0,.3> texture { WhitePaint }}
		box { <-.3,-.06,-.1>,<.3,.06,.1> texture { BrightWhite }}
		box { <-.3,-.06,-.03>,<.3,.06,.03> translate <0,-.4,0> texture { BrightWhite }}
		box { <-.3,-.06,-.03>,<.3,.06,.03> translate <0,.4,0> texture { BrightWhite }}
		scale 10*Miles
	}

//===============================================
//             Object Placement
//===============================================

object { SkyTrain rotate <0,18,0> translate FlyPoint+<-86*Feet,4*Feet,15*Feet> }
#declare FDist = 600*Miles
object { FarStation translate <-FDist,0,FDist*.33> }
//object { SkyTrain }
