
// Glenn's POV-Ray Animation File - Air Freight Scene 5a, "The Transfer"
// created 9-Mar-98
// last update 10-Apr-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog = 0
//#declare Sclock = 1.0 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 50
  location <-8*Feet, -8*Feet, 1*Feet>
//  look_at <6*Feet+Sclock*2*3*Feet,0,(8*Feet+Sclock*1.2*Feet)>
  look_at <9*Feet,0,8.5*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
  location <-120*Feet, -120*Feet, 60*Feet>
  look_at <0,0,0>
  location <-66*Feet, -88*Feet, 400*Feet> // chopper view
  look_at <2*Feet,0,4*Feet>
  location <-66*Feet, -38*Feet, 100*Feet> // down the street
  look_at <100*Feet,0,24*Feet>
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

//object {FadeBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
//object {FadeBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }



//===============================================
//             Environment
//===============================================

#include "AFEnviron.inc"
object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
#include "AFCity.inc"
object { City translate <50*Feet,-50*Feet,-22> }

//===============================================
//             Objects
//===============================================

#include "Container.inc"
#include "GantryCrane.inc"
#include "Truck1.inc"
#include "Cargo.inc"
#include "SkyTrain.inc"

#declare Traverse =
	difference {
		box {
			<-3*Feet,-13*Feet,-66>,<3*Feet,13*Feet,66>
			texture { BrightMetal scale .1 }
		}
		box {
			<-2*Feet,-11*Feet,-76>,<2*Feet,11*Feet,-46>
			texture { DullMetal }
		}
	}
#declare Cable =
	cylinder {
		<0,0,0>,<0,0,22*Feet>,1.58
		texture { BlackPaint }
	}
#declare MagClamp =
	cylinder {
		<0,0,0>,<0,0,12>,12
		texture { BrightMetal }
	}
#declare CableGroup =
	union {
		object { Traverse translate <0,0,49*Feet> }
		object { MagClamp translate <0,8*Feet,28*Feet> }
		object { MagClamp translate <0,-8*Feet,28*Feet> }
		object { Cable translate <0,8*Feet-9,28*Feet> }
		object { Cable translate <0,8*Feet+9,28*Feet> }
		object { Cable translate <-7,8*Feet,28*Feet> }
		object { Cable translate <0,-8*Feet-9,28*Feet> }
		object { Cable translate <0,-8*Feet+9,28*Feet> }
		object { Cable translate <-7,-8*Feet,28*Feet> }
	}
#declare LoadedTrailer =
	union {
		object { Trailer }
		object { Base translate <-16*Feet,0,6*Feet+4.5> }
		object { Lid translate <-16*Feet,0,7*Feet-7> }
	}

#declare CrateTruck =
	union {
		object { LoadedTrailer translate <0,0,2*Feet> }
		object { Tractor translate <0,0,2*Feet> }
	}
#declare CargoTruck =
	union {
		object { Trailer translate <0,0,2*Feet> }
		object { Tractor translate <0,0,2*Feet> }
		object { BarrelsWithStraps translate <-10*Feet,0,8*Feet+4> }
		object { TubeGroup3 translate <-35*Feet,-44,8*Feet+4> }
	}

#declare EmptyTruck =
	union {
		object { Trailer translate <0,0,2*Feet> }
		object { Tractor translate <0,0,2*Feet> }
	}


//===============================================
//             Object Placement
//===============================================

#declare PartialClock = Sclock*0.9
#declare Pclock = PartialClock

//object { EmptyTruck translate FlyPoint+<168*Feet,-30*Feet,-6*Feet>+<Sclock*8*64*Feet,0,0> }
//object { CrateTruck translate <66*Feet+(Pclock*Pclock-1)*16*Feet,20*Feet,0> }

object { CrateTruck translate <50*Feet+(Sclock*20*Feet-Pclock*Pclock*6*Feet),20*Feet,0> }
object { GantryCrane translate <68*Feet,0,0> }
//object { ContainerAssy rotate z*0 translate <42*Feet+Sclock*2*18*Feet,12*Feet-Sclock*12*Feet,18*Feet> }
object { CableGroup translate <68*Feet,2*Feet+Sclock*12*Feet,0> }

