
// Glenn's POV-Ray Animation File - Air Freight Scene 7, "The Docking"
// created 15-Mar-98
// last update 4-Apr-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
//#declare Sclock = .8 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================

#declare LookAtPoint = <-6*Feet,0,5*Feet>+<Sclock*12*Feet,0,0>

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 45
  location <-13*Feet,-13*Feet,6*Feet>
  look_at LookAtPoint
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
  location <-13*Feet, -13*Feet, 6*Feet>
  look_at <0*Feet,0,4*Feet>
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare ShimmerTex =
	texture {
		pigment {
			gradient y
//			bozo
			color_map {
				[ 0.00 color rgbt<.4,.4,.9,.7> ]
				[ 1.00 color rgbt<.2,.2,.8,.9> ]
			}
			scale 12
//			scale <10,10,30>
		}
		finish { ambient .2 }
	}

//===============================================
//             Lighting
//===============================================

object {FadeBulb100Watt translate <40*Feet,-8*Feet,10*Feet> }
//object {StdBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }

#declare Sun =
  light_source {
 	  <0,0,0>
//   	colour rgb <5.0, 4.0, 3.0> // blindingly bright
//   	colour rgb <3.7, 2.8, 2.0> // pretty darn bright
   	colour rgb <1.5, 1.2, .9> // fairly bright
//   	colour rgb <1, .8, .6> // rather dimmish
//		area_light <.2*Miles,0,0>,<0,.2*Miles,0> 3, 3
	}

#declare RotoCone =
	union {
		cone {
			<0,0,0>,2.3,<0,0,7>,3.5
			texture {
				pigment { color rgb<1,1,.4> }
				finish { ambient .8 specular .9 roughness .002 }
			}
		}
		cylinder { // support
			<0,0,5>,<0,0,44>,1.5
			texture { VChromeTex }
		}
		sphere {
			<4,0,0>,2.2
			texture { VChromeTex }
		}
	}
#declare RotoSpot =
	light_source
	{
		<0,0,0>                     // light's position (translated below)
		color rgb <0.8,.8,.2>     // light's color
		spotlight               // this kind of light source
		point_at <4*Feet, 0, 0>      // direction of spotlight
		radius 60                // hotspot (inner, in degrees)
		tightness 2            // tightness of falloff (1...100) lower is softer, higher is tighter
		falloff 90               // intensity falloff radius (outer, in degrees)
		fade_distance 16*Feet
		fade_power 1
		looks_like { object { RotoCone } }
	}
//#declare RotoSpot = object { TestSphere scale 50 }
//object { RotoSpot rotate z*(30+Sclock*360*4.8) translate <12*Feet,15.5*Feet,11*Feet> }
//object { RotoSpot rotate z*(210+Sclock*360*4.8) translate <12*Feet,15.5*Feet,11*Feet> }

//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black
object { Sun rotate <0,0,40> translate <20000*Miles,7000*Miles,24000*Miles> }
#include "BigEarth.inc"
#declare HighView =
	union {
		object { Plain scale 5 rotate y*12 rotate z*45 translate <4*Miles,2*Miles,-6*Miles>+<-Sclock*4/7*4*Miles,-Sclock*2*Miles,0> }
		object { Clouds scale 20 rotate y*12 rotate z*45 translate <4*Miles,2*Miles,-6*Miles+1200*Feet>+<-Sclock*4/7*4*Miles,-Sclock*2*Miles,0> }
		object { FadeOut rotate z*45 translate <46*Miles,46*Miles,-16*Miles>}
	}
object { HighView rotate <0,-1,0> }

//===============================================
//             Objects
//===============================================

//#include "Container.inc"
//#include "GantryCrane.inc"
#include "SkyTrain.inc"

#declare HangarOpening =
	union {
		difference {
			box { // outer main
				<0,-21*Feet,0>,<120*Feet,21*Feet,12*Feet>
				texture { Grey80Paint }
			}
			box { // inner
				<-1,-19*Feet,1*Feet>,<118*Feet,19*Feet,11*Feet>
				texture { FreshWhite }
			}
		} // end difference
		box { // underside
			<0,-20*Feet,-6*Feet>,<20,20*Feet,1.2*Feet>
			translate <12*Feet,0,0>
			texture { Grey50Paint }
		}
		cylinder { // entrance
			<0,0,0>,<0,0,12*Feet>,1.2*Feet
			texture { BrightWhite }
			translate <6*Feet,19*Feet,0>
		}
		cylinder { // top
			<0,0,0>,<120*Feet,0,0>,.7*Feet
			texture { BlueLightTex }
			translate <3*Feet,4*Feet,11*Feet>
		}
		cylinder { // top
			<0,0,0>,<120*Feet,0,0>,.7*Feet
			texture { BlueLightTex }
			translate <3*Feet,-4*Feet,11*Feet>
		}
		box { // office support
			<1*Feet,-3*Feet,0>,<14*Feet,3*Feet,2*Feet>
			translate <14*Feet,14*Feet,9.9*Feet>
			texture { Grey80Paint }
		}
		difference {
			box { // office
				<0,-4*Feet,0>,<16*Feet,4*Feet,4*Feet>
				texture { WhitePaint }
			}
			box { // inner
				<2,-3.6*Feet,4>,<16*Feet-2,3.6*Feet,4*Feet-2>
				texture { BrightWhite }
			}
			box { // end window
				<-2,-3.4*Feet,1.4*Feet>,<1*Feet-2,3.4*Feet,4*Feet-8>
				texture { Grey80Paint }
			}
			box { // side window
				<11,-5*Feet,1.4*Feet>,<8*Feet,3*Feet,4*Feet-8>
				texture { Grey80Paint }
			}
			translate <14*Feet,14*Feet,6*Feet>
		} // end difference
		difference {
			box { // landing light holder
				<-12.5*Feet,-39,-18><8*Feet,39,5>
				texture { Grey80Paint }
			}
			box { // light holder
				<-14*Feet,-35,-22><9*Feet,35,1>
				texture { Grey80Paint }
			}
		}
/*
		box { // shimmering curtain
			<8,0*Feet,0*Feet><8.2,42*Feet,12*Feet>
			translate <0,-21*Feet,0>
			texture { ShimmerTex }
		}
*/
	} // end union

// Pulse Parameters
#declare TotalFrames = 240 // total frames in this anim segment
#declare OnLength = 8  // frames "on"
#declare CycleTime = 90 // repeat after this many frames
#declare ThisFrame = Sclock*TotalFrames
#declare Offset = 32 // start point of first cycle
#declare NumLights = 10
#declare Xdist = 12
#include "Flasher.pov"

#declare BlinkLights =
	union {
#declare XC = 0
#while ( XC < NumLights )
//	#warning concat("\n","ThisFrame=",str(ThisFrame,3,1))
	#declare LocalOffset = XC*CycleTime/(NumLights+1)+Offset
	#if (LocalOffset > CycleTime )
		#declare LocalOffset = LocalOffset - CycleTime
//		#warning concat("\n","LO was negative!"," ")
	#end
	#declare ThisCycleFrame = mod(ThisFrame,CycleTime)-LocalOffset
	#if (ThisCycleFrame < 0 )
		#declare ThisCycleFrame = CycleTime + ThisCycleFrame
//		#warning concat("\n","TCF was negative!"," ")
	#end
//		#warning concat("\n","LocalOffset=",str(LocalOffset,3,1)," ") //40 to 105
//		#warning concat("\n","ThisCycleFrame=",str(ThisCycleFrame,3,1),"\n ") //75.6
	#if (ThisCycleFrame < OnLength )
		object { BrightLight translate <XC*Xdist,0,0> } #declare XC=XC+1
	#else
		object { DimLight translate <XC*Xdist,0,0> } #declare XC=XC+1
	#end
#end // while
	} // end union

#declare DockingStation =
	union {
		object { BlinkLights translate <-6*Feet,0,0> }
		object { HangarOpening translate <6*Feet,0,20> }
	}


//===============================================
//             Object Placement
//===============================================

//object { ContainerAssy rotate z*90 translate <12*Feet+Sclock*2*18*Feet,0,18*Feet> }

object { DockingStation }
object { SkyTrain scale .25 rotate z*180 translate <12*Feet+Sclock*8*3*Feet,0,5*Feet> }
