
// Glenn's POV-Ray Animation File - Air Freight Scene 8b, "Anticipation 2 - The Clamp"
// created 15-Mar-98
// last update 2-Apr-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
//#declare Sclock = 1.0 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 45
  location <-7.0*Feet, 14*Feet, 3*Feet> // render view
  look_at <-6*Feet,8*Feet,4.5*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//
// AIRPLANE VIEWS:
//
//  location <-12*Feet, -12*Feet, 8*Feet> // center focus
//  look_at <0*Feet,0,4*Feet>
//  location <-6*Feet, -16*Feet, 8*Feet> // near side
//  look_at <0*Feet,0,4*Feet>
//  location <6*Feet, -46*Feet, 12*Feet> // far side
//  look_at <0*Feet,0,4*Feet>
//  location <-38*Feet, -1*Feet, 12*Feet> // front
//  look_at <0*Feet,0,4*Feet>
//  location <26*Feet, -16*Feet, 12*Feet> // back
//  look_at <0*Feet,0,4*Feet>
//  location <-36*Feet, -22*Feet, 13*Feet> // overall 3/4 showoff
//  look_at <0*Feet,0,4*Feet>
//  location <-26*Feet, -18*Feet, 6*Feet> // render view
//  look_at <0*Feet,0,5*Feet>
//  location <-26*Feet, -5*Feet, 6*Feet> // side
//  look_at <0*Feet,0,5*Feet>
//RENDER VIEWS:
//  location <-22*Feet, 32*Feet, 16*Feet> // overview
//  look_at <-7*Feet,8*Feet,8*Feet>
//  location <-12*Feet, 22*Feet, 3*Feet> // back
//  look_at <-7*Feet,8*Feet,4*Feet>
  location <-7.0*Feet, 14*Feet, 3*Feet> // render view
  look_at <-6*Feet,8*Feet,4.5*Feet>
//  location <-8.7*Feet, 10*Feet, 5.4*Feet> // extreme closeup
//  look_at <-6*Feet,8*Feet,5*Feet>
//  look_at <0,0,0>
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

//object {StdBulb100Watt translate <-30*Feet,-48*Feet,30*Feet> }
//object {FadeBulb60Watt translate <-20*Feet,-5*Feet,12*Feet> }
#include "HangarLights.inc"

#declare Sun =
  light_source {
 	  <0,0,0>
//   	colour rgb <5.0, 4.0, 3.0> // blindingly bright
//   	colour rgb <3.7, 2.8, 2.0> // pretty darn bright
   	colour rgb <1.5, 1.2, .9> // fairly bright
//   	colour rgb <1, .8, .6> // rather dimmish
//		area_light <.2*Miles,0,0>,<0,.2*Miles,0> 3, 3
	}

//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black
//object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }

//===============================================
//             Objects
//===============================================

#include "Hangar.inc"
#include "RobotArm.inc"
#include "Container.inc"
#include "SkyTrain.inc"
#include "WrightFlyer.inc"

#declare ClampingCylLH =
	cylinder {
		<-8,0,0>,<20,0,0>,3
		texture { VChromeTex }
		translate <-Sclock*15,0,2>
	}
#declare ClampingCylRH = object { ClampingCylLH scale <-1,1,1> }

#declare JetWay =
	box {
		<-3*Feet,-50*Feet,0>,<3*Feet,0,7*Feet>
		texture { Grey80Paint }
	}
#declare OrbitalStation =
	union {
		object { Hangar }
		object { SkyTrain scale 2 translate <90*Feet,90*Feet,2*Feet> }
		object { JetWay translate <100*Feet,90*Feet,6*Feet> }
	}


//===============================================
//             Object Placement
//===============================================

object { Base rotate z*0 translate <0,0,0> }
object { SupportBlocks rotate z*0 translate <0,0,0> }
/*
object { RobotArmLH translate < 7*Feet,-8*Feet,5*Feet> } // other side
object { ClampingCylLH translate < 7*Feet,-8*Feet,5*Feet> }
object { RobotArmRH translate <-7*Feet,-8*Feet,5*Feet> }
object { ClampingCylRH translate <-7*Feet,-8*Feet,5*Feet> }
*/
object { RobotArmLH translate < 7*Feet, 8*Feet+6,5*Feet+3-sin(Sclock*pi/2)*3> } // this side
object { ClampingCylLH translate < 7*Feet, 8*Feet+6,5*Feet+3-sin(Sclock*pi/2)*3> }
object { RobotArmRH translate <-7*Feet, 8*Feet+6,5*Feet+3-sin(Sclock*pi/2)*3> }
object { ClampingCylRH translate <-7*Feet, 8*Feet+6,5*Feet+3-sin(Sclock*pi/2)*3> }


object { Lid rotate z*0 translate <0,0,0> }

object { OrbitalStation }
object { OverHeadBulbs translate <HL*2/3,HW,0> }
object { WrightFlyer translate <-18,0,24> rotate z*90 }
