
// Glenn's POV-Ray Animation File - Air Freight Scene 9, "Revelation 2"
// created 21-Mar-98
// last update 5-Apr-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog = 0
//#declare Sclock = .14 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================

/*
#declare Tclock=0
#while ( Tclock < 1 )
// following goes from 0 to 1, easing at both ends:
#declare EaseClock = (sin(Tclock*pi+3*pi/2)+1)*.5
//#debug "This is one line.\nBut this is another"
#debug concat("Tclock is ", str(Tclock,3,2),"  EaseClock is ", str(EaseClock,3,2),"\n")
#declare Tclock = Tclock + .1
#end
*/
#declare EaseClock = (sin(Sclock*pi+3*pi/2)+1)*.5

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>

	angle (37-Sclock*8) // final 29
//camera finish location Scene8c: <-18*Feet, -28*Feet, 12*Feet>
  location <
		-18*Feet-EaseClock*2000*Feet,
		-28*Feet-EaseClock*2000*Feet,
		 12*Feet+EaseClock*800*Feet
	>
  look_at <0,0*Feet,4.5*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
  location <-26*Feet, -5*Feet, 6*Feet> // side
  look_at <0*Feet,0,5*Feet>
  location <-286*Feet, -148*Feet, 56*Feet> // garden
  look_at <-140*Feet,0,-35*Feet>
  location <-286*Feet, -148*Feet, 56*Feet> // front wall
  look_at <-140*Feet,0,-0*Feet>
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

//object {StdBulb100Watt translate <50*Feet,-48*Feet,10*Feet> }
object {FadeBulb60Watt translate <-200*Feet,120*Feet,-40*Feet> }

#declare Sun =
  light_source {
 	  <0,0,0>
//   	color rgb <5.0, 4.0, 3.0> // blindingly bright
//   	color rgb <3.7, 2.8, 2.0> // pretty darn bright
//   	color rgb <1.5, 1.2, .9> // fairly bright - original
   	color rgb <1.3, 1.2, 1.1>*.9 // fairly bright - whiter
//   	color rgb <1, .8, .6> // rather dimmish
//		area_light <.2*Miles,0,0>,<0,.2*Miles,0> 3, 3
	}


//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black

#if ( Sclock > .20 )
	object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
	#include "BigEarth.inc"
	#declare HighView =
		union {
			object { Plain scale 5 rotate y*12 rotate z*45 translate <0,0,-6*Miles>+<Sclock*4*Miles,Sclock*2*Miles,0> }
			object { Clouds scale 20 rotate y*12 rotate z*45 translate <0,0,-6*Miles+1200*Feet>+<Sclock*4*Miles,Sclock*2*Miles,0> }
			object { FadeOut rotate z*45 translate <46*Miles,46*Miles,-16*Miles>}
		}
	object { HighView rotate <0,-5,0> }
#end

//===============================================
//             Objects
//===============================================

#switch ( Sclock )
#range ( 0,.27 )
	#include "Hangar.inc"
	#include "HangarLights.inc"
	#include "RobotArm.inc"
	#include "Container.inc"
	#include "SkyTrain.inc"
	#include "WrightFlyer.inc"
	#include "BigPlatform.inc"
	#declare JetWay =
		box {
			<-3*Feet,-50*Feet,0>,<3*Feet,0,7*Feet>
			texture {Grey80Paint }
		}
	#declare OrbitalStation =
		union {
			object { Hangar }
			object { SkyTrain scale 2 translate <90*Feet,90*Feet,2*Feet> }
			object { JetWay translate <100*Feet,90*Feet,6*Feet> }
			object { OverHeadBulbs translate <HL*2/3,HW,0> }
			object { Base rotate z*0 translate <0,0,0> }
			object { SupportBlocks rotate z*0 translate <0,0,0> }
			object { Lid rotate z*0 translate <0,0,9*Feet+Sclock*9*Feet> }
			object { RobotArmClampedRH translate <-7*Feet,-8*Feet-6,14*Feet+Sclock*9*Feet> }
			object { RobotArmClampedLH translate < 7*Feet,-8*Feet-6,14*Feet+Sclock*9*Feet> }
			object { RobotArmClampedRH translate <-7*Feet, 8*Feet+6,14*Feet+Sclock*9*Feet> }
			object { RobotArmClampedLH translate < 7*Feet, 8*Feet+6,14*Feet+Sclock*9*Feet> }
			object { WrightFlyer translate <-18,0,24> rotate z*90 }
			object { BigPlatform translate <-150*Feet,120*Feet,0> }
		}
#break
#range ( .270001,.7 )
	#include "BigPlatform.inc"
	#include "Hangar.inc"
	#include "HangarLights.inc"
	#include "Container.inc"
	#include "WrightFlyer.inc"
	#declare OrbitalStation =
		union {
			object { BigPlatform translate <-150*Feet,120*Feet,0> }
			object { Floor }
			object { Base rotate z*0 translate <0,0,0> }
			object { WrightFlyer translate <-18,0,24> rotate z*90 }
		}
#break
#else
	#include "BigPlatform.inc"
	#include "Hangar.inc"
	#include "HangarLights.inc"
	#declare OrbitalStation =
		union {
			object { BigPlatform translate <-150*Feet,120*Feet,0> }
			object { Floor }
		}
#end

//===============================================
//             Object Placement
//===============================================


object { OrbitalStation }


