
// Glenn's FlyingTruck POV-Ray Object File
// This file does not render.  #include "Truck1.inc" in another .pov file
// created 7-Mar-98  updated 28-Mar-98
// copyright 1998 Glenn McCarter

// A flying truck:
// Tractor (simple version)
// Trailer (flatbed)
// Truck (includes Tractor and Trailer)
//
// Intended scale is English system (inches)
// Truck sits on +X+Z plane, origin at ground level below truck
// at interface between bed and cab

//===============================================
//             Textures
//===============================================

#declare BodyTex =
	texture {
		pigment { color rgb<.20,.20,.84> }
		normal { bumps .1 scale 30 }
//		finish { ambient .1 diffuse .7 specular 1.0 roughness .01 }
		finish { ambient .1 diffuse .7 specular 1.0 roughness .01 reflection .11}	}


//===============================================
//             Objects
//===============================================

#include "GravJet1.pov"

//----------------- Trailer ---------------------

#declare BWidth = 12*Feet
#declare BLength = 40*Feet
#declare Bed =
	box {
		<-BLength,-BWidth/2,0>,<0,BWidth/2,4>
		texture { SteelTex }
	}
#declare BedChassisBox =
	difference {
		box {
			<-BLength+18,-10,0>,<0,10,12>
			texture { SteelTex }
		}
		box {
			<-BLength+17,-9,1>,<1,9,11>
			texture { SteelTex }
		}
	}
#declare EngineSupport =
	union {
		box {
			<-27*Feet,-33,-28>,<-8*Feet,33,12>
			texture { DullMetal }
		}
		cylinder {
			<0,-5.6*Feet,0>,<0,5.6*Feet,0>,48
			scale <1,1,.18>
			translate <-25*Feet,0,-24>
			texture { DullMetal }
		}
	}
#declare BedChassis =
	union {
		object { BedChassisBox translate <0,-3*Feet,0> }
		object { BedChassisBox translate <0, 3*Feet,0> }
		object { EngineSupport translate <0,0,0> }
	}
#declare TailLight =
	union {
		cylinder {
			<0,0,0>,<2,0,0>,2.5
			texture { RedPlastic }
		}
		cylinder {
			<1.9,0,0>,<4,0,0>,2.6
			texture { FlatBlack }
		}
		box { // support
			<3,-2,-1>,<8,2,5>
			texture { FlatBlack }
		}
	}

//===============================================
//             Tractor
//===============================================

//----------------- Accessories ---------------------

#declare FrontScoop =
	union {
		torus {
			30,3
			rotate z*90
			texture { BodyTex }
		}
		cylinder {
			<0,0,0>,<1,0,0>,30
			texture { FlatBlack }
		}
		scale <3,1,.2>
	}

#declare Headlamp =
	union {
		sphere {
			<0,0,0>,3
			texture { BodyTex }
		}
	}

//----------------- Main Components ---------------------

#declare WindShield =
	intersection {
		sphere {
			<0,0,0>,5*Feet
			scale <1.7,1,.6>
		}
		sphere {
			<0,0,0>,4.95*Feet
			scale <1.7,1,.6>
			inverse
		}
		box {
			<3.5*Feet,-6*Feet,-6>,<12*Feet,6*Feet,2.0*Feet>
		}
//		texture { WhitePaint }
		texture { AFClearGlass }
	}
		
#declare CabShape = // +X to the front
	union { // add body color components
		intersection { // cut off rear
			difference { // hollow out cab
				sphere { // main
					<0,0,0>,5*Feet
					scale <1.7,1,.6>
					texture { BodyTex }
				}
				intersection {
					sphere { // hollow out
						<0,0,0>,4.4*Feet
						scale <1.7,1,.6>
						texture { BodyTex }
					}
					box {
						<2,-5*Feet,-5*Feet>,<12*Feet,5*Feet,5*Feet>
						texture { BodyTex }
					}
				} //end inner intersection
				box { // windshield cutout
					<3.5*Feet,-6*Feet,-6>,<12*Feet,6*Feet,2.0*Feet>
					texture { DullBlack }
				}
			} // end difference
			box { // cutoff rear
				<0,-88,-88>,<12*Feet,88,88>
				texture { BodyTex }
			}
		} // end intersection
		box { // bottom
			<-12*Feet,-4*Feet,-44>,<3*Feet,4*Feet,-11>
			texture { BodyTex }
		}
		cylinder { // bottom front
			<0,0,-44>,<0,0,-11>,4*Feet
			scale <.5,1,1>
			translate <3*Feet,0,0>
			texture { BodyTex }
//			texture { WhitePaint }
		}
	} // end union

#declare Cab = // +X to the front
	union {
		object { CabShape }
		object { FrontScoop translate <3.1*Feet,0,-44> }
		object { WindShield translate <-2,0,0> }
	}

#declare FEngine =
	union {
		difference {
			sphere {
				<0,0,0>,11
				scale <6,1,1>
				texture { BodyTex }
				clipped_by { box{<-5*Feet,-30,-30>,<5*Feet,30,30>}}
			}
			cylinder {
				<-8*Feet,0,0>,<8*Feet,0,0>,4.5
				texture { DullBlack }
			}
		} // end difference
		torus { // end ring
			4,.7
			texture { ChromeTex }
			rotate z*90
			scale <1.6,1,1>
			translate <-4.8*Feet,0,0>
		}
		torus { // end ring
			4,.7
			texture { ChromeTex }
			rotate z*90
			scale <1.6,1,1>
			translate <4.8*Feet,0,0>
		}
		sphere { // center blocker
			<0,0,0>,10
			texture { FlatBlack }
		}
	} // end union
#declare REngine =
	object { FEngine scale 2.3 }

#declare SupportFin =
	cylinder {
		<0,0,0>,<60,0,0>,18
		scale <1,1,.3>
		texture { BodyTex }
	}

//----------------- Assemblies ---------------------

#declare Tractor =
	union {
		object { Cab translate <0,0,7*Feet> }
		object { GravJet1 scale 1.5 rotate z*90 translate <-0*Feet,-BWidth/2-24,3*Feet> }
		object { GravJet1 scale 1.5 rotate z*90 translate <-0*Feet,BWidth/2+24,3*Feet> }
		object { SupportFin rotate <0,22,-90> translate <-2*Feet,-BWidth/2+24,5.2*Feet> }
		object { SupportFin rotate <0,22, 90> translate <-2*Feet,BWidth/2-24,5.2*Feet> }
		translate <4*Feet,0,0> // origin at pivot point
	}
#declare Trailer =
	union {
		object { Bed  translate <0,0,6*Feet> }
		object { BedChassis translate <0,0,5*Feet> }
		object { REngine translate <-20*Feet,-BWidth/2,3*Feet> }
		object { REngine translate <-20*Feet,BWidth/2,3*Feet> }
		object { TailLight scale <1,1.5,1> translate <-BLength+8,-BWidth/2+6,5.5*Feet> }
		object { TailLight scale <1,1.5,1> translate <-BLength+8,-BWidth/2+16,5.5*Feet> }
		object { TailLight scale <1,1.5,1> translate <-BLength+8, BWidth/2-6,5.5*Feet> }
		object { TailLight scale <1,1.5,1> translate <-BLength+8, BWidth/2-16,5.5*Feet> }
	}

#declare Truck =
	union {
		object { Tractor rotate z*8 }
		object { Trailer }
/*
		object { Bed  translate <0,0,6*Feet> }
		object { BedChassis translate <0,0,5*Feet> }
		object { REngine translate <-20*Feet,-BWidth/2,3*Feet> }
		object { REngine translate <-20*Feet,BWidth/2,3*Feet> }
*/
	}
