
// Glenn's Wright Flyer POV-Ray Object File
// This file does not render.  #include "WrightFlyer.inc" in another .pov file
// created 15-Mar-98  updated 15-Mar-98
// copyright 1998 Glenn McCarter

// A copy of the original Wright brothers' flyer
// Intended scale is English system (inches)
// Plane sits on +Z plane, front of wings at origin, extending into +X

//===============================================
//             Textures
//===============================================

#declare CanvasTex =
	texture {
		pigment { //color rgbt<.74,.70,.34,.2> } // slightly transparent
			bozo
			color_map {
				[ 0.0 color rgbt<.64,.50,.24,.16> ]
//				[ 1.0 color rgbt<.74,.70,.34,.3> ]
				[ 1.0 color rgbt<.94,.82,.56,.24> ]
			}
			scale 20
		}
		normal { bumps .1 scale 40 }
		finish { ambient .1 diffuse .8 specular .08 roughness .16 }
	}
#declare OldWood =
	texture {
		pigment { color rgb<.44,.33,.07> }
		normal { bumps .3 scale 1 }
		finish { ambient .1 diffuse .7 specular .3 roughness .08 }
	}
#declare MetalTex =
	texture {
		pigment { color rgb<.32,.26,.22> }
		normal { bumps .3 scale .1 }
		finish { ambient .1 diffuse .7 specular .6 roughness .01 }
	}




//===============================================
//             Objects
//===============================================

//------------- Miscellaneous -----------------------

#declare SeatPad =
	box {
		<0,-9,0>,<6*Feet,9,1>
		texture { OldWood }
	}

#declare ThinWire =
	cylinder {
		<0,0,0>,<0,0,6*Feet+4>,.08
//		texture { BrightWhite }
		texture { MetalTex }
	}

//------------- Flight Panels -----------------------

#declare RS = seed(59287)
#declare WingSegment =
	intersection {
		sphere { // outer
			<0,0,0>,40
			scale <2,.7,.4>
			rotate y*13
			translate <80,0,-40>
		}
		sphere { // inner
			<0,0,0>,39.7
			scale <2,.7,.4>
			rotate y*13
			translate <80,0,-40>
			inverse
		}
		box { // cookie cutter
			<0,-6,-22>,<5*Feet,6,22>
		}
		texture { CanvasTex translate rand(RS*80) }
		translate <0,0,23> // origin at front edge, extends into +X
		rotate y*5
	} // end intersection

#declare RudderPanel =
	box {
		<0,-.3,0>,<16,.3,55>
		texture { CanvasTex }
	}

#declare ElevatorPanel =
	union {
		object { WingSegment scale <.3,7,.3> }
	}
/*
	box {
		<0,-48,-.3>,<16,48,.3>
		texture { CanvasTex }
	}
*/


//------------- Drive Train -----------------------
#declare Engine =
	union {
		box {
			<0,-8,0>,<20,8,6>
		}
		cylinder { // shaft
			<18,0,0>,<26,0,0>,.6
			translate <0,0,3>
		}
		cylinder {
			<0,0,0>,<0,0,7>,2.7
			translate <6,4,5>
		}
		cylinder {
			<0,0,0>,<0,0,7>,2.7
			translate <11,4,5>
		}
		cylinder {
			<0,0,0>,<0,0,7>,2.7
			translate <16,4,5>
		}
		texture { DarkBrownTex }
	}
#declare Propeller =
	union {
		cylinder { //hub
			<-2,0,0>,<2,0,0>,3.8
		}
		box {
			<0,-2,0>,<.8,2,40>
			rotate <0,0,22>
		}
		box {
			<0,-2,0>,<.8,2,-40>
			rotate <0,0,-22>
		}
		texture { DarkBrownTex }
	}

//------------- Wood Spars -----------------------
#declare WoodThickness = 1.4 // inches
#declare WH = WoodThickness/2 // per half
#declare VertSupport =
	box {
		<-WH,-WH,0>,<WH,WH,48>
		texture { OldWood }
	}
#declare SkidRail =
	box {
		<0,-WH*2,-WH>,<7*Feet,WH*2,WH>
		texture { OldWood }
	}
#declare BottomRiser =
	box {
		<-WH,-WH,0>,<WH,WH,16>
		texture { OldWood }
	}
#declare ElevatorSupport =
	box {
		<0,-WH,-WH>,<8*Feet,WH,WH>
		texture { OldWood }
	}
#declare ElevatorVert =
	box {
		<-WH,-WH,0>,<WH,WH,23>
		texture { OldWood }
	}
#declare RudderSupport =
	box {
		<0,-WH,-WH>,<10.5*Feet,WH,WH>
		texture { OldWood }
	}
#declare RudderTie =
	box {
		<-WH,-12,-WH>,<WH,12,WH>
		texture { OldWood }
	}




//------------- Assemblies -----------------------
#declare NC = 0
#declare HalfWing =
	union {
		#while ( NC < 17 )
			object { WingSegment translate <0,12*NC,0> texture { CanvasTex translate rand(RS)*40 } }
			#declare NC = NC + 1
		#end
	} // end union

#declare LowerWingHeight = 16
#declare LWH = LowerWingHeight
#declare UpperWingHeight = LWH+48
#declare UWH = UpperWingHeight
#declare HalfWingAssy =
	union {
		object { HalfWing translate <0,0,LWH> }
		object { HalfWing translate <0,0,UWH> }
		object { VertSupport translate <3,24,LWH+1.2> }
		object { VertSupport translate <3,6*Feet,LWH+1.2> }
		object { VertSupport translate <3,11*Feet,LWH+1.2> }
		object { VertSupport translate <3,16*Feet,LWH+1.2> }
		object { VertSupport translate <4.4*Feet,24,LWH-2> }
		object { VertSupport translate <4.4*Feet,6*Feet,LWH-2> }
		object { VertSupport translate <4.4*Feet,11*Feet,LWH-2> }
		object { VertSupport translate <4.4*Feet,16*Feet,LWH-2> }
	}

#declare Wires =
	union {
		object { ThinWire rotate x*-40 scale <1,1,.8> translate <3,23,LWH> } // front
		object { ThinWire rotate x*-52 translate <3,6*Feet,LWH> }
		object { ThinWire rotate x*-52 translate <3,11*Feet,LWH> }
		object { ThinWire rotate x*40 scale <1,1,.8> translate <3,-23,LWH> }
		object { ThinWire rotate x*52 translate <3,-6*Feet,LWH> }
		object { ThinWire rotate x*52 translate <3,-11*Feet,LWH> }
		object { ThinWire rotate x*52 translate <4.4*Feet,6*Feet,LWH> } // back
		object { ThinWire rotate x*52 translate <4.4*Feet,11*Feet,LWH> }
		object { ThinWire rotate x*52 translate <4.4*Feet,16*Feet,LWH> }
		object { ThinWire rotate x*-52 translate <4.4*Feet,-6*Feet,LWH> }
		object { ThinWire rotate x*-52 translate <4.4*Feet,-11*Feet,LWH> }
		object { ThinWire rotate x*-52 translate <4.4*Feet,-16*Feet,LWH> }
	}


#declare FullWings =
	union {
		object { HalfWingAssy }
		object { HalfWingAssy scale <1,-1,1> }
		object { Wires }
	}

#declare WrightFlyer =
	union {
		object { FullWings }
		object { SeatPad rotate y*6 translate <-8,11,LWH+7> }
		object { Engine translate <36,-14,LWH+1> }
		object { Propeller rotate x*36 translate <36+24,-48,40> }
		object { Propeller rotate x*36 translate <36+24,48,40> }
		object { ElevatorPanel translate <-7*Feet-8,0,28> }
		object { ElevatorPanel translate <-7*Feet-8,0,42> }
		object { ElevatorSupport rotate <0,11,0> translate <-7*Feet,-28,18> }
		object { ElevatorSupport rotate <0,11,0> translate <-7*Feet,28,18> }
		object { ElevatorSupport rotate <0,11,0> translate <-7*Feet,-28,35> }
		object { ElevatorSupport rotate <0,11,0> translate <-7*Feet,28,35> }
		object { ElevatorSupport rotate <0,-30,0> translate <-6*Feet,-28,16> }
		object { ElevatorSupport rotate <0,-30,0> translate <-6*Feet,28,16> }
		object { ElevatorVert translate <-7*Feet,-28,17> }
		object { ElevatorVert translate <-7*Feet,28,17> }
		object { RudderPanel translate <10*Feet,-12,14> }
		object { RudderPanel translate <10*Feet,12,14> }
		object { RudderSupport translate <0,0,13> }
		object { RudderTie translate <10.5*Feet,0,13> }
		object { RudderSupport translate <0,12,16+46> }
		object { RudderSupport translate <0,-12,16+46> }
		object { BottomRiser translate <4,-28,0> }
		object { BottomRiser translate <4,28,0> }
		object { BottomRiser translate <4.5*Feet,-28,0> }
		object { BottomRiser translate <4.5*Feet,28,0> }
		object { SkidRail translate <0*Feet,-28,0> }
		object { SkidRail translate <0*Feet,28,0> }
	}


