// Persistence of Vision Ray Tracer Scene Description File
// File: blp.pov, 2 part of 8, IRTC animation round 1/98
// Vers: 3.02
// Desc: ship moves from left to right, for comments please read part 1 alp.pov
// Date: 16.2.1998
// Auth: Ondrej Svoboda osvo@geocities.com


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "plachtalp.inc"
#include "ostrov.inc"

camera {location<-5,2,-20>
       angle 80}

light_source{<100,30,-100> color White}

#declare Water = texture {
  pigment {
    color rgbf <0.08, 0.96,0.77,0.6>
  }
  normal { bumps 0.4 }
  finish {
    reflection 0.4
    refraction 0.5
    ior 1.33
    phong 1.0
    phong_size 100
  }
  scale <0.3,0.3,0.3>
  translate <1.5+1.5*clock,0,4+4*clock>
}
#declare Skytex =
texture {
  pigment
  {
    gradient y
    color_map
    {
      [0.00 color rgb<0.792, 0.933, 0.922>]
      [1.00 color rgb<0.498, 0.486, 0.886>]
    }
    scale <1.0, 1000.0, 1.0>
  }
}
texture {
  pigment
  {
    bozo
    turbulence 0.7  octaves 8  omega 0.69
    color_map
    {
      [0.00 color rgb<1.000, 1.000, 1.000>]
      [0.20 color rgb<1.000, 1.000, 1.000>]
      [0.25 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
    scale <250,250,250>
    translate <0,0,40+40*clock>
  }
}


sphere {<0,0,0>,1000
       texture {Skytex}
       scale <1,0.3,1>}

plane {<0,1,0>,0
      texture{Water}}


#declare Trup=
difference{
sphere {<0,0,0>,1
       scale <4,1.2,1>}
box {<-1,-1,-1>,<1,1,1>
    translate <-4,0,0>}
box {<-4,0,-1>,<4,1.3,1>}
translate <-0.5,1,0>
rotate y*180
pigment {color Red}
         }


#declare Lod=union {
                   object {Plachta translate <-1.6,1,0>}
                   object {Trup}
                   cylinder {<-1.75,1,0>,<-1.75,11,0>,0.1
                            pigment {color Red}
                            }
                    }

object {Ostrov
       rotate y*-20
       translate <-100,0,150>}

object {Lod
       rotate <-20,-150,0>
       translate <0,-0.2,0>
#if (clock < 0.5)
translate <0,(-0.5*clock),0>
#else
translate <0,(-0.5*(1-clock)),0>
#end
translate <-32+16*clock,0,16-8*clock>}

