#declare STARTFRAME = 0
#declare ENDFRAME =  80

#if (clock >= STARTFRAME)
    #if (clock < ENDFRAME)
        #declare SCENE = 0   //zoom in
        #declare CAMCLOCK = (clock-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end

#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 135

#if (clock >= STARTFRAME)
    #if (clock < ENDFRAME)
        #declare SCENE = 1  //pan to lights
        #declare CAMCLOCK = (clock-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end


#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 200

#if (clock >= STARTFRAME)
    #if (clock < ENDFRAME)
        #declare SCENE = 2  //watch lights
        #declare CAMCLOCK = (clock-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end


//change checked clock to race_clock..............

#declare STARTFRAME = 0
#declare ENDFRAME = 025         //YELLOW IS 757   RED IS 834

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 3  //first corner
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end

#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 057          //YELLOW IS 2965   RED IS 3098

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 4  //watch xover
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end

#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 091          //YELLOW IS 4949   RED IS 4968

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 5  //second corner etc.
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end


#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 141          //YELLOW IS 6530   RED IS 6512

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 6  //hairpin1 etc.
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end

#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 176          //YELLOW IS 7709   RED IS 7615

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 7  //before tunnel
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end

#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 196          //YELLOW IS 9297   RED IS 9191

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 8  //inside tunnel
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end


#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 223          //YELLOW IS 11270   RED IS 11191

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 9  //second crossover
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end


#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 261          //YELLOW IS 13397   RED IS 13110

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 10  //pool
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end



#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 291          //YELLOW IS 14071   RED IS 14317

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 11  //SECOND HAIRPIN
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end


#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 332          //YELLOW IS 15651   RED IS 16250

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 12  //FINAL CHICANE
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end


#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 344          //YELLOW IS ?   RED IS 0 (second lap)

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 13  //FINAL STRAIGHT
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end


#declare STARTFRAME = ENDFRAME
#declare ENDFRAME = 375

#if (RACE_CLOCK >= STARTFRAME)
    #if (RACE_CLOCK < ENDFRAME)
        #declare SCENE = 14  //STILL CAMERA
        #declare CAMCLOCK = (RACE_CLOCK-STARTFRAME)/(ENDFRAME-STARTFRAME)
        #end
    #end



#debug concat("\n scene number is ",str(SCENE,0,1))
#debug concat("\n cam clock is ",str(CAMCLOCK,0,3))





//declare coords

#declare YELLOW_LOOK_AT = vrotate(<0,0.5*inches,-1.5*inches>,y*YELLOW_CAR_DIRECTION)+YELLOW_CAR_POS
#declare RED_LOOK_AT = vrotate(<0,0.5*inches,-1.5*inches>,y*RED_CAR_DIRECTION)+RED_CAR_POS
#declare BOTHCARS_LOOK_AT = (YELLOW_LOOK_AT+RED_LOOK_AT)/2   //average of 2 points
#declare BOTHCARS_GAP = vlength(RED_LOOK_AT-YELLOW_LOOK_AT)  //distance between points


#if (SCENE = 0)
#declare LIGHTVALUE = clock/12
#declare cam_start = <2.0*feet, 4*feet, 2.0*feet>
#declare cam_end = <-0.5*feet, 2.5*inches, -6.0*inches>

#declare cam_pos = cam_start + (cam_end-cam_start)*pow(CAMCLOCK,0.25)

camera
{
  location  cam_pos
  direction 1.5*z
  right     4/3*x
  look_at BOTHCARS_LOOK_AT
}

#end

#if (SCENE = 1)
#declare cam_look_start = BOTHCARS_LOOK_AT
#declare cam_look_end = <0.0*inches,4.0*inches,0.0>
#declare cam_look_at = cam_look_start + (cam_look_end-cam_look_start)*(sin(pi*(CAMCLOCK - 0.5))+1)*0.5
camera
{
  location  <-0.5*feet, 2.5*inches, -6.0*inches>
  direction 1.5*z
  right     4/3*x
  look_at cam_look_at
}
//for lens effects
    #declare camera_location = <-0.5*feet, 2.5*inches, -6.0*inches>
    #declare camera_look_at = cam_look_at
#end


#if (SCENE = 2)
#declare cam_look_end = <0.0*inches,4.0*inches,0.0>
camera {
    location  <-0.5*feet, 2.5*inches, -6.0*inches>
    direction 1.5*z
    right     4/3*x
    look_at cam_look_end
    }
//for lens effects
    #declare camera_location = <-0.5*feet, 2.5*inches, -6.0*inches>
    #declare camera_look_at = cam_look_end
#end


#if (SCENE = 3)

camera
{
  location  <-0.5*feet, 4*inches, 1.0*feet>
  direction 1.5*z
  right     4/3*x
  look_at BOTHCARS_LOOK_AT
}

#end



#if (SCENE = 4)

#declare cam_start = <4*feet, 6*inches, 1.5*feet>
#declare cam_end = <6*feet, 6*inches, 1.5*feet>
#declare cam_pos = cam_start + (cam_end-cam_start)*CAMCLOCK
camera
{
  location  cam_pos
  direction 1.5*z
  right     4/3*x
  look_at YELLOW_LOOK_AT
}

#end


#if (SCENE = 5)

camera
{
  location  <5.5*feet, 2.5*inches, 6.0*feet>
  direction 1.5*z
  right     4/3*x
  look_at RED_LOOK_AT
}

#end

#if (SCENE = 6)

camera
{

  location <0,0,0>
  direction 1.0*z
  right     4/3*x
  rotate x*38
  translate z*4*inches
  rotate y*-21.5
  translate <10.18*feet, 10*inches, 3.6*feet>
}

#end

#if (SCENE = 7)  //"in car view"

camera
{
  direction 1.0*z
  right     4/3*x
  location <0,0,0>
  rotate x*1  //camera pointed downwards slightly to avoid bad torus calculations in barriers
  translate  <-0.5*inches, 0.2*inches, 0.0*inches>
  rotate YELLOW_CAR_DIRECTION
  translate  YELLOW_LOOK_AT
}

#end

#if (SCENE = 8)

#declare cam_start = <12*feet, 4*inches, 2*feet>
#declare cam_end = <10*feet, 4*inches, 1*feet>
// #declare cam_pos = cam_start + (cam_end-cam_start)*CAMCLOCK
#declare cam_pos = <11*feet, 4*inches, 1.5*feet>
camera
{
  location  cam_pos
  direction 1.5*z
  right     4/3*x
  look_at YELLOW_LOOK_AT

//for lens effects
}
#declare camera_location = cam_pos
#declare camera_look_at = YELLOW_LOOK_AT
#end

#if (SCENE = 9)

#declare cam_start = <6.5*feet, 7*inches, -0.5*feet>
#declare cam_end = <4*feet, 7*inches, -0.5*feet>
#declare cam_pos = cam_start + (cam_end-cam_start)*CAMCLOCK
camera
{
  location  cam_pos
  direction 1.5*z
  right     4/3*x
  look_at RED_LOOK_AT
}

#end


#if (SCENE = 10)

camera
{
  location  <3*feet, 6*inches, -4.0*feet>
  direction 1.5*z
  right     4/3*x
  look_at YELLOW_LOOK_AT
}

#end


#if (SCENE = 11)

camera
{
  location  <5*feet, 1*inches, -6.0*feet>
  direction 1.5*z
  right     4/3*x
  look_at YELLOW_LOOK_AT
}

#end



#if (SCENE = 12)

#declare cam_start = <2.0*feet, 10*inches, -7.0*feet>
#declare cam_end = <0.5*feet, 10*inches, -6.5*feet>
#declare cam_pos = cam_start + (cam_end-cam_start)*CAMCLOCK
camera
{
  location  cam_pos
  direction 1.5*z
  right     4/3*x
  look_at RED_LOOK_AT
}

#end

#if (SCENE = 13)

#declare cam_look_start = <0.0,0,-37*inches>
#declare cam_look_end = <0.0,0.0,0.0>
#declare cam_look_at = cam_look_start + (cam_look_end-cam_look_start)*CAMCLOCK
camera
{
  location  <0.3*feet, 8*inches, -0.5*feet>
  direction 1.5*z
  right     4/3*x
  look_at cam_look_at
}

#end


#if (SCENE = 14)
#declare LIGHTVALUE = (574-clock)/12
#declare cam_look_at = <0.0,0.0,0.0>
camera
{
  location  <0.3*feet, 8*inches, -0.5*feet>
  direction 1.5*z
  right     4/3*x
  look_at cam_look_at
}


#end


/*
#declare INPUT_DISTANCE = RED_CAR_DISTANCE + 10*inches
#declare L_OFF = 0

    #declare DIST_LOCATE = on
    #include TRACKFILE
    #declare DIST_LOCATE = off

camera
{
  location  <0,0.3*inches,0>
  direction 1.5*z
  right     4/3*x
 translate  L_POS
  look_at BOTHCARS_LOOK_AT
}



camera
{
#declare camera_pos = <1*feet, 7*feet, -1*feet>
  location  camera_pos
  direction z*0.0025*vlength(camera_pos-YELLOW_CAR_POS)
  right     4/3*x
  look_at YELLOW_CAR_POS
}

camera {
    orthographic
    location <7*feet, 7*feet, 0*feet>
    right <16*feet, 0, 0>      // length determines size of view
    up <0, 16*feet, 0>             // length determines size of view
    direction <0, 0, 100>       // length isn't used
    look_at <7*feet, 0, 0*feet>
}

*/
