#declare c_strength = abs(c_strength)*(c_angle / abs(c_angle)) //make c_strength same sign as c_angle

#declare barrier_post =
    box {<-0.065*inches,0.0,-0.15*inches><0.065*inches,1.125*inches,0.15*inches>}


#declare oc_barrier =
    intersection {
        union{
            torus {abs(c_strength) + t_width, 0.126*inches translate <c_strength, 0.625*inches, 0>}
            torus {abs(c_strength) + t_width, 0.126*inches translate <c_strength, 0.875*inches, 0>}
            torus {abs(c_strength) + t_width, 0.126*inches translate <c_strength, 1.125*inches, 0>}
//always give barrier at least 2 legs.... (only for outer barriers)
#declare barrier_amount = max(int( (abs(c_strength) + t_width) * abs(c_angle) / (465*inches) ),1)
#declare barrier_count = 0
#declare barrier_pos = c_angle/barrier_amount
#while (barrier_count < barrier_amount)

            object {
                barrier_post
                translate x*-(c_strength + (  (abs(t_width)+(0.065*inches)) * (c_strength/ abs(c_strength)) ) )
                rotate y*barrier_pos*(0.1+barrier_count)
                translate x*c_strength
                }
            object {
                barrier_post
                translate x*-(c_strength + (  (abs(t_width)+(0.065*inches)) * (c_strength/ abs(c_strength)) ) )
                rotate y*barrier_pos*(0.9+barrier_count)
                translate x*c_strength
                }
            #declare barrier_count = barrier_count + 1
            #end

            }
        plane {z 0 inverse}
        plane {z 0 rotate <0,c_angle,0> translate <c_strength, 0, 0>}

        texture {
        white_barrier_plastic
        }

        bounded_by {   //optimised

        #declare b_width = -t_width*(c_angle / abs(c_angle))
        box {   < min( b_width*1.1  ,  (vrotate(<(b_width*0.9)-c_strength,seg_high,0>,<0,c_angle,0>)+<c_strength,0,0>).x  ),-0.1,-0.1>
                < max( b_width*1.1  ,  (vrotate(<(b_width*0.9)-c_strength,seg_high,0>,<0,c_angle,0>)+<c_strength,0,0>).x  ),1.5*inches, (vrotate(<-c_strength,0,0>,<0,c_angle,0>)).z + t_width*1.1  >}
        }
    }





        object{
            oc_barrier
            rotate T_ANG
            translate T_POS
            }






