#declare TABLE = union {

#declare FELTTEX = texture {
  pigment   { color rgb <.067, .357, .129> }
  normal {
    wrinkles 1
    frequency 10
    scale .1
  }
  finish {
    specular 0.05    metallic
    phong 0.05    metallic
  }
}

box {<-2.5*12,-1,-5*12><2.5*12,0,5*12>
texture {FELTTEX}
}

#declare BLACKTEX = texture {
  pigment {
    granite
    turbulence 0.4  lambda 0.4
    color_map {
      [0.00 color rgb<0.200, 0.200, 0.349>]
      [0.25 color rgb<0.098, 0.098, 0.200>]
      [0.40 color rgb<0.000, 0.000, 0.098>]
      [0.80 color rgb<0.000, 0.000, 0.149>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
    translate <3.0, 0.0, 0.0>
    scale <2.0, 2.0, 2.0>
  }
}
texture {
  pigment {
    gradient x
    turbulence 0.8  octaves 4  omega 0.7
    color_map {
      [0.00 color rgbf<0.800, 0.800, 0.800, 1.000>]
      [0.95 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.98 color rgb<1.000, 1.000, 1.000>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
    translate <0.0, 2.0, 0.0>
    scale <0.7, 1.5, 0.2>
  }
  finish {
    diffuse 0.3
    specular 0.5
    reflection 0.35
  }
}

//#declare BLACKTEX = texture {pigment {Red} } // QUICK RENDER TEX

difference {
union {
box { <-32,-1,-63> <32,0,63> texture {FELTTEX} }
difference {
union {
box { <-34,-1,-64> <-30,2,64> texture {BLACKTEX} }
box { <-34,-1,64> <34,2,60> texture {BLACKTEX} }
box { <34,-1,60> <30,2,-60> texture {BLACKTEX} }
box { <34,-1,-60> <-34,2,-64> texture {BLACKTEX} }
}
cylinder {<-30,0,-60>< 30,0,-60> 2 texture {FELTTEX}}
cylinder {< 30,0,-60>< 30,0, 60> 2 texture {FELTTEX}}
cylinder {< 30,0, 60><-30,0, 60> 2 texture {FELTTEX}}
cylinder {<-30,0, 60><-30,0,-60> 2 texture {FELTTEX}}
torus {2.25 .25 translate < 30,2,0> texture {BLACKTEX} }
torus {2.25 .25 translate <-30,2,0> texture {BLACKTEX} }
#declare POCK1=union {box {<-2.25,-4,0><2.25,1,2.25> rotate <0,45,0> texture {BLACKTEX} }
torus {2.25 .25 texture {BLACKTEX} }
cylinder {<-2.25,0,0><-2.25,0,4.5> .25 rotate <0,45,0> texture {BLACKTEX} }
cylinder {<2.25,0,0><2.25,0,4.5> .25 rotate <0,45,0> texture {BLACKTEX} }
bounded_by {
box {<-35,-2,-65><35,3,65>}
}
}
#object {POCK1 translate <-30,2,-60>}
#object {POCK1 rotate <0,90,0> translate <-30,2, 60>}
#object {POCK1 rotate <0,180,0> translate < 30,2, 60>}
#object {POCK1 rotate <0,270,0> translate < 30,2,-60>}
bounded_by {
box {<-35,-2,-65><35,3,65>}
}
}
}
cylinder {<-30,3,-60><-30,-2,-60> 2.25 texture {BLACKTEX}}
cylinder {<30,3,-60><30,-2,-60> 2.25 texture {BLACKTEX}}
cylinder {<-30,3,60><-30,-2,60> 2.25 texture {BLACKTEX}}
cylinder {<30,3,60><30,-2,60> 2.25 texture {BLACKTEX}}
cylinder {<-30,3,0><-30,-2,0> 2.25 texture {BLACKTEX}}
cylinder {<30,3,0><30,-2,0> 2.25 texture {BLACKTEX}}
bounded_by {
box {<-35,-2,-65><35,3,65>}
}
}

cylinder {
 <0,0,0><0,.001,0> .5
 pigment {
  image_map {
   gif "FeltDot.gif"
   map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
   transmit 0 1
   interpolate 4
   once
  }
  translate <-.5,-.5,0>
  rotate <90,0,0>
  scale 1/.768
 }
 rotate <0,rand(R1)*360,0>
 translate <0,0,30>
}
cylinder {
 <0,0,0><0,.001,0> .5
 pigment {
  image_map {
   gif "FeltDot.gif"
   map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
   transmit 0 1
   interpolate 4
   once
  }
  translate <-.5,-.5,0>
  rotate <90,0,0>
  scale 1/.768
 }
 rotate <0,rand(R1)*360,0>
 translate <0,0,-30>
}

difference {
union {
box {<-30,-5,-60><30,-1,60> }
cylinder {<-30,-1,-60><30,-1,-60> 4 }
cylinder {<30,-1,-60><30,-1,60> 4 }
cylinder {<30,-1,60><-30,-1,60> 4 }
cylinder {<-30,-1,60><-30,-1,-60> 4 }
sphere {<-30,-1,-60> 4 }
sphere {<30,-1,-60> 4 }
sphere {<30,-1,60> 4 }
sphere {<-30,-1,60> 4 }
}
box {<-35,-1,-65><35,4,65> }
texture {BLACKTEX}
}

#declare LEG = difference {
prism { conic_sweep linear_spline 1 0 5, <2,2><-2,2><-2,-2><2,-2><2,2> sturm}
box { <3,.5, 3> <-3, -1,-3> }
translate <0,-1,0>
scale <1,2,1> // LEG = <-2, 0,-2>..< 2,-1, 2>
scale <2,31.5,2> // LEG = <-4, 0,-4>..< 4,-31.5, 4>
}

#object {LEG translate < 24,-4,-54> texture {BLACKTEX}}
#object {LEG translate <-24,-4,-54> texture {BLACKTEX}}
#object {LEG translate <-24,-4, 54> texture {BLACKTEX}}
#object {LEG translate < 24,-4, 54> texture {BLACKTEX}}

#ifndef (LAMPTEX)
#declare LAMPTEX = texture {
  pigment { colour rgb<0.898,0.910,0.976> }
  finish {
    ambient 0.2
    diffuse 0.7
    brilliance 6.0
    phong 0.75    phong_size 80    metallic
    reflection 0.2
  }
  normal { dents .5 scale 2 frequency .5 }
}
#end

sphere {0 2.125 scale <1,.25/2.125,1> translate <-24,-35.5, 54> texture {LAMPTEX} }
sphere {0 2.125 scale <1,.25/2.125,1> translate <-24,-35.5,-54> texture {LAMPTEX} }
sphere {0 2.125 scale <1,.25/2.125,1> translate < 24,-35.5,-54> texture {LAMPTEX} }
sphere {0 2.125 scale <1,.25/2.125,1> translate < 24,-35.5, 54> texture {LAMPTEX} }

#declare TableMarkTex=texture {
  pigment {
    bozo
    turbulence 0.4
    color_map {
      [0.0 color rgb<1.000, 1.000, 1.000>]
      [0.5 color rgb<0.376, 0.678, 0.839>]
      [1.0 color rgb<1.000, 1.000, 1.000>]
    }
  }
  finish {
    diffuse .1
    specular 0.6    metallic
    phong 0.5    metallic
    brilliance 5
    reflection .25
    irid {.25 thickness .5 turbulence .25}
  }
  scale .1
}

cylinder {<0,2,0><0,2.01,0> .25 translate <-15,0,-61> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <0,0,-61> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <15,0,-61> texture {TableMarkTex} }

cylinder {<0,2,0><0,2.01,0> .25 translate <-15,0,61> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <0,0,61> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <15,0,61> texture {TableMarkTex} }

cylinder {<0,2,0><0,2.01,0> .25 translate <31,0,-45> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <31,0,-30> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <31,0,-15> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <31,0,15> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <31,0,30> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <31,0,45> texture {TableMarkTex} }

cylinder {<0,2,0><0,2.01,0> .25 translate <-31,0,-45> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <-31,0,-30> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <-31,0,-15> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <-31,0,15> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <-31,0,30> texture {TableMarkTex} }
cylinder {<0,2,0><0,2.01,0> .25 translate <-31,0,45> texture {TableMarkTex} }

#include "CSLOGO.INC"
#object {CSLOGO scale 2 rotate <0,180,0> translate <0,2, 62>}
#object {CSLOGO scale 2 rotate <0,0,0> translate <0,2,-62>}

} // TABLE
