
// POV file by Andrew Cherry

#declare c=clock
#declare QUICK=0

#debug "\n+----------------------------------------------+\n"
#debug concat("| ANIMATION SEQUENCE IS",str((clock*100),6,2)," PERCENT FINISHED |                 <-- AC")
#debug "\n+----------------------------------------------+\n"
#if (clock>0) #debug concat("\nTIME REMAINING: ",str(((1/clock)-1),6,1)," x E-TIME\n\n") #end

#declare R1=seed(666)

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CONSTS.INC"
#include "GLASS.INC"
#include "SKIES.INC"
#include "METALS.INC"
#include "SHAPES.INC"   // These aren't normally necessary
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

camera {
  location  <0 , 20 , -30>
  look_at   <0 , 0 , 0>
}

/*
#declare NUMLITES=20
#declare Iz=-60
#while (Iz<=60)
light_source { < 30,20,Iz>/2 color White/NUMLITES }
light_source { <-30,20,Iz>/2 color White/NUMLITES }
#declare Iz=Iz+120/(NUMLITES/2)
#end
*/

light_source { <0,20,0> color White}

//-----------------------------------------------------------------------------------------------------------------------------

#declare BALLFIN = finish {phong 1 phong_size 200 reflection 0.25 ambient 0.15 diffuse 0.75}
#declare RANDBALLROT=1

#declare BALLTEXa=texture {pigment {color White} finish {BALLFIN}}
#declare BALL0 = sphere { 0 .5 texture {BALLTEXa} translate <0,.5,0> scale 4.5}
BALL0

//-----------------------------------------------------------------------------------------------------------------------------

#declare FELTTEX = texture {
  pigment   { color rgb <.067, .357, .129> }
  normal {
    wrinkles 1
    frequency 10
    scale .1
  }
  finish {
    specular 0.05    metallic
    phong 0.05    metallic
  }
}

#declare BLACKTEX = texture {
  pigment {
    granite
    turbulence 0.4  lambda 0.4
    color_map {
      [0.00 color rgb<0.200, 0.200, 0.349>]
      [0.25 color rgb<0.098, 0.098, 0.200>]
      [0.40 color rgb<0.000, 0.000, 0.098>]
      [0.80 color rgb<0.000, 0.000, 0.149>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
    translate <3.0, 0.0, 0.0>
    scale <2.0, 2.0, 2.0>
  }
}
texture {
  pigment {
    gradient x
    turbulence 0.8  octaves 4  omega 0.7
    color_map {
      [0.00 color rgbf<0.800, 0.800, 0.800, 1.000>]
      [0.95 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.98 color rgb<1.000, 1.000, 1.000>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
    translate <0.0, 2.0, 0.0>
    scale <0.7, 1.5, 0.2>
  }
  finish {
    diffuse 0.3
    specular 0.5
    reflection 0.35
  }
}

difference {
union {
box { <-32,-1,-63> <32,0,63> texture {FELTTEX} }
difference {
union {
box { <-34,-1,-64> <-30,2,64> texture {BLACKTEX} }
box { <-34,-1,64> <34,2,60> texture {BLACKTEX} }
box { <34,-1,60> <30,2,-60> texture {BLACKTEX} }
box { <34,-1,-60> <-34,2,-64> texture {BLACKTEX} }
}
cylinder {<-30,0,-60>< 30,0,-60> 2 texture {FELTTEX}}
cylinder {< 30,0,-60>< 30,0, 60> 2 texture {FELTTEX}}
cylinder {< 30,0, 60><-30,0, 60> 2 texture {FELTTEX}}
cylinder {<-30,0, 60><-30,0,-60> 2 texture {FELTTEX}}
torus {2.25 .25 translate < 30,2,0> texture {BLACKTEX} }
torus {2.25 .25 translate <-30,2,0> texture {BLACKTEX} }
#declare POCK1=union {box {<-2.25,-4,0><2.25,1,2.25> rotate <0,45,0> texture {BLACKTEX} }
torus {2.25 .25 texture {BLACKTEX} }
cylinder {<-2.25,0,0><-2.25,0,4.5> .25 rotate <0,45,0> texture {BLACKTEX} }
cylinder {<2.25,0,0><2.25,0,4.5> .25 rotate <0,45,0> texture {BLACKTEX} }
}
#object {POCK1 translate <-30,2,-60>}
#object {POCK1 rotate <0,90,0> translate <-30,2, 60>}
#object {POCK1 rotate <0,180,0> translate < 30,2, 60>}
#object {POCK1 rotate <0,270,0> translate < 30,2,-60>}
}
}
cylinder {<-30,3,-60><-30,-2,-60> 2.25 texture {BLACKTEX}}
cylinder {<30,3,-60><30,-2,-60> 2.25 texture {BLACKTEX}}
cylinder {<-30,3,60><-30,-2,60> 2.25 texture {BLACKTEX}}
cylinder {<30,3,60><30,-2,60> 2.25 texture {BLACKTEX}}
cylinder {<-30,3,0><-30,-2,0> 2.25 texture {BLACKTEX}}
cylinder {<30,3,0><30,-2,0> 2.25 texture {BLACKTEX}}
}

background { color red 0.1 green 0.3 blue 0.8 }
