
// POV file by Andrew Cherry

#declare c=clock
#declare QUICK=0

#debug "\n+----------------------------------------------+\n"
#debug concat("| ANIMATION SEQUENCE IS",str((clock*100),6,2)," PERCENT FINISHED |                 <-- AC")
#debug "\n+----------------------------------------------+\n"
#if (clock>0) #debug concat("\nTIME REMAINING: ",str(((1/clock)-1),6,1)," x E-TIME\n\n") #end

#declare R1=seed(666)

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CONSTS.INC"
#include "GLASS.INC"
#include "SKIES.INC"
#include "METALS.INC"
#include "SHAPES.INC"   // These aren't normally necessary
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

camera {
  location  <100,50,0>
  look_at   <0,10,0>
}

light_source { <100,50,0> color White}

//-----------------------------------------------------------------------------------------------------------------------------

// TABLE LIGHT

#declare LAMPTEX = texture {
  pigment {
    colour rgb<0.898,0.910,0.976>
  }
  finish {
    ambient 0.2
    diffuse 0.7
    brilliance 6.0
    phong 0.75    phong_size 80    metallic
    reflection 0.2
  }
  normal {
    dents .5
    scale 2
  }
}

//#declare LAMPTEX=texture {pigment{Red} } //QUICK TEX

difference {
box {<21,23.001,31><-21,25,-31> }
box {<20,23,30><-20,25,-30> }
texture {LAMPTEX}
}

#declare BULBTEX =texture {
  pigment {
    colour rgbf<1.000,0.973,0.875,0.698>
  }
  finish {
    ambient 0.25
    diffuse 0.0
    brilliance 1.5
    specular 1.0    metallic
    reflection 0.85
    refraction 1.0    ior 1.5
  }
}

union {
sphere {<-10,24,15> .75}
sphere {<-10,24,-15> .75}
cylinder {
<-10,24,15><-10,24,-15>
.75
}
texture {BULBTEX}
hollow
no_shadow
}

union {
sphere {<0,24,15> .75}
sphere {<0,24,-15> .75}
cylinder {
<0,24,15><0,24,-15>
.75
}
texture {BULBTEX}
hollow
no_shadow
}

union {
sphere {<10,24,15> .75}
sphere {<10,24,-15> .75}
cylinder {
<10,24,15><10,24,-15>
.75
}
texture {BULBTEX}
hollow
no_shadow
}

difference {
prism {
  conic_sweep
  linear_spline // linear_spline | quadratic_spline | cubic_spline
0
1
  5,          // number of points
  // the <u,v> points
< 21, 31><-21, 31><-21,-31>< 21,-31>< 21, 31>
sturm
scale <1,-24,1>
translate <0,24,0>
}
box {<22,8,32><-22,25,-32> }
translate <0,25,0>
texture {LAMPTEX}
}

#declare CHAINTEX=texture {LAMPTEX scale .1}
#declare CHAINTOP=50
#declare CHAINBOTTOM=33.25
#include "chain.inc"
object {CHAIN translate <0,0,15>}
box {<-1,33,17><1,33.25,13> texture {CHAINTEX} }
object {CHAIN translate <0,0,-15>}
box {<-1,33,-17><1,33.25,-13> texture {CHAINTEX} }

#declare TABLELITECOLOR=White
#declare NUMLITES=20
#declare Iz=-15
#while (Iz<=15)
//light_source { < 10,24,Iz> color TABLELITECOLOR/NUMLITES }
//light_source { <-10,24,Iz> color TABLELITECOLOR/NUMLITES }
#declare Iz=Iz+30/(NUMLITES/2)
#end

// TABLE LITE
