
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

camera
{
  location  <-20.0 , 4 ,0.0>
  look_at   <0.0 , 5 , 0.0>
}
//
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, -20>
}
global_settings {
#max_trace_level 100
}
#local clocka=-10

plane {y,0 pigment {Green}}
background {rgb <0,.5,1>}
#declare pultti=union {
#local renga=texture {DMFWood6 finish {reflection 0}}
#local kata=texture {pigment {DMFWood4} }
union {
cylinder {<-4,2,-4>,<4,2,-4>,.5 texture {kata}}
cylinder {<-4,2,4>,<4,2,4>,.5 texture {kata}}
cylinder {<-3.7,2,4>,<-3.3,2,4>,2  texture {renga rotate <30,0,0>}}
cylinder {<3.7,2,4>,<3.3,2,4>,2  texture {renga rotate <40,0,0>}}
cylinder {<-3.7,2,-4>,<-3.3,2,-4>,2  texture {renga rotate <170,0,0>}}
cylinder {<3.7,2,-4>,<3.3,2,-4>,2  texture {renga}}
box {<-3,1.4,-5>,<-2.7,2.9,5> texture {kata}}
box {<3,1.4,-5>,<2.7,2.9,5> texture {kata}}
cylinder {<-5,2,0>,<4,2,0>,.3 texture {kata}}
}
union {
cylinder {<-5,1.5,0>,<-5,-1.5,0>,.1 texture {kata}}
cylinder {<-5,1.5,0>,<-5,-1.5,0>,.1 texture {kata} rotate <60,0,0>}
cylinder {<-5,1.5,0>,<-5,-1.5,0>,.1 texture {kata} rotate <120,0,0>}
torus {1.2,.1 texture {kata} rotate <0,0,90> translate <-5,0,0>}
rotate <clocka*30,0,0>
translate <0,2,0>
}

#local kzz=4;
#local kyy=2;
#local erp=0;

#local kul=clocka;
#while (erp<11)
#local ekzz=kzz;
#local ekyy=kyy;
#local kzz=kzz+sin((-10+erp*kul)*pi/180)*1;
#local kyy=kyy+cos((-10+erp*kul)*pi/180)*1;
cylinder {<0,kyy,kzz>,<0,ekyy,ekzz>,.4 texture {Silver_Metal}}
sphere {<0,kyy,kzz>,.4 texture {Silver_Metal}}
#local erp=erp+1;
#end
#local kzz=kzz+sin((-10+erp*kul)*pi/180)*1;
#local kyy=kyy+cos((-10+erp*kul)*pi/180)*1;

difference {
sphere {<0,.5,1>,2}
sphere {<0,.5,1>,1.8 pigment {Red}}
plane {-z,-.3}
pigment {DMFWood3}
rotate <(-10+erp*kul),0,0>
translate <0,kyy,kzz>
}
cylinder {<0,2,-4>,<0,kyy,kzz>,.1 pigment {White}}
}
sphere {<0,0,0>,0}