
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones.inc"
#include "ultraroska.inc"
#include "ultraaija.inc"
/*
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <200, 500, 0>
}
*/

light_source
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  area_light
  <20, 0, 0> <0, 0, 20> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <200, 500, 0>   // <x y z> position of light
}


camera
{
  location  <-15.0 , 10.0 ,-15.0>
  look_at   <-40.0 , 10.0 , 00.0>
}

sky_sphere {pigment {gradient y
color_map
{
[0.0 rgb <0,0,1>]
[1.0 rgb <.5,.5,1>]
}
}}
union {
#difference {
plane {y,0}
plane {x,0}
}

#difference {
plane {y,30}
plane {-x,0}
}

#difference {
plane {y,0 rotate <0,0,-30>} 
plane {-y,.1} 
translate <0,30,0>
}
pigment {Green}

translate <-100,0,0>
}
#declare penkki=texture {pigment {Gray70}}
#declare ppenkki=texture {pigment {wood turbulence .1} normal {dents .3} }

box {<-2,10,-2>,<2,60,1> texture {penkki} rotate <0,0,60> translate <-40,-4,0>}
box {<-2,10,-2>,<2,60,1> texture {penkki} rotate <0,0,60> translate <-40,-4,-30>}
box {<-2,10,-2>,<2,60,1> texture {penkki} rotate <0,0,60> translate <-40,-4,-60>}
box {<-2,10,-2>,<2,60,1> texture {penkki} rotate <0,0,60> translate <-40,-4,30>}
box {<-2,10,-2>,<2,60,1> texture {penkki} rotate <0,0,60> translate <-40,-4,60>}

#local pen=0;
#while (pen<10)
box {<0,0,-65>,<4,1,65> translate <-55-sin(60*pi/180)*pen*5,5+cos(60*pi/180)*pen*5,0> texture {ppenkki}}
#local pen=pen+1;
#end
sphere {<0,0,0>,1000 scale <1,.1,1> translate <200,-30,1500> pigment {Green}}

sphere {<0,0,0>,1000 scale <1,.2,1> translate <1600,-70,00> pigment {Green}}

sphere {<0,0,0>,1000 scale <1,.2,1> translate <1600,-70,00> rotate <0,-30,0> pigment {Green}}

object {liskoukko scale 1/3 translate <-30,10,0>}

object {kivi scale 7 translate <-80,15,80>}
sphere {<0,0,0>,0 }