// Persistence of Vision Ray Tracer Scene Description File
// File: Cat.pov
// Vers: 3.1
// Desc: Cat Example
// Date: 8/15/98
// Auth: Steve Sloan II

#version 3.1;

#include "colors.inc"
#include "textures.inc"

global_settings { assumed_gamma 1.0 }

#declare my_clock = 0.5;
//#declare my_clock = clock;

#declare inch   = 1;
#declare in     = inch;
#declare inches = inch;
#declare feet   = 12*inch;
#declare foot   = 12*inch;
#declare ft     = 12*inch;
		
// ----------------------------------------
camera {
    /****************/
    /* Room Cameras */
    /****************/

    /* Sitting on Couch, looking forward */
//    location <   7*ft, 4.25*ft,       0>
//    look_at  <-7.5*ft,    4*ft,       0>

    /* Sitting on Couch, looking at TV */
//    location <   7*ft, 4.25*ft,       0>
//    look_at  <-7.5*ft,    4*ft, 12.5*ft>

    /* Full room view (Must comment */
    /* out "LongWall" to use)       */
//    location <  14*ft, 4.25*ft,       0>
//    look_at  <-7.5*ft,    4*ft,       0>

    /* Look at coffee table */
//    location <   4*ft, 4.25*ft,       0>
//    look_at  <      0,   17*in,       0>

    /***************/
    /* Cat Cameras */
    /***************/

    /* 3/4 View (Full body) */
//    location <10, 13, 10>
//    look_at  < 0, 10,  0>

    /* 3/4 View (Head only) */
////    location < 4,  2,  4>
//    location < 4, -1,  4>
//    look_at  < 0,  0,  0>

    /* Side View (Head only) */
//    location < 6,  0,  0>
//    look_at  < 0,  0,  0>

    /* Side View (Full body) */
//    location <12, 13,  0>
//    look_at  < 0, 10,  0>

    /* Front View (Full body) */
//    location < 0, 12, 16>
//    look_at  < 0, 10,  0>

    /* Front View (Head only) */
//    location < 0,  0,  6>
//    look_at  < 0, -1,  0>

    /* Front View (Full body) */
//    location < 0, 15, 20>
//    look_at  < 0, 10,  0>

    /* Top View (Full body) */
//    location < 0, 15,  0>
//    look_at  < 0, 10,  0>
    location < 0, 30,  0>
    look_at  < 0, 10,  0>

    /* Top View (Head only) */
//    location < 0,  6,  0>
//    look_at  < 0, 10,  0>

    orthographic
}

// 4.25*ft Eye level, sitting on the couch
// 5.5*ft  Eye level, standing up

/*************/
/* Sky Color */
/*************/

// It doesn't have to be very realistic -- just good
// enough to filter through the blinds correctly

sky_sphere { pigment { color SkyBlue } }

// ----------------------------------------

/**************/
/* Cat Macros */
/**************/

#include "catmacro.inc"

/**************/
/* Create Cat */
/**************/

/* Define the control points of the body */
/* The points are: muzzle, head center, shoulder, mid-back, rump, and guide point */
#declare Bodyx =    array[6]{    1,    0,    0, 0,     0,    0 }
#declare Bodyy =    array[6]{ 0.57, 2.47,    0, 0,     0,    0 }
#declare Bodyz =    array[6]{ 6.84, 4.82, 2.69, 0, -5.37,   -9 }

#declare Bodyxrad = array[6]{ 0.5, 0.5, 2.24, 2,  2.24, 2.24 }
#declare Bodyyrad = array[6]{ 0.5, 0.5, 2.24, 2,  2.24, 2.24 }

/* Define the control points of the tail */
/* The points are: control point, base of tail, end of tail, */
/*     control point (Only change the last two points) */
/* Tail is about 9 in long */
//#declare Tailx   = array[4]{   0,   0,    0,   -5 }
//#declare Taily   = array[4]{   0,   0,    8,   10 }
//#declare Tailz   = array[4]{   3,   0,   -4,    0 }

#declare Tailx   = array[4]{   0,   0,    5,  15 }
#declare Taily   = array[4]{   0,   0,    7,   5 }
#declare Tailz   = array[4]{   3,   0,    4,  10 }

#declare Tailrad = array[4]{ 0.9, 0.6, 0.45, 0.45 }

#declare HeadAngle = 0;
#declare HeadRoll  = 0;

/* Jaw */
////#declare JawAngle = (60*JawAngle - 15);
////#declare JawAngle = 0.5;
//#declare JawAngle = clock;
#declare JawAngle = 1;

/* Ears */
#declare Ear1Rot = 0;
//#declare Ear1Rot = clock;
#declare Ear2Rot = 0;
//#declare Ear2Rot = clock;
#declare Ear1Height = 1 - clock;
#declare Ear2Height = 1 - clock;

/* Eyes */
#declare LEyeOpen = 1;
#declare REyeOpen = 1;

/* Left Arm */
//#declare LArmAngle = 0;
//#declare LArmAngle = 30;
#declare LArmAngle = 30*clock;
//#declare LForearmAngle = 0;
#declare LForearmAngle = 30*(1 - clock);
//#declare LFrontPawAngle = 0;
#declare LFrontPawAngle = 30*clock;

/* Right Arm */
//#declare RArmAngle =  0;
#declare RArmAngle = 30*(1 - clock);
//#declare RForearmAngle =  0;
#declare RForearmAngle = 30*clock;
//#declare RFrontPawAngle = 0;
#declare RFrontPawAngle = 30*(1 - clock);

/* Left Leg */
#declare LThighAngle =  0;
//#declare LThighAngle = 30;
//#declare LThighAngle = 30*(1 - clock);
#declare LHeelAngle =  0;
//#declare LHeelAngle = 30*clock;
#declare LHindPawAngle = 0;
//#declare LHindPawAngle = 30*(1 - clock);

/* Right Leg */
#declare RThighAngle =  0;
//#declare RThighAngle = 30;
//#declare RThighAngle = 30*(1 - clock);
#declare RHeelAngle =  0;
//#declare RHeelAngle = 30*clock;
#declare RHindPawAngle = 0;
//#declare RHindPawAngle = 30*(1 - clock);

#include "cat.inc"
//#include "cathand.inc"

////union {
    object { Cat translate 10*in*y }
////    plane { y, 0 pigment { checker color Black color Green scale 10 } }
////}
////object { Cat translate 10*in*y translate 17*in*y }

//object { Hand rotate 90*y translate 10*in*y }

//object { Cat_Head }

/**************/
/* Room Scene */
/**************/

//#include "catscene.inc"

